/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.PICTImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PICTImageReaderSpi
extends ImageReaderSpi {
    public PICTImageReaderSpi() {
        this(IIOUtil.getProviderInfo(PICTImageReaderSpi.class));
    }

    private PICTImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"pct", "PCT", "pict", "PICT"}, new String[]{"pct", "pict"}, new String[]{"image/pict", "image/x-pict"}, "com.twelvemkonkeys.imageio.plugins.pict.PICTImageReader", STANDARD_INPUT_TYPE, new String[]{"com.twelvemkonkeys.imageio.plugins.pict.PICTImageWriterSpi"}, true, null, null, null, null, true, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            if (this.isPICT(imageInputStream)) {
                return true;
            }
            imageInputStream.reset();
            PICTImageReader.skipNullHeader(imageInputStream);
            boolean bl = this.isPICT(imageInputStream);
            return bl;
        }
        catch (EOFException eOFException) {
            return false;
        }
        finally {
            imageInputStream.reset();
        }
    }

    private boolean isPICT(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.readUnsignedShort();
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        if (n4 - n2 < 0 || n3 - n < 0) {
            return false;
        }
        int n5 = imageInputStream.readInt();
        return (n5 & 0xFFFF0000) == 0x11010000 || n5 == 1114879;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new PICTImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Apple Mac Paint Picture (PICT) image reader";
    }
}

