/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.pict.BitMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.PICTUtil;
import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import com.twelvemonkeys.imageio.plugins.pict.QuickDrawContext;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBits16Decoder;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class PICTImageReader
extends ImageReaderBase {
    static boolean DEBUG = false;
    private QuickDrawContext mContext;
    private Rectangle mFrame;
    private int mVersion;
    private Point mPenPosition = new Point(0, 0);
    private Rectangle mLastRectangle = new Rectangle(0, 0);
    private double mScreenImageXRatio;
    private double mScreenImageYRatio;
    private List<BufferedImage> mImages = new ArrayList<BufferedImage>();
    private long mImageStartStreamPos;
    protected int mPicSize;

    public PICTImageReader() {
        this(null);
    }

    protected PICTImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    protected void resetMembers() {
        this.mContext = null;
        this.mFrame = null;
        this.mImages.clear();
    }

    private Rectangle getPICTFrame() throws IOException {
        if (this.mFrame == null) {
            this.readPICTHeader(this.mImageInput);
            if (DEBUG) {
                System.out.println("Done reading PICT header!");
            }
        }
        return this.mFrame;
    }

    private void readPICTHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        try {
            this.readPICTHeader0(imageInputStream);
        }
        catch (IIOException iIOException) {
            imageInputStream.seek(0L);
            PICTImageReader.skipNullHeader(imageInputStream);
            this.readPICTHeader0(imageInputStream);
        }
    }

    private void readPICTHeader0(ImageInputStream imageInputStream) throws IOException {
        this.mPicSize = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.println("picSize: " + this.mPicSize);
        }
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        this.mFrame = new Rectangle(n2, n, n4 - n2, n3 - n);
        if (this.mFrame.width < 0 || this.mFrame.height < 0) {
            throw new IIOException("Error in PICT header: Invalid frame " + this.mFrame);
        }
        if (DEBUG) {
            System.out.println("mFrame: " + this.mFrame);
        }
        this.mScreenImageXRatio = 1.0;
        this.mScreenImageYRatio = 1.0;
        boolean bl = false;
        short s = imageInputStream.readShort();
        if (DEBUG) {
            System.out.println(String.format("PICT version: 0x%04x", s));
        }
        if (s == 4353) {
            this.mVersion = 1;
        } else if (s == 17 && imageInputStream.readShort() == 767) {
            this.mVersion = 2;
            if (imageInputStream.readShort() != 3072) {
                throw new IIOException("Error in PICT header: Invalid HeaderOp, expected 0x0c00");
            }
            int n5 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(String.format("headerVersion: 0x%04x", n5));
            }
            if ((n5 & 0xFFFF0000) != -131072) {
                double d = PICTUtil.readFixedPoint(imageInputStream);
                double d2 = PICTUtil.readFixedPoint(imageInputStream);
                double d3 = PICTUtil.readFixedPoint(imageInputStream);
                double d4 = PICTUtil.readFixedPoint(imageInputStream);
                this.mScreenImageXRatio = (double)(n4 - n2) / (d3 - d2);
                this.mScreenImageYRatio = (double)(n3 - n) / (d4 - d);
                if (this.mScreenImageXRatio < 0.0 || this.mScreenImageYRatio < 0.0) {
                    throw new IIOException("Error in PICT header: Invalid bounds " + new Rectangle2D.Double(d2, d, d3 - d2, d4 - d));
                }
                if (DEBUG) {
                    System.out.println("bounding rect: " + new Rectangle2D.Double(d2, d, d3 - d2, d4 - d));
                }
                imageInputStream.skipBytes(4);
            } else {
                bl = true;
                double d = PICTUtil.readFixedPoint(imageInputStream);
                double d5 = PICTUtil.readFixedPoint(imageInputStream);
                if (DEBUG) {
                    System.out.println("xResolution: " + d);
                    System.out.println("yResolution: " + d5);
                }
                short s2 = imageInputStream.readShort();
                short s3 = imageInputStream.readShort();
                short s4 = imageInputStream.readShort();
                short s5 = imageInputStream.readShort();
                this.mScreenImageXRatio = (double)(n4 - n2) / (double)(s5 - s3);
                this.mScreenImageYRatio = (double)(n3 - n) / (double)(s4 - s2);
                if (this.mScreenImageXRatio < 0.0 || this.mScreenImageYRatio < 0.0) {
                    throw new IIOException("Error in PICT header: Invalid bounds " + new Rectangle2D.Double(s3, s2, s5 - s3, s4 - s2));
                }
                if (DEBUG) {
                    System.out.println("bounding rect: " + new Rectangle(s3, s2, s5 - s3, s4 - s2));
                }
                imageInputStream.skipBytes(4);
            }
            if (DEBUG) {
                System.out.println("screenImageXRatio: " + this.mScreenImageXRatio);
                System.out.println("screenImageYRatio: " + this.mScreenImageYRatio);
            }
        } else {
            throw new IIOException("Error in PICT header: Missing or unknown version information");
        }
        if (DEBUG) {
            System.out.println("Version: " + this.mVersion + (bl ? " extended" : ""));
        }
        this.mImageStartStreamPos = imageInputStream.getStreamPosition();
        imageInputStream.flushBefore(this.mImageStartStreamPos);
    }

    static void skipNullHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.skipBytes(512);
    }

    private void drawOnto(Graphics2D graphics2D) throws IOException {
        this.mContext = new QuickDrawContext(graphics2D);
        this.readPICTopcodes(this.mImageInput);
        if (DEBUG) {
            System.out.println("Done reading PICT body!");
        }
    }

    private void readPICTopcodes(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(this.mImageStartStreamPos);
        byte[] byArray = new byte[6];
        Pattern pattern = QuickDraw.BLACK;
        Color color = Color.RED;
        Point point = new Point();
        Point point2 = new Point();
        Rectangle rectangle = new Rectangle();
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        int n = 0;
        try {
            int n2;
            block196: do {
                if (this.mVersion == 1) {
                    n2 = imageInputStream.readUnsignedByte();
                } else {
                    if ((imageInputStream.getStreamPosition() & 1L) > 0L) {
                        imageInputStream.readByte();
                    }
                    n2 = imageInputStream.readUnsignedShort();
                }
                switch (n2) {
                    case 0: {
                        if (!DEBUG) continue block196;
                        System.out.println("NOP");
                        break;
                    }
                    case 1: {
                        polygon2 = this.readRegion(imageInputStream, rectangle);
                        if (polygon2 == null) {
                            throw new IIOException("Could not read region");
                        }
                        if (!DEBUG) continue block196;
                        this.verboseRegionCmd("clipRgn", rectangle, polygon2);
                        break;
                    }
                    case 2: {
                        this.mContext.setBackgroundPattern(PICTUtil.readPattern(imageInputStream));
                        if (!DEBUG) continue block196;
                        System.out.println("bkPat");
                        break;
                    }
                    case 3: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("txFont");
                        break;
                    }
                    case 4: {
                        byte by = imageInputStream.readByte();
                        if (!DEBUG) continue block196;
                        System.out.println("txFace: " + by);
                        break;
                    }
                    case 5: {
                        byte[] byArray2 = new byte[2];
                        imageInputStream.readFully(byArray2, 0, byArray2.length);
                        if (!DEBUG) continue block196;
                        System.out.println("txMode: " + byArray2[0] + ", " + byArray2[1]);
                        break;
                    }
                    case 6: {
                        imageInputStream.readFully(new byte[4], 0, 4);
                        if (!DEBUG) continue block196;
                        System.out.println("spExtra");
                        break;
                    }
                    case 7: {
                        Dimension dimension = new Dimension(imageInputStream.readUnsignedShort(), imageInputStream.readUnsignedShort());
                        this.mContext.setPenSize(dimension);
                        if (!DEBUG) continue block196;
                        System.out.println("pnsize: " + dimension);
                        break;
                    }
                    case 8: {
                        int n3 = imageInputStream.readUnsignedShort();
                        if (DEBUG) {
                            System.out.println("pnMode: " + n3);
                        }
                        this.mContext.setPenMode(n3);
                        break;
                    }
                    case 9: {
                        this.mContext.setPenPattern(PICTUtil.readPattern(imageInputStream));
                        if (!DEBUG) continue block196;
                        System.out.println("pnPat");
                        break;
                    }
                    case 10: {
                        pattern = PICTUtil.readPattern(imageInputStream);
                        if (!DEBUG) continue block196;
                        System.out.println("fillPat");
                        break;
                    }
                    case 11: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        point.setLocation(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("ovSize: " + point);
                        break;
                    }
                    case 12: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("Origin: " + point3);
                        break;
                    }
                    case 13: {
                        int n6 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        this.mContext.setTextSize(n6);
                        if (!DEBUG) continue block196;
                        System.out.println("txSize: " + n6);
                        break;
                    }
                    case 14: {
                        imageInputStream.readInt();
                        if (!DEBUG) continue block196;
                        System.out.println("fgColor");
                        break;
                    }
                    case 15: {
                        imageInputStream.readInt();
                        if (!DEBUG) continue block196;
                        System.out.println("bgColor");
                        break;
                    }
                    case 16: {
                        imageInputStream.readFully(new byte[8], 0, 8);
                        if (!DEBUG) continue block196;
                        System.out.println("txRatio");
                        break;
                    }
                    case 17: {
                        imageInputStream.readFully(new byte[1], 0, 1);
                        if (!DEBUG) continue block196;
                        System.out.println("opVersion");
                        break;
                    }
                    case 18: {
                        Pattern pattern2 = PICTUtil.readColorPattern(imageInputStream);
                        this.mContext.setBackgroundPattern(pattern2);
                        break;
                    }
                    case 19: {
                        Pattern pattern3 = PICTUtil.readColorPattern(imageInputStream);
                        this.mContext.setBackgroundPattern(pattern3);
                        break;
                    }
                    case 20: {
                        pattern = PICTUtil.readColorPattern(imageInputStream);
                        this.mContext.setBackgroundPattern(pattern);
                        break;
                    }
                    case 21: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("opPnLocHFrac");
                        break;
                    }
                    case 22: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("opChExtra");
                        break;
                    }
                    case 26: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        Color color2 = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block196;
                        System.out.println("rgbFgColor: " + color2);
                        break;
                    }
                    case 27: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        Color color3 = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block196;
                        System.out.println("rgbBgColor: " + color3);
                        break;
                    }
                    case 28: {
                        this.mContext.setPenPattern(new BitMapPattern(color));
                        if (!DEBUG) continue block196;
                        System.out.println("opHiliteMode");
                        break;
                    }
                    case 29: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        color = new Color(byArray[0] & 0xFF, byArray[2] & 0xFF, byArray[4] & 0xFF);
                        if (!DEBUG) continue block196;
                        System.out.println("opHiliteColor: " + color);
                        break;
                    }
                    case 30: {
                        color = Color.red;
                        if (!DEBUG) continue block196;
                        System.out.println("opDefHilite");
                        break;
                    }
                    case 31: {
                        imageInputStream.readFully(byArray, 0, byArray.length);
                        if (!DEBUG) continue block196;
                        System.out.println("opOpColor");
                        break;
                    }
                    case 32: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n5, n4);
                        n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.mPenPosition.setLocation(n5, n4);
                        this.mContext.moveTo(point3);
                        this.mContext.lineTo(this.mPenPosition);
                        if (!DEBUG) continue block196;
                        System.out.println("line from: " + point3 + " to: " + this.mPenPosition);
                        break;
                    }
                    case 33: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.mContext.line(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("lineFrom to: " + this.mPenPosition);
                        break;
                    }
                    case 34: {
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        Point point3 = new Point(n5, n4);
                        n4 = this.getYPtCoord(imageInputStream.readByte());
                        n5 = this.getXPtCoord(imageInputStream.readByte());
                        Point point4 = new Point(n5, n4);
                        this.mPenPosition.setLocation(point3.x + point4.x, point3.y + point4.y);
                        this.mContext.lineTo(this.mPenPosition);
                        if (!DEBUG) continue block196;
                        System.out.println("Short line origin: " + point3 + ", dh,dv: " + point4);
                        break;
                    }
                    case 35: {
                        int n4 = this.getYPtCoord(imageInputStream.readByte());
                        int n5 = this.getXPtCoord(imageInputStream.readByte());
                        this.mContext.line(n5, n4);
                        if (!DEBUG) continue block196;
                        System.out.println("Short line from dh,dv: " + n5 + "," + n4);
                        break;
                    }
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 40: {
                        Point point3;
                        int n4 = this.getYPtCoord(imageInputStream.readUnsignedShort());
                        int n5 = this.getXPtCoord(imageInputStream.readUnsignedShort());
                        this.mPenPosition = point3 = new Point(n5, n4);
                        this.mContext.moveTo(this.mPenPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.mContext.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("longText origin: " + this.mPenPosition + ", text:" + string);
                        break;
                    }
                    case 41: {
                        int n8 = this.getXPtCoord(imageInputStream.readByte());
                        this.mPenPosition.translate(n8, 0);
                        this.mContext.moveTo(this.mPenPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.mContext.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("DHText dh: " + n8 + ", text:" + string);
                        break;
                    }
                    case 42: {
                        int n9 = this.getYPtCoord(imageInputStream.readByte());
                        this.mPenPosition.translate(0, n9);
                        this.mContext.moveTo(this.mPenPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.mContext.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("DVText dv: " + n9 + ", text:" + string);
                        break;
                    }
                    case 43: {
                        int n4 = this.getYPtCoord(imageInputStream.readByte());
                        int n5 = this.getXPtCoord(imageInputStream.readByte());
                        this.mPenPosition.translate(n5, n4);
                        this.mContext.moveTo(this.mPenPosition);
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.mContext.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("DHDVText penPosition: " + this.mPenPosition + ", text:" + string);
                        break;
                    }
                    case 44: {
                        imageInputStream.readShort();
                        imageInputStream.readUnsignedShort();
                        String string = PICTUtil.readPascalString(imageInputStream);
                        this.mContext.drawString(string);
                        if (!DEBUG) continue block196;
                        System.out.println("fontName: \"" + string + "\"");
                        break;
                    }
                    case 45: {
                        imageInputStream.readFully(new byte[10], 0, 10);
                        if (!DEBUG) continue block196;
                        System.out.println("opLineJustify");
                        break;
                    }
                    case 46: {
                        imageInputStream.readFully(new byte[6], 0, 6);
                        if (!DEBUG) continue block196;
                        System.out.println("glyphState");
                        break;
                    }
                    case 47: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        this.readRectangle(imageInputStream, this.mLastRectangle);
                    }
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: {
                        switch (n2) {
                            case 48: 
                            case 56: {
                                this.mContext.frameRect(this.mLastRectangle);
                                break;
                            }
                            case 49: 
                            case 57: {
                                this.mContext.paintRect(this.mLastRectangle);
                                break;
                            }
                            case 50: 
                            case 58: {
                                this.mContext.eraseRect(this.mLastRectangle);
                                break;
                            }
                            case 51: 
                            case 59: {
                                this.mContext.invertRect(this.mLastRectangle);
                                break;
                            }
                            case 52: 
                            case 60: {
                                this.mContext.fillRect(this.mLastRectangle, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 48: {
                                System.out.println("frameRect: " + this.mLastRectangle);
                                break;
                            }
                            case 49: {
                                System.out.println("paintRect: " + this.mLastRectangle);
                                break;
                            }
                            case 50: {
                                System.out.println("eraseRect: " + this.mLastRectangle);
                                break;
                            }
                            case 51: {
                                System.out.println("invertRect: " + this.mLastRectangle);
                                break;
                            }
                            case 52: {
                                System.out.println("fillRect: " + this.mLastRectangle);
                                break;
                            }
                            case 56: {
                                System.out.println("frameSameRect: " + this.mLastRectangle);
                                break;
                            }
                            case 57: {
                                System.out.println("paintSameRect: " + this.mLastRectangle);
                                break;
                            }
                            case 58: {
                                System.out.println("eraseSameRect: " + this.mLastRectangle);
                                break;
                            }
                            case 59: {
                                System.out.println("invertSameRect: " + this.mLastRectangle);
                                break;
                            }
                            case 60: {
                                System.out.println("fillSameRect: " + this.mLastRectangle);
                            }
                        }
                        continue block196;
                    }
                    case 61: 
                    case 62: 
                    case 63: {
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        this.readRectangle(imageInputStream, this.mLastRectangle);
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: {
                        switch (n2) {
                            case 64: 
                            case 72: {
                                this.mContext.frameRoundRect(this.mLastRectangle, point.x, point.y);
                                break;
                            }
                            case 65: 
                            case 73: {
                                this.mContext.paintRoundRect(this.mLastRectangle, point.x, point.y);
                                break;
                            }
                            case 66: 
                            case 74: {
                                this.mContext.eraseRoundRect(this.mLastRectangle, point.x, point.y);
                                break;
                            }
                            case 67: 
                            case 75: {
                                this.mContext.invertRoundRect(this.mLastRectangle, point.x, point.y);
                                break;
                            }
                            case 68: 
                            case 76: {
                                this.mContext.fillRoundRect(this.mLastRectangle, point.x, point.y, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 64: {
                                System.out.println("frameRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 65: {
                                System.out.println("paintRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 66: {
                                System.out.println("eraseRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 67: {
                                System.out.println("invertRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 68: {
                                System.out.println("fillRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 72: {
                                System.out.println("frameSameRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 73: {
                                System.out.println("paintSameRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 74: {
                                System.out.println("eraseSameRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 75: {
                                System.out.println("invertSameRRect: " + this.mLastRectangle);
                                break;
                            }
                            case 76: {
                                System.out.println("fillSameRRect: " + this.mLastRectangle);
                            }
                        }
                        continue block196;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        this.readRectangle(imageInputStream, this.mLastRectangle);
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: {
                        switch (n2) {
                            case 80: 
                            case 88: {
                                this.mContext.frameOval(this.mLastRectangle);
                                break;
                            }
                            case 81: 
                            case 89: {
                                this.mContext.paintOval(this.mLastRectangle);
                                break;
                            }
                            case 82: 
                            case 90: {
                                this.mContext.eraseOval(this.mLastRectangle);
                                break;
                            }
                            case 83: 
                            case 91: {
                                this.mContext.invertOval(this.mLastRectangle);
                                break;
                            }
                            case 84: 
                            case 92: {
                                this.mContext.fillOval(this.mLastRectangle, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 80: {
                                System.out.println("frameOval: " + this.mLastRectangle);
                                break;
                            }
                            case 81: {
                                System.out.println("paintOval: " + this.mLastRectangle);
                                break;
                            }
                            case 82: {
                                System.out.println("eraseOval: " + this.mLastRectangle);
                                break;
                            }
                            case 83: {
                                System.out.println("invertOval: " + this.mLastRectangle);
                                break;
                            }
                            case 84: {
                                System.out.println("fillOval: " + this.mLastRectangle);
                                break;
                            }
                            case 88: {
                                System.out.println("frameSameOval: " + this.mLastRectangle);
                                break;
                            }
                            case 89: {
                                System.out.println("paintSameOval: " + this.mLastRectangle);
                                break;
                            }
                            case 90: {
                                System.out.println("eraseSameOval: " + this.mLastRectangle);
                                break;
                            }
                            case 91: {
                                System.out.println("invertSameOval: " + this.mLastRectangle);
                                break;
                            }
                            case 92: {
                                System.out.println("fillSameOval: " + this.mLastRectangle);
                            }
                        }
                        continue block196;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 85: 
                    case 86: 
                    case 87: {
                        imageInputStream.readFully(new byte[8], 0, 8);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: {
                        this.readRectangle(imageInputStream, this.mLastRectangle);
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: {
                        int n5 = imageInputStream.readUnsignedShort();
                        int n4 = imageInputStream.readUnsignedShort();
                        point2.setLocation(n5, n4);
                        switch (n2) {
                            case 96: 
                            case 104: {
                                this.mContext.frameArc(this.mLastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 97: 
                            case 105: {
                                this.mContext.paintArc(this.mLastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 98: 
                            case 106: {
                                this.mContext.eraseArc(this.mLastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 99: 
                            case 107: {
                                this.mContext.invertArc(this.mLastRectangle, point2.x, point2.y);
                                break;
                            }
                            case 100: 
                            case 108: {
                                this.mContext.fillArc(this.mLastRectangle, point2.x, point2.y, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 96: {
                                System.out.println("frameArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 97: {
                                System.out.println("paintArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 98: {
                                System.out.println("eraseArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 99: {
                                System.out.println("invertArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 100: {
                                System.out.println("fillArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 104: {
                                System.out.println("frameSameArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 105: {
                                System.out.println("paintSameArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 106: {
                                System.out.println("eraseSameArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 107: {
                                System.out.println("invertSameArc: " + this.mLastRectangle + ", angles:" + point2);
                                break;
                            }
                            case 108: {
                                System.out.println("fillSameArc: " + this.mLastRectangle + ", angles:" + point2);
                            }
                        }
                        continue block196;
                    }
                    case 101: 
                    case 102: 
                    case 103: {
                        imageInputStream.readFully(new byte[12], 0, 12);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 109: 
                    case 110: 
                    case 111: {
                        imageInputStream.readFully(new byte[4], 0, 4);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: {
                        polygon = this.readPoly(imageInputStream, rectangle);
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: {
                        switch (n2) {
                            case 112: 
                            case 120: {
                                this.mContext.framePoly(polygon);
                                break;
                            }
                            case 113: 
                            case 121: {
                                this.mContext.paintPoly(polygon);
                                break;
                            }
                            case 114: 
                            case 122: {
                                this.mContext.erasePoly(polygon);
                                break;
                            }
                            case 115: 
                            case 123: {
                                this.mContext.invertPoly(polygon);
                                break;
                            }
                            case 116: 
                            case 124: {
                                this.mContext.fillPoly(polygon, pattern);
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 112: {
                                this.verbosePolyCmd("framePoly", rectangle, polygon);
                                break;
                            }
                            case 113: {
                                this.verbosePolyCmd("paintPoly", rectangle, polygon);
                                break;
                            }
                            case 114: {
                                this.verbosePolyCmd("erasePoly", rectangle, polygon);
                                break;
                            }
                            case 115: {
                                this.verbosePolyCmd("invertPoly", rectangle, polygon);
                                break;
                            }
                            case 116: {
                                this.verbosePolyCmd("fillPoly", rectangle, polygon);
                                break;
                            }
                            case 120: {
                                this.verbosePolyCmd("frameSamePoly", rectangle, polygon);
                                break;
                            }
                            case 121: {
                                this.verbosePolyCmd("paintSamePoly", rectangle, polygon);
                                break;
                            }
                            case 122: {
                                this.verbosePolyCmd("eraseSamePoly", rectangle, polygon);
                                break;
                            }
                            case 123: {
                                this.verbosePolyCmd("invertSamePoly", rectangle, polygon);
                                break;
                            }
                            case 124: {
                                this.verbosePolyCmd("fillSamePoly", rectangle, polygon);
                            }
                        }
                        continue block196;
                    }
                    case 117: 
                    case 118: 
                    case 119: {
                        polygon = this.readPoly(imageInputStream, rectangle);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: {
                        polygon2 = this.readRegion(imageInputStream, rectangle);
                    }
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: {
                        if (polygon2 != null && polygon2.npoints > 1) {
                            switch (n2) {
                                case 128: 
                                case 136: {
                                    this.mContext.frameRegion(new Area(polygon2));
                                    break;
                                }
                                case 129: 
                                case 137: {
                                    this.mContext.paintRegion(new Area(polygon2));
                                    break;
                                }
                                case 130: 
                                case 138: {
                                    this.mContext.eraseRegion(new Area(polygon2));
                                    break;
                                }
                                case 131: 
                                case 139: {
                                    this.mContext.invertRegion(new Area(polygon2));
                                    break;
                                }
                                case 132: 
                                case 140: {
                                    this.mContext.fillRegion(new Area(polygon2), pattern);
                                }
                            }
                        }
                        if (!DEBUG) continue block196;
                        switch (n2) {
                            case 128: {
                                this.verboseRegionCmd("frameRgn", rectangle, polygon2);
                                break;
                            }
                            case 129: {
                                this.verboseRegionCmd("paintRgn", rectangle, polygon2);
                                break;
                            }
                            case 130: {
                                this.verboseRegionCmd("eraseRgn", rectangle, polygon2);
                                break;
                            }
                            case 131: {
                                this.verboseRegionCmd("invertRgn", rectangle, polygon2);
                                break;
                            }
                            case 132: {
                                this.verboseRegionCmd("fillRgn", rectangle, polygon2);
                                break;
                            }
                            case 136: {
                                this.verboseRegionCmd("frameSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 137: {
                                this.verboseRegionCmd("paintSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 138: {
                                this.verboseRegionCmd("eraseSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 139: {
                                this.verboseRegionCmd("invertSameRgn", rectangle, polygon2);
                                break;
                            }
                            case 140: {
                                this.verboseRegionCmd("fillSameRgn", rectangle, polygon2);
                            }
                        }
                        continue block196;
                    }
                    case 133: 
                    case 134: 
                    case 135: {
                        polygon2 = this.readRegion(imageInputStream, rectangle);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 144: {
                        int n10 = imageInputStream.readUnsignedShort();
                        int n11 = n10 & 0x3FFF;
                        rectangle = new Rectangle();
                        int n4 = imageInputStream.readUnsignedShort();
                        int n5 = imageInputStream.readUnsignedShort();
                        rectangle.setLocation(n5, n4);
                        n4 = imageInputStream.readUnsignedShort();
                        n5 = imageInputStream.readUnsignedShort();
                        rectangle.setSize(n5 - rectangle.x, n4 - rectangle.y);
                        Rectangle rectangle2 = new Rectangle();
                        this.readRectangle(imageInputStream, rectangle2);
                        Rectangle rectangle3 = new Rectangle();
                        this.readRectangle(imageInputStream, rectangle3);
                        int n3 = imageInputStream.readUnsignedShort();
                        this.mContext.setPenMode(n3);
                        if (DEBUG) {
                            System.out.print("bitsRect, rowBytes: " + n11);
                            if ((n10 & 0x8000) > 0) {
                                System.out.print(", it is a PixMap");
                            } else {
                                System.out.print(", it is a BitMap");
                            }
                            System.out.print(", bounds: " + rectangle);
                            System.out.print(", srcRect: " + rectangle2);
                            System.out.print(", dstRect: " + rectangle3);
                            System.out.print(", mode: " + n3);
                            System.out.println();
                        }
                        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 12);
                        byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        int n12 = rectangle.width / 8;
                        int n13 = 0;
                        while (n13 < rectangle.height) {
                            imageInputStream.readFully(byArray3, n13 * n12, n12);
                            imageInputStream.skipBytes(n11 - n12);
                            ++n13;
                        }
                        Rectangle rectangle4 = new Rectangle(rectangle2);
                        rectangle4.translate(-rectangle.x, -rectangle.y);
                        this.mContext.copyBits(bufferedImage, rectangle4, rectangle3, n3, null);
                        break;
                    }
                    case 145: {
                        if (!DEBUG) continue block196;
                        System.out.println("bitsRgn");
                        break;
                    }
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 152: {
                        this.readOpPackBitsRect(imageInputStream, rectangle, n++);
                        if (!DEBUG) continue block196;
                        System.out.println("packBitsRect - TODO");
                        break;
                    }
                    case 153: {
                        if (!DEBUG) continue block196;
                        System.out.println("packBitsRgn - TODO");
                        break;
                    }
                    case 154: {
                        this.readOpDirectBitsRect(imageInputStream, rectangle, n++);
                        break;
                    }
                    case 155: {
                        if (!DEBUG) continue block196;
                        System.out.println("directBitsRgn - TODO");
                        break;
                    }
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: {
                        int n7 = imageInputStream.readUnsignedShort();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x", "Reserved for Apple use.", n2));
                        break;
                    }
                    case 160: {
                        imageInputStream.readFully(new byte[2], 0, 2);
                        if (!DEBUG) continue block196;
                        System.out.println("Short comment");
                        break;
                    }
                    case 161: {
                        this.readLongComment(imageInputStream);
                        if (!DEBUG) continue block196;
                        System.out.println("Long comment");
                        break;
                    }
                    case 255: {
                        break;
                    }
                    case 33280: {
                        if (DEBUG) {
                            System.out.println("compressedQuickTime");
                        }
                        this.readCompressedQT(imageInputStream);
                        break;
                    }
                    case 33281: {
                        int n7 = imageInputStream.readInt();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println("unCompressedQuickTime");
                        break;
                    }
                    case 65535: {
                        int n7 = imageInputStream.readInt();
                        imageInputStream.readFully(new byte[n7], 0, n7);
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x - length: %s", "Reserved for Apple use.", n2, n7));
                        break;
                    }
                    default: {
                        int n7;
                        if (n2 >= 160 && n2 <= 175) {
                            n7 = imageInputStream.readUnsignedShort();
                            imageInputStream.readFully(new byte[n7], 0, n7);
                        } else if (n2 >= 176 && n2 <= 207) {
                            n7 = 0;
                        } else if (n2 >= 208 && n2 <= 254) {
                            n7 = imageInputStream.readInt();
                            imageInputStream.readFully(new byte[n7], 0, n7);
                        } else if (n2 >= 256 && n2 <= Short.MAX_VALUE) {
                            n7 = ((n2 & 0xFF00) >> 8) * 2;
                            imageInputStream.skipBytes(n7);
                        } else if (n2 >= 32768 && n2 <= 33023) {
                            n7 = 0;
                        } else if (n2 >= 33024 && n2 <= 33279) {
                            n7 = imageInputStream.readInt();
                            imageInputStream.readFully(new byte[n7], 0, n7);
                        } else {
                            throw new IIOException(String.format("Found unknown opcode: 0x%04x", n2));
                        }
                        if (!DEBUG) continue block196;
                        System.out.println(String.format("%s: 0x%04x - length: %s", "Reserved for Apple use.", n2, n7));
                    }
                }
            } while (n2 != 255);
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (EOFException eOFException) {
            String string;
            try {
                string = String.format("position %d", this.mImageInput.getStreamPosition());
            }
            catch (IOException iOException) {
                string = "unknown position";
            }
            throw new IIOException(String.format("Error in PICT format: Unexpected end of File at %s", string), eOFException);
        }
        catch (IOException iOException) {
            throw new IIOException(String.format("Error in PICT format: %s", iOException.getMessage()), iOException);
        }
    }

    private void readCompressedQT(ImageInputStream imageInputStream) throws IOException {
        int n;
        int n2;
        int n3 = imageInputStream.readInt();
        long l = imageInputStream.getStreamPosition();
        if (DEBUG) {
            System.out.println("QT data length: " + n3);
        }
        int n4 = 0;
        while (n4 < 13) {
            n2 = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(String.format("%2d: 0x%08x", n4 * 4, n2));
            }
            ++n4;
        }
        Rectangle rectangle = new Rectangle();
        this.readRectangle(imageInputStream, rectangle);
        if (DEBUG) {
            System.out.println("...");
        }
        n2 = 0;
        while (n2 < 2) {
            n = imageInputStream.readInt();
            if (DEBUG) {
                System.out.println(String.format("%2d: 0x%08x", (n2 + 15) * 4, n));
            }
            ++n2;
        }
        BufferedImage bufferedImage = QuickTime.decompress(imageInputStream);
        if (bufferedImage != null) {
            this.mContext.copyBits(bufferedImage, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()), rectangle, 0, null);
            imageInputStream.seek(l + (long)n3);
            n = imageInputStream.readInt();
            if (n == 458926) {
                int n5 = imageInputStream.readUnsignedShort();
                imageInputStream.skipBytes(n5);
            } else {
                imageInputStream.seek(l + (long)n3);
            }
        } else {
            imageInputStream.seek(l + (long)n3);
        }
    }

    private void readOpPackBitsRect(ImageInputStream imageInputStream, Rectangle rectangle, int n) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        Object object2;
        if (DEBUG) {
            System.out.println("packBitsRect");
        }
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = n2 & 0x3FFF;
        if (DEBUG) {
            System.out.print("packBitsRect, rowBytes: " + n3);
            if ((n2 & 0x8000) > 0) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        int n4 = imageInputStream.readUnsignedShort();
        int n5 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n5 - rectangle.x, n4 - rectangle.y);
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
        }
        int n6 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", pmVersion: " + n6);
        }
        int n7 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", packType: " + n7);
        }
        int n8 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.println(", packSize: " + n8);
        }
        double d = PICTUtil.readFixedPoint(imageInputStream);
        double d2 = PICTUtil.readFixedPoint(imageInputStream);
        if (DEBUG) {
            System.out.print("hRes: " + d + ", vRes: " + d2);
        }
        int n9 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            if (n9 == 0) {
                System.out.print(", indexed pixels");
            } else {
                System.out.print(", RGBDirect");
            }
        }
        int n10 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", pixelSize:" + n10);
        }
        int n11 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", cmpCount:" + n11);
        }
        int n12 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", cmpSize:" + n12);
        }
        int n13 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.print(", planeBytes:" + n13);
        }
        int n14 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.println(", clutId:" + n14);
        }
        imageInputStream.readInt();
        if (n9 != 0) {
            throw new IIOException("Unsupported pixel type: " + n9);
        }
        IndexColorModel indexColorModel = PICTUtil.readColorTable(imageInputStream, n10);
        Rectangle rectangle2 = new Rectangle();
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setSize(n5 - rectangle2.x, n4 - rectangle2.y);
        if (DEBUG) {
            System.out.print("opPackBitsRect, srcRect:" + rectangle2);
        }
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        if (DEBUG) {
            System.out.print(", dstRect:" + rectangle3);
        }
        int n15 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", mode: " + n15);
        }
        if (n7 != 0) {
            throw new IIOException("Unknown pack type: " + n7);
        }
        byte[] byArray = new byte[n11 * rectangle.width];
        byte[] byArray2 = new byte[rectangle.height * rectangle.width];
        int n16 = 0;
        int n17 = 0;
        while (n17 < rectangle.height) {
            int n18 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
            if (DEBUG) {
                System.out.println();
                System.out.print("Line " + n17 + ", byteCount: " + n18);
                System.out.print(" dstBytes: " + byArray.length);
            }
            object2 = new PackBitsDecoder();
            object = new DataInputStream(new DecoderStream(IIOUtil.createStreamAdapter(imageInputStream, n18), (Decoder)object2));
            object.readFully(byArray2, n16, rectangle.width);
            n16 += rectangle.width;
            this.processImageProgress(n17 * 100 / rectangle.height);
            if (this.abortRequested()) {
                this.processReadAborted();
                int n19 = n17 + 1;
                while (n19 < rectangle.height) {
                    n18 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                    imageInputStream.readFully(new byte[n18], 0, n18);
                    if (DEBUG) {
                        System.out.println();
                        System.out.print("Skip " + n19 + ", byteCount: " + n18);
                    }
                    ++n19;
                }
                break;
            }
            ++n17;
        }
        if (this.mImages.size() <= n) {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            object2 = Raster.createPackedRaster(dataBufferByte, rectangle.width, rectangle.height, n12, null);
            object = new BufferedImage(indexColorModel, (WritableRaster)object2, indexColorModel.isAlphaPremultiplied(), null);
            this.mImages.add((BufferedImage)object);
        }
        if ((bufferedImage = this.mImages.get(n)) != null) {
            rectangle2.setLocation(0, 0);
            this.mContext.copyBits(bufferedImage, rectangle2, rectangle3, n15, null);
        }
        if (DEBUG) {
            System.out.println();
        }
    }

    private void readOpDirectBitsRect(ImageInputStream imageInputStream, Rectangle rectangle, int n) throws IOException {
        BufferedImage bufferedImage;
        Object object;
        byte[] byArray;
        if (DEBUG) {
            System.out.println("directBitsRect");
        }
        imageInputStream.skipBytes(4);
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = n2 & 0x3FFF;
        if (DEBUG) {
            System.out.print("directBitsRect, rowBytes: " + n3);
            if ((n2 & 0x8000) > 0) {
                System.out.print(", it is a PixMap");
            } else {
                System.out.print(", it is a BitMap");
            }
        }
        int n4 = imageInputStream.readUnsignedShort();
        int n5 = imageInputStream.readUnsignedShort();
        rectangle.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle.setSize(n5 - rectangle.x, n4 - rectangle.y);
        if (DEBUG) {
            System.out.print(", bounds: " + rectangle);
        }
        int n6 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", pmVersion: " + n6);
        }
        int n7 = imageInputStream.readUnsignedShort() & 0xFFFF;
        if (DEBUG) {
            System.out.print(", packType: " + n7);
        }
        int n8 = imageInputStream.readInt();
        if (DEBUG) {
            System.out.println(", packSize: " + n8);
        }
        double d = PICTUtil.readFixedPoint(imageInputStream);
        double d2 = PICTUtil.readFixedPoint(imageInputStream);
        if (DEBUG) {
            System.out.print("hRes: " + d + ", vRes: " + d2);
        }
        int n9 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            if (n9 == 0) {
                System.out.print(", indexed pixels");
            } else {
                System.out.print(", RGBDirect");
            }
        }
        int n10 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", pixelSize:" + n10);
        }
        int n11 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", cmpCount:" + n11);
        }
        int n12 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.println(", cmpSize:" + n12);
        }
        imageInputStream.readInt();
        imageInputStream.readInt();
        imageInputStream.readInt();
        Rectangle rectangle2 = new Rectangle();
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setLocation(n5, n4);
        n4 = imageInputStream.readUnsignedShort();
        n5 = imageInputStream.readUnsignedShort();
        rectangle2.setSize(n5 - rectangle2.x, n4 - rectangle2.y);
        if (DEBUG) {
            System.out.print("opDirectBitsRect, srcRect:" + rectangle2);
        }
        Rectangle rectangle3 = new Rectangle();
        this.readRectangle(imageInputStream, rectangle3);
        if (DEBUG) {
            System.out.print(", dstRect:" + rectangle3);
        }
        int n13 = imageInputStream.readUnsignedShort();
        if (DEBUG) {
            System.out.print(", mode: " + n13);
        }
        if (n7 == 1 || n3 < 8) {
            byArray = new byte[n3];
        } else if (n7 == 2) {
            byArray = new byte[n3 * 3 / 4];
        } else if (n7 == 3) {
            byArray = new byte[2 * rectangle.width];
        } else if (n7 == 4) {
            byArray = new byte[n11 * rectangle.width];
        } else {
            throw new IIOException("Unknown pack type: " + n7);
        }
        int[] nArray = null;
        short[] sArray = null;
        if (n7 == 3) {
            sArray = new short[rectangle.height * rectangle.width];
        } else {
            nArray = new int[rectangle.height * rectangle.width];
        }
        int n14 = 0;
        int n15 = 0;
        while (n15 < rectangle.height) {
            int n16;
            int n17 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
            if (DEBUG) {
                System.out.println();
                System.out.print("Line " + n15 + ", byteCount: " + n17);
                System.out.print(" dstBytes: " + byArray.length);
            }
            if (n7 > 2) {
                Decoder decoder = n7 == 3 ? new PackBits16Decoder() : new PackBitsDecoder();
                object = new DataInputStream(new DecoderStream(IIOUtil.createStreamAdapter(imageInputStream, n17), decoder));
                object.readFully(byArray);
            } else {
                this.mImageInput.readFully(byArray);
            }
            if (n7 == 3) {
                n16 = 0;
                while (n16 < rectangle.width) {
                    sArray[n14 + n16] = (short)((0xFF & byArray[2 * n16]) << 8 | 0xFF & byArray[2 * n16 + 1]);
                    ++n16;
                }
            } else if (n11 == 3) {
                n16 = 0;
                while (n16 < rectangle.width) {
                    nArray[n14 + n16] = -16777216;
                    int n18 = n14 + n16;
                    nArray[n18] = nArray[n18] | (byArray[n16] & 0xFF) << 16;
                    int n19 = n14 + n16;
                    nArray[n19] = nArray[n19] | (byArray[rectangle.width + n16] & 0xFF) << 8;
                    int n20 = n14 + n16;
                    nArray[n20] = nArray[n20] | byArray[2 * rectangle.width + n16] & 0xFF;
                    ++n16;
                }
            } else {
                n16 = 0;
                while (n16 < rectangle.width) {
                    nArray[n14 + n16] = (byArray[n16] & 0xFF) << 24;
                    int n21 = n14 + n16;
                    nArray[n21] = nArray[n21] | (byArray[rectangle.width + n16] & 0xFF) << 16;
                    int n22 = n14 + n16;
                    nArray[n22] = nArray[n22] | (byArray[2 * rectangle.width + n16] & 0xFF) << 8;
                    int n23 = n14 + n16;
                    nArray[n23] = nArray[n23] | byArray[3 * rectangle.width + n16] & 0xFF;
                    ++n16;
                }
            }
            n14 += rectangle.width;
            this.processImageProgress(n15 * 100 / rectangle.height);
            if (this.abortRequested()) {
                this.processReadAborted();
                n16 = n15 + 1;
                while (n16 < rectangle.height) {
                    n17 = n3 > 250 ? imageInputStream.readUnsignedShort() : imageInputStream.readUnsignedByte();
                    imageInputStream.readFully(new byte[n17], 0, n17);
                    if (DEBUG) {
                        System.out.println();
                        System.out.print("Skip " + n16 + ", byteCount: " + n17);
                    }
                    ++n16;
                }
                break;
            }
            ++n15;
        }
        if (this.mImages.size() <= n) {
            WritableRaster writableRaster;
            DirectColorModel directColorModel;
            if (n7 == 3) {
                directColorModel = new DirectColorModel(15, 31744, 992, 31);
                object = new DataBufferUShort(sArray, sArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle.width, rectangle.height, rectangle.width, directColorModel.getMasks(), null);
            } else {
                directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
                object = new DataBufferInt(nArray, nArray.length);
                writableRaster = Raster.createPackedRaster((DataBuffer)object, rectangle.width, rectangle.height, rectangle.width, directColorModel.getMasks(), null);
            }
            object = new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
            this.mImages.add((BufferedImage)object);
        }
        if ((bufferedImage = this.mImages.get(n)) != null) {
            rectangle2.setLocation(0, 0);
            this.mContext.copyBits(bufferedImage, rectangle2, rectangle3, n13, null);
        }
        if (DEBUG) {
            System.out.println();
        }
    }

    private void readRectangle(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        int n3 = dataInput.readUnsignedShort();
        int n4 = dataInput.readUnsignedShort();
        rectangle.setLocation(this.getXPtCoord(n2), this.getYPtCoord(n));
        rectangle.setSize(this.getXPtCoord(n4 - n2), this.getYPtCoord(n3 - n));
    }

    private Polygon readRegion(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = this.getYPtCoord(dataInput.readUnsignedShort());
        int n3 = this.getXPtCoord(dataInput.readUnsignedShort());
        rectangle.setLocation(n3, n2);
        n2 = this.getYPtCoord(dataInput.readShort()) - rectangle.getLocation().y;
        n3 = this.getXPtCoord(dataInput.readShort()) - rectangle.getLocation().x;
        rectangle.setSize(n3, n2);
        int n4 = (n - 10) / 4;
        Polygon polygon = new Polygon();
        int n5 = 0;
        while (n5 < n4) {
            n3 = this.getXPtCoord(dataInput.readShort());
            n2 = this.getYPtCoord(dataInput.readShort());
            polygon.addPoint(n3, n2);
            ++n5;
        }
        return polygon;
    }

    private Polygon readPoly(DataInput dataInput, Rectangle rectangle) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = this.getYPtCoord(dataInput.readShort());
        int n3 = this.getXPtCoord(dataInput.readShort());
        rectangle.setLocation(n3, n2);
        n2 = this.getYPtCoord(dataInput.readShort()) - rectangle.getLocation().y;
        n3 = this.getXPtCoord(dataInput.readShort()) - rectangle.getLocation().x;
        rectangle.setSize(n3, n2);
        int n4 = (n - 10) / 4;
        Polygon polygon = new Polygon();
        int n5 = 0;
        while (n5 < n4) {
            n2 = this.getYPtCoord(dataInput.readShort());
            n3 = this.getXPtCoord(dataInput.readShort());
            polygon.addPoint(n3, n2);
            ++n5;
        }
        return polygon;
    }

    private void readLongComment(DataInput dataInput) throws IOException {
        dataInput.readShort();
        int n = dataInput.readUnsignedShort();
        dataInput.readFully(new byte[n], 0, n);
    }

    private int getXPtCoord(int n) {
        return (int)((double)n / this.mScreenImageXRatio);
    }

    private int getYPtCoord(int n) {
        return (int)((double)n / this.mScreenImageYRatio);
    }

    private void verbosePolyCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(String.valueOf(string) + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Polygon points: ");
        int n = 0;
        while (polygon != null && n < polygon.npoints - 1) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
            ++n;
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    private void verboseRegionCmd(String string, Rectangle rectangle, Polygon polygon) {
        System.out.println(String.valueOf(string) + ": " + new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        System.out.print("Region points: ");
        int n = 0;
        while (polygon != null && n < polygon.npoints - 1) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + "), ");
            ++n;
        }
        if (polygon != null && polygon.npoints > 0) {
            System.out.print("(" + polygon.xpoints[n] + "," + polygon.ypoints[n] + ")");
        }
        System.out.println();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        this.checkBounds(n);
        this.processImageStarted(n);
        if (imageReadParam != null) {
            n3 = imageReadParam.getSourceXSubsampling();
            n2 = imageReadParam.getSourceYSubsampling();
        } else {
            n3 = 1;
            n2 = 1;
        }
        Rectangle rectangle = this.getPICTFrame();
        BufferedImage bufferedImage = PICTImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.getXPtCoord(rectangle.width), this.getYPtCoord(rectangle.height));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setTransform(AffineTransform.getScaleInstance(this.mScreenImageXRatio / (double)n3, this.mScreenImageYRatio / (double)n2));
            this.drawOnto(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        this.processImageComplete();
        return bufferedImage;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        return this.getXPtCoord(this.getPICTFrame().width);
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        return this.getYPtCoord(this.getPICTFrame().height);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        return Arrays.asList(ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, false)).iterator();
    }
}

