/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class BitMapPattern
extends Pattern {
    BitMapPattern(Paint paint) {
        super(paint);
    }

    public BitMapPattern(byte[] byArray) {
        this(BitMapPattern.create8x8Pattern(byArray));
    }

    BitMapPattern(int n) {
        this(BitMapPattern.create8x8Pattern(n));
    }

    private static TexturePaint create8x8Pattern(int n) {
        WritableRaster writableRaster = QuickDraw.MONOCHROME.createCompatibleWritableRaster(8, 8);
        byte[] byArray = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(n >> 24 & 0xFF);
            byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
            byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
            byArray[n2 + 3] = (byte)(n & 0xFF);
            n2 += 4;
        }
        BufferedImage bufferedImage = new BufferedImage(QuickDraw.MONOCHROME, writableRaster, false, null);
        return new TexturePaint(bufferedImage, new Rectangle(8, 8));
    }

    private static TexturePaint create8x8Pattern(byte[] byArray) {
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, 8), 8, 8, 1, new Point());
        BufferedImage bufferedImage = new BufferedImage(QuickDraw.MONOCHROME, writableRaster, false, null);
        return new TexturePaint(bufferedImage, new Rectangle(8, 8));
    }
}

