/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.imageio.plugins.ico.ICOImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ICOImageReaderSpi
extends ImageReaderSpi {
    public ICOImageReaderSpi() {
        this(IIOUtil.getProviderInfo(ICOImageReaderSpi.class));
    }

    private ICOImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"ico", "ICO"}, new String[]{"ico"}, new String[]{"image/vnd.microsoft.icon", "image/x-icon", "image/ico"}, "com.twelvemonkeys.imageio.plugins.ico.ICOImageReader", STANDARD_INPUT_TYPE, null, true, null, null, null, null, true, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && ICOImageReaderSpi.canDecode((ImageInputStream)object, 1);
    }

    static boolean canDecode(ImageInputStream imageInputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        try {
            imageInputStream.mark();
            imageInputStream.readFully(byArray);
            int n2 = imageInputStream.readByte() + (imageInputStream.readByte() << 8);
            boolean bl = byArray[0] == 0 && byArray[1] == 0 && byArray[2] == n && byArray[3] == 0 && n2 > 0;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new ICOImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Windows Icon Format (ICO) Reader";
    }
}

