/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.ico.BitmapDescriptor;
import com.twelvemonkeys.imageio.plugins.ico.BitmapIndexed;
import com.twelvemonkeys.imageio.plugins.ico.BitmapMask;
import com.twelvemonkeys.imageio.plugins.ico.BitmapRGB;
import com.twelvemonkeys.imageio.plugins.ico.BitmapUnsupported;
import com.twelvemonkeys.imageio.plugins.ico.CURImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.ico.DIBHeader;
import com.twelvemonkeys.imageio.plugins.ico.Directory;
import com.twelvemonkeys.imageio.plugins.ico.DirectoryEntry;
import com.twelvemonkeys.imageio.plugins.ico.ICOImageReaderSpi;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.util.WeakWeakMap;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ICOImageReader
extends ImageReaderBase {
    private Directory mDirectory;
    private Map<DirectoryEntry, DIBHeader> mHeaders = new WeakHashMap<DirectoryEntry, DIBHeader>();
    private Map<DirectoryEntry, BitmapDescriptor> mDescriptors = new WeakWeakMap<DirectoryEntry, BitmapDescriptor>();
    private ImageReader mPNGImageReader;

    public ICOImageReader() {
        this(1);
    }

    ICOImageReader(int n) {
        this(ICOImageReader.createProviderForConstructor(n));
    }

    protected ICOImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    private static ImageReaderSpi createProviderForConstructor(int n) {
        switch (n) {
            case 1: {
                return new ICOImageReaderSpi();
            }
            case 2: {
                return new CURImageReaderSpi();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported ICO/CUR type: %d", n));
    }

    @Override
    protected void resetMembers() {
        this.mDirectory = null;
        this.mHeaders.clear();
        this.mDescriptors.clear();
        if (this.mPNGImageReader != null) {
            this.mPNGImageReader.dispose();
            this.mPNGImageReader = null;
        }
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier;
        DirectoryEntry directoryEntry = this.getEntry(n);
        if (this.isPNG(directoryEntry)) {
            return this.getImageTypesPNG(directoryEntry);
        }
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        DIBHeader dIBHeader = this.getHeader(directoryEntry);
        switch (dIBHeader.getBitCount()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                int n2 = directoryEntry.getOffset() + dIBHeader.getSize();
                if ((long)n2 != this.mImageInput.getStreamPosition()) {
                    this.mImageInput.seek(n2);
                }
                BitmapIndexed bitmapIndexed = new BitmapIndexed(directoryEntry, dIBHeader);
                this.readColorMap(bitmapIndexed);
                imageTypeSpecifier = IndexedImageTypeSpecifier.createFromIndexColorModel(bitmapIndexed.createColorModel());
                break;
            }
            case 16: {
                imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(9);
                break;
            }
            case 24: {
                imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(5);
                break;
            }
            case 32: {
                imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
                break;
            }
            default: {
                throw new IIOException(String.format("Unknown bit depth: %d", dIBHeader.getBitCount()));
            }
        }
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return this.getDirectory().count();
    }

    @Override
    public int getWidth(int n) throws IOException {
        return this.getEntry(n).getWidth();
    }

    @Override
    public int getHeight(int n) throws IOException {
        return this.getEntry(n).getHeight();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage;
        this.checkBounds(n);
        this.processImageStarted(n);
        DirectoryEntry directoryEntry = this.getEntry(n);
        if (this.isPNG(directoryEntry)) {
            bufferedImage = this.readPNG(directoryEntry, imageReadParam);
        } else {
            bufferedImage = this.hasExplicitDestination(imageReadParam) ? ICOImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.getWidth(n), this.getHeight(n)) : null;
            BufferedImage bufferedImage2 = this.readBitmap(directoryEntry);
            if (imageReadParam != null) {
                bufferedImage2 = ICOImageReader.fakeAOI(bufferedImage2, imageReadParam);
                bufferedImage2 = ImageUtil.toBuffered(ICOImageReader.fakeSubsampling(bufferedImage2, imageReadParam));
            }
            if (bufferedImage == null) {
                bufferedImage = bufferedImage2;
            } else {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                try {
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                }
                finally {
                    graphics2D.dispose();
                }
            }
        }
        this.processImageProgress(100.0f);
        this.processImageComplete();
        return bufferedImage;
    }

    private boolean hasExplicitDestination(ImageReadParam imageReadParam) {
        return imageReadParam != null && (imageReadParam.getDestination() != null || imageReadParam.getDestinationType() != null || imageReadParam.getDestinationOffset() != null);
    }

    private boolean isPNG(DirectoryEntry directoryEntry) throws IOException {
        long l;
        this.mImageInput.seek(directoryEntry.getOffset());
        this.mImageInput.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            l = this.mImageInput.readLong();
        }
        finally {
            this.mImageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        return l == -8552249625308161526L;
    }

    private BufferedImage readPNG(DirectoryEntry directoryEntry, ImageReadParam imageReadParam) throws IOException {
        return this.initPNGReader(directoryEntry).read(0, imageReadParam);
    }

    private Iterator<ImageTypeSpecifier> getImageTypesPNG(DirectoryEntry directoryEntry) throws IOException {
        return this.initPNGReader(directoryEntry).getImageTypes(0);
    }

    private ImageReader initPNGReader(DirectoryEntry directoryEntry) throws IOException {
        ImageReader imageReader = this.getPNGReader();
        this.mImageInput.seek(directoryEntry.getOffset());
        InputStream inputStream = IIOUtil.createStreamAdapter(this.mImageInput, directoryEntry.getSize());
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream);
        return imageReader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImageReader getPNGReader() throws IIOException {
        if (this.mPNGImageReader == null) {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("PNG");
            if (!iterator.hasNext()) throw new IIOException("No PNGImageReader found using ImageIO, can't read PNG encoded ICO format.");
            this.mPNGImageReader = iterator.next();
            return this.mPNGImageReader;
        } else {
            this.mPNGImageReader.reset();
        }
        return this.mPNGImageReader;
    }

    private DIBHeader getHeader(DirectoryEntry directoryEntry) throws IOException {
        if (!this.mHeaders.containsKey(directoryEntry)) {
            this.mImageInput.seek(directoryEntry.getOffset());
            DIBHeader dIBHeader = DIBHeader.read(this.mImageInput);
            this.mHeaders.put(directoryEntry, dIBHeader);
        }
        return this.mHeaders.get(directoryEntry);
    }

    private BufferedImage readBitmap(DirectoryEntry directoryEntry) throws IOException {
        BitmapDescriptor bitmapDescriptor = this.mDescriptors.get(directoryEntry);
        if (bitmapDescriptor == null || !this.mDescriptors.containsKey(directoryEntry)) {
            DIBHeader dIBHeader = this.getHeader(directoryEntry);
            int n = directoryEntry.getOffset() + dIBHeader.getSize();
            if ((long)n != this.mImageInput.getStreamPosition()) {
                this.mImageInput.seek(n);
            }
            if (dIBHeader.getCompression() != 0) {
                bitmapDescriptor = new BitmapUnsupported(directoryEntry, String.format("Unsupported compression: %d", dIBHeader.getCompression()));
            } else {
                int n2 = dIBHeader.getBitCount();
                switch (n2) {
                    case 1: 
                    case 4: 
                    case 8: {
                        bitmapDescriptor = new BitmapIndexed(directoryEntry, dIBHeader);
                        this.readBitmapIndexed((BitmapIndexed)bitmapDescriptor);
                        break;
                    }
                    case 16: {
                        bitmapDescriptor = new BitmapRGB(directoryEntry, dIBHeader);
                        this.readBitmap16(bitmapDescriptor);
                        break;
                    }
                    case 24: {
                        bitmapDescriptor = new BitmapRGB(directoryEntry, dIBHeader);
                        this.readBitmap24(bitmapDescriptor);
                        break;
                    }
                    case 32: {
                        bitmapDescriptor = new BitmapRGB(directoryEntry, dIBHeader);
                        this.readBitmap32(bitmapDescriptor);
                        break;
                    }
                    default: {
                        bitmapDescriptor = new BitmapUnsupported(directoryEntry, String.format("Unsupported bit count %d", n2));
                    }
                }
            }
            this.mDescriptors.put(directoryEntry, bitmapDescriptor);
        }
        return bitmapDescriptor.getImage();
    }

    private void readBitmapIndexed(BitmapIndexed bitmapIndexed) throws IOException {
        this.readColorMap(bitmapIndexed);
        switch (bitmapIndexed.getBitCount()) {
            case 1: {
                this.readBitmapIndexed1(bitmapIndexed, false);
                break;
            }
            case 4: {
                this.readBitmapIndexed4(bitmapIndexed);
                break;
            }
            case 8: {
                this.readBitmapIndexed8(bitmapIndexed);
            }
        }
        BitmapMask bitmapMask = new BitmapMask(bitmapIndexed.mEntry, bitmapIndexed.mHeader);
        this.readBitmapIndexed1(bitmapMask.mMask, true);
        bitmapIndexed.setMask(bitmapMask);
    }

    private void readColorMap(BitmapIndexed bitmapIndexed) throws IOException {
        int n = bitmapIndexed.getColorCount();
        int n2 = 0;
        while (n2 < n) {
            bitmapIndexed.mColors[n2] = this.mImageInput.readInt() & 0xFFFFFF | 0xFF000000;
            ++n2;
        }
    }

    private void readBitmapIndexed1(BitmapIndexed bitmapIndexed, boolean bl) throws IOException {
        int n = ICOImageReader.adjustToPadding(bitmapIndexed.getWidth() >> 3);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < bitmapIndexed.getHeight()) {
            this.mImageInput.readFully(byArray, 0, n);
            int n3 = 0;
            int n4 = 128;
            int n5 = (bitmapIndexed.getHeight() - n2 - 1) * bitmapIndexed.getWidth();
            int n6 = 0;
            while (n6 < bitmapIndexed.getWidth()) {
                bitmapIndexed.mBits[n5++] = (byArray[n3] & n4) / n4 & 0xFF;
                if (n4 == 1) {
                    n4 = 128;
                    ++n3;
                } else {
                    n4 >>= 1;
                }
                ++n6;
            }
            if (!bl) {
                if (this.abortRequested()) {
                    this.processReadAborted();
                    break;
                }
                this.processImageProgress((float)(100 * n2) / (float)bitmapIndexed.getHeight());
            }
            ++n2;
        }
    }

    private void readBitmapIndexed4(BitmapIndexed bitmapIndexed) throws IOException {
        int n = ICOImageReader.adjustToPadding(bitmapIndexed.getWidth() >> 1);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < bitmapIndexed.getHeight()) {
            this.mImageInput.readFully(byArray, 0, n);
            int n3 = 0;
            boolean bl = true;
            int n4 = (bitmapIndexed.getHeight() - n2 - 1) * bitmapIndexed.getWidth();
            int n5 = 0;
            while (n5 < bitmapIndexed.getWidth()) {
                int n6;
                if (bl) {
                    n6 = (byArray[n3] & 0xF0) >> 4;
                } else {
                    n6 = byArray[n3] & 0xF;
                    ++n3;
                }
                bitmapIndexed.mBits[n4++] = n6 & 0xFF;
                bl = !bl;
                ++n5;
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * n2) / (float)bitmapIndexed.getHeight());
            ++n2;
        }
    }

    private void readBitmapIndexed8(BitmapIndexed bitmapIndexed) throws IOException {
        int n = ICOImageReader.adjustToPadding(bitmapIndexed.getWidth());
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < bitmapIndexed.getHeight()) {
            this.mImageInput.readFully(byArray, 0, n);
            int n3 = 0;
            int n4 = (bitmapIndexed.getHeight() - n2 - 1) * bitmapIndexed.getWidth();
            int n5 = 0;
            while (n5 < bitmapIndexed.getWidth()) {
                bitmapIndexed.mBits[n4++] = byArray[n3++] & 0xFF;
                ++n5;
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * n2) / (float)bitmapIndexed.getHeight());
            ++n2;
        }
    }

    private static int adjustToPadding(int n) {
        if ((n & 3) != 0) {
            return (n & 0xFFFFFFFC) + 4;
        }
        return n;
    }

    private void readBitmap16(BitmapDescriptor bitmapDescriptor) throws IOException {
        short[] sArray = new short[bitmapDescriptor.getWidth() * bitmapDescriptor.getHeight()];
        DirectColorModel directColorModel = new DirectColorModel(16, 31744, 992, 31);
        DataBufferShort dataBufferShort = new DataBufferShort(sArray, sArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferShort, bitmapDescriptor.getWidth(), bitmapDescriptor.getHeight(), bitmapDescriptor.getWidth(), directColorModel.getMasks(), null);
        bitmapDescriptor.mImage = new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
        int n = 0;
        while (n < bitmapDescriptor.getHeight()) {
            int n2 = (bitmapDescriptor.getHeight() - n - 1) * bitmapDescriptor.getWidth();
            this.mImageInput.readFully(sArray, n2, bitmapDescriptor.getWidth());
            if (bitmapDescriptor.getWidth() % 2 != 0) {
                this.mImageInput.readShort();
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * n) / (float)bitmapDescriptor.getHeight());
            ++n;
        }
    }

    private void readBitmap24(BitmapDescriptor bitmapDescriptor) throws IOException {
        byte[] byArray = new byte[bitmapDescriptor.getWidth() * bitmapDescriptor.getHeight() * 3];
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[]{8, 8, 8};
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[1] = 1;
        int[] nArray3 = nArray2;
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, bitmapDescriptor.getWidth(), bitmapDescriptor.getHeight(), bitmapDescriptor.getWidth(), 3, nArray3, null);
        bitmapDescriptor.mImage = new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
        int n = 0;
        while (n < bitmapDescriptor.getHeight()) {
            int n2 = (bitmapDescriptor.getHeight() - n - 1) * bitmapDescriptor.getWidth();
            this.mImageInput.readFully(byArray, n2, bitmapDescriptor.getWidth() * 3);
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * n) / (float)bitmapDescriptor.getHeight());
            ++n;
        }
    }

    private void readBitmap32(BitmapDescriptor bitmapDescriptor) throws IOException {
        int[] nArray = new int[bitmapDescriptor.getWidth() * bitmapDescriptor.getHeight()];
        DirectColorModel directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, bitmapDescriptor.getWidth(), bitmapDescriptor.getHeight(), bitmapDescriptor.getWidth(), directColorModel.getMasks(), null);
        bitmapDescriptor.mImage = new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
        int n = 0;
        while (n < bitmapDescriptor.getHeight()) {
            int n2 = (bitmapDescriptor.getHeight() - n - 1) * bitmapDescriptor.getWidth();
            this.mImageInput.readFully(nArray, n2, bitmapDescriptor.getWidth());
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * n) / (float)bitmapDescriptor.getHeight());
            ++n;
        }
    }

    private Directory getDirectory() throws IOException {
        this.assertInput();
        if (this.mDirectory == null) {
            this.readFileHeader();
        }
        return this.mDirectory;
    }

    private void readFileHeader() throws IOException {
        this.mImageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.mImageInput.readUnsignedShort();
        int n = this.mImageInput.readUnsignedShort();
        int n2 = this.mImageInput.readUnsignedShort();
        this.mDirectory = Directory.read(n, n2, this.mImageInput);
    }

    final DirectoryEntry getEntry(int n) throws IOException {
        Directory directory = this.getDirectory();
        if (n < 0 || n >= directory.count()) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, ImageCount: %d", n, directory.count()));
        }
        return directory.getEntry(n);
    }
}

