/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import java.awt.Point;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

abstract class DirectoryEntry {
    private int mWidth;
    private int mHeight;
    private int mColorCount;
    int mPlanes;
    int mBitCount;
    private int mSize;
    private int mOffset;

    private DirectoryEntry() {
    }

    public static DirectoryEntry read(int n, DataInput dataInput) throws IOException {
        DirectoryEntry directoryEntry = DirectoryEntry.createEntry(n);
        directoryEntry.read(dataInput);
        return directoryEntry;
    }

    private static DirectoryEntry createEntry(int n) throws IIOException {
        switch (n) {
            case 1: {
                return new ICOEntry();
            }
            case 2: {
                return new CUREntry();
            }
        }
        throw new IIOException(String.format("Unknown DIB type: %s, expected: %s (ICO) or %s (CUR)", n, 1, 2));
    }

    protected void read(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        this.mWidth = n == 0 ? 256 : n;
        int n2 = dataInput.readUnsignedByte();
        this.mHeight = n2 == 0 ? 256 : n2;
        this.mColorCount = dataInput.readUnsignedByte();
        dataInput.readUnsignedByte();
        this.mPlanes = dataInput.readUnsignedShort();
        this.mBitCount = dataInput.readUnsignedShort();
        this.mSize = dataInput.readInt();
        this.mOffset = dataInput.readInt();
    }

    public String toString() {
        return String.format("%s: width: %d, height: %d, colors: %d, planes: %d, bit count: %d, size: %d, offset: %d", this.getClass().getSimpleName(), this.mWidth, this.mHeight, this.mColorCount, this.mPlanes, this.mBitCount, this.mSize, this.mOffset);
    }

    public int getBitCount() {
        return this.mBitCount;
    }

    public int getColorCount() {
        return this.mColorCount;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getPlanes() {
        return this.mPlanes;
    }

    public int getSize() {
        return this.mSize;
    }

    public int getWidth() {
        return this.mWidth;
    }

    /* synthetic */ DirectoryEntry(DirectoryEntry directoryEntry) {
        this();
    }

    static class CUREntry
    extends DirectoryEntry {
        private int mXHotspot;
        private int mYHotspot;

        CUREntry() {
            super(null);
        }

        @Override
        protected void read(DataInput dataInput) throws IOException {
            super.read(dataInput);
            this.mXHotspot = this.mPlanes;
            this.mYHotspot = this.mBitCount;
            this.mPlanes = 1;
            this.mBitCount = 0;
        }

        public Point getHotspot() {
            return new Point(this.mXHotspot, this.mYHotspot);
        }
    }

    static final class ICOEntry
    extends DirectoryEntry {
        ICOEntry() {
            super(null);
        }
    }
}

