/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.imageio.plugins.ico.BitmapDescriptor;
import com.twelvemonkeys.imageio.plugins.ico.BitmapMask;
import com.twelvemonkeys.imageio.plugins.ico.DIBHeader;
import com.twelvemonkeys.imageio.plugins.ico.DirectoryEntry;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

class BitmapIndexed
extends BitmapDescriptor {
    protected final int[] mBits = new int[this.getWidth() * this.getHeight()];
    protected final int[] mColors = new int[this.getColorCount() + 1];
    private BitmapMask mMask;

    public BitmapIndexed(DirectoryEntry directoryEntry, DIBHeader dIBHeader) {
        super(directoryEntry, dIBHeader);
    }

    public BufferedImage createImageIndexed() {
        Object object;
        IndexColorModel indexColorModel = this.createColorModel();
        Hashtable<String, Point> hashtable = null;
        if (this.mEntry instanceof DirectoryEntry.CUREntry) {
            object = (DirectoryEntry.CUREntry)this.mEntry;
            hashtable = new Hashtable<String, Point>(1);
            hashtable.put("cursor_hotspot", ((DirectoryEntry.CUREntry)object).getHotspot());
        }
        object = new BufferedImage(indexColorModel, indexColorModel.createCompatibleWritableRaster(this.getWidth(), this.getHeight()), indexColorModel.isAlphaPremultiplied(), hashtable);
        WritableRaster writableRaster = ((BufferedImage)object).getRaster();
        int n = indexColorModel.getTransparentPixel();
        int n2 = 0;
        while (n2 < this.getHeight()) {
            int n3 = 0;
            while (n3 < this.getWidth()) {
                if (this.mMask.isTransparent(n3, n2)) {
                    this.mBits[n3 + this.getWidth() * n2] = n;
                }
                ++n3;
            }
            ++n2;
        }
        writableRaster.setSamples(0, 0, this.getWidth(), this.getHeight(), 0, this.mBits);
        return object;
    }

    IndexColorModel createColorModel() {
        int n = this.getBitCount();
        int n2 = this.mColors.length;
        int n3 = -1;
        if (n2 > 1 << this.getBitCount()) {
            int n4 = BitmapIndexed.findTransIndexMaybeRemap(this.mColors, this.mBits);
            if (n4 == -1) {
                ++n;
                n3 = this.mColors.length - 1;
            } else {
                n3 = n4;
                --n2;
            }
        }
        return new InverseColorMapIndexColorModel(n, n2, this.mColors, 0, true, n3, n <= 8 ? 0 : 1);
    }

    private static int findTransIndexMaybeRemap(int[] nArray, int[] nArray2) {
        int n;
        boolean[] blArray = new boolean[nArray.length - 1];
        int[] nArray3 = nArray2;
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray3[n3];
            if (!blArray[n]) {
                blArray[n] = true;
            }
            ++n3;
        }
        n = 0;
        while (n < blArray.length) {
            if (!blArray[n]) {
                return n;
            }
            ++n;
        }
        n = -1;
        n3 = -1;
        n2 = 0;
        while (n == -1 && n2 < nArray.length - 1) {
            int n4 = n2 + 1;
            while (n4 < nArray.length - 1) {
                if (nArray[n2] == nArray[n4]) {
                    n = n4;
                    n3 = n2;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (n != -1) {
            n2 = 0;
            while (n2 < nArray2.length) {
                if (nArray2[n2] == n) {
                    nArray2[n2] = n3;
                }
                ++n2;
            }
        }
        return n;
    }

    @Override
    public BufferedImage getImage() {
        if (this.mImage == null) {
            this.mImage = this.createImageIndexed();
        }
        return this.mImage;
    }

    public void setMask(BitmapMask bitmapMask) {
        this.mMask = bitmapMask;
    }
}

