/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.xmp;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.xmp.XMPDirectory;
import com.twelvemonkeys.imageio.metadata.xmp.XMPEntry;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMPReader
extends MetadataReader {
    @Override
    public Directory read(ImageInputStream imageInputStream) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(IIOUtil.createStreamAdapter(imageInputStream)));
            Node node = document.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF").item(0);
            NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            return this.parseDirectories(node, nodeList);
        }
        catch (SAXException sAXException) {
            throw new IIOException(sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private XMPDirectory parseDirectories(Node node, NodeList nodeList) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Node node2 : this.asIterable(nodeList)) {
            if (node2.getParentNode() != node) continue;
            for (Node node3 : this.asIterable(node2.getChildNodes())) {
                Object object;
                Object object2;
                Node node4;
                if (node3.getNodeType() != 1) continue;
                ArrayList<Object> arrayList = (ArrayList<Object>)linkedHashMap.get(node3.getNamespaceURI());
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    linkedHashMap.put(node3.getNamespaceURI(), arrayList);
                }
                if ((node4 = node3.getAttributes().getNamedItemNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null && "Resource".equals(node4.getNodeValue())) {
                    object2 = new ArrayList();
                    for (Node node5 : this.asIterable(node3.getChildNodes())) {
                        if (node5.getNodeType() != 1) continue;
                        object2.add(new XMPEntry(String.valueOf(node5.getNamespaceURI()) + node5.getLocalName(), node5.getLocalName(), this.getChildTextValue(node5)));
                    }
                    object = new XMPDirectory((List<Entry>)object2);
                } else {
                    object = this.getChildTextValue(node3);
                }
                object2 = new XMPEntry(String.valueOf(node3.getNamespaceURI()) + node3.getLocalName(), node3.getLocalName(), object);
                arrayList.add(object2);
            }
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList.add(new XMPEntry((String)entry.getKey(), (Object)new XMPDirectory((List)entry.getValue())));
        }
        return new XMPDirectory((List<Entry>)arrayList);
    }

    private Object getChildTextValue(Node node) {
        Node node2 = node.getFirstChild();
        String string = null;
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        String string2 = string != null ? string.trim() : "";
        return string2;
    }

    private Iterable<? extends Node> asIterable(final NamedNodeMap namedNodeMap) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int mIndex;

                    @Override
                    public boolean hasNext() {
                        return namedNodeMap != null && namedNodeMap.getLength() > this.mIndex;
                    }

                    @Override
                    public Node next() {
                        return namedNodeMap.item(this.mIndex++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Method remove not supported");
                    }
                };
            }
        };
    }

    private Iterable<? extends Node> asIterable(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int mIndex;

                    @Override
                    public boolean hasNext() {
                        return nodeList != null && nodeList.getLength() > this.mIndex;
                    }

                    @Override
                    public Node next() {
                        return nodeList.item(this.mIndex++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Method remove not supported");
                    }
                };
            }
        };
    }
}

