/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

public final class Rational
extends Number
implements Comparable<Rational> {
    static final Rational ZERO = new Rational(0L, 1L);
    private final long mNumerator;
    private final long mDenominator;

    public Rational(long l) {
        this(l, 1L);
    }

    public Rational(long l, long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("denominator == 0");
        }
        if (l == Long.MIN_VALUE || l2 == Long.MIN_VALUE) {
            throw new IllegalArgumentException("value == Long.MIN_VALUE");
        }
        long l3 = Rational.gcd(l, l2);
        long l4 = l / l3;
        long l5 = l2 / l3;
        this.mNumerator = l2 >= 0L ? l4 : -l4;
        this.mDenominator = l2 >= 0L ? l5 : -l5;
    }

    private static long gcd(long l, long l2) {
        if (l < 0L) {
            return Rational.gcd(l2, -l);
        }
        return l2 == 0L ? l : Rational.gcd(l2, l % l2);
    }

    private static long lcm(long l, long l2) {
        if (l < 0L) {
            return Rational.lcm(l2, -l);
        }
        return l * (l2 / Rational.gcd(l, l2));
    }

    public long numerator() {
        return this.mNumerator;
    }

    public long denominator() {
        return this.mDenominator;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return (double)this.mNumerator / (double)this.mDenominator;
    }

    @Override
    public int compareTo(Rational rational) {
        double d;
        double d2 = this.doubleValue();
        return d2 < (d = rational.doubleValue()) ? -1 : (d2 == d ? 0 : 1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.floatValue());
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Rational && this.compareTo((Rational)object) == 0;
    }

    public String toString() {
        return this.mDenominator == 1L ? Long.toString(this.mNumerator) : String.format("%s/%s", this.mNumerator, this.mDenominator);
    }

    public Rational times(Rational rational) {
        if (this.equals(ZERO) || rational.equals(ZERO)) {
            return ZERO;
        }
        Rational rational2 = new Rational(this.mNumerator, rational.mDenominator);
        Rational rational3 = new Rational(rational.mNumerator, this.mDenominator);
        return new Rational(rational2.mNumerator * rational3.mNumerator, rational2.mDenominator * rational3.mDenominator);
    }

    public Rational plus(Rational rational) {
        if (this.equals(ZERO)) {
            return rational;
        }
        if (rational.equals(ZERO)) {
            return this;
        }
        long l = Rational.gcd(this.mNumerator, rational.mNumerator);
        long l2 = Rational.gcd(this.mDenominator, rational.mDenominator);
        return new Rational((this.mNumerator / l * (rational.mDenominator / l2) + rational.mNumerator / l * (this.mDenominator / l2)) * l, Rational.lcm(this.mDenominator, rational.mDenominator));
    }

    public Rational negate() {
        return new Rational(-this.mNumerator, this.mDenominator);
    }

    public Rational minus(Rational rational) {
        return this.plus(rational.negate());
    }

    public Rational reciprocal() {
        return new Rational(this.mDenominator, this.mNumerator);
    }

    public Rational divides(Rational rational) {
        if (rational.equals(ZERO)) {
            throw new ArithmeticException("/ by zero");
        }
        return this.times(rational.reciprocal());
    }
}

