/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.exif.EXIFDirectory;
import com.twelvemonkeys.imageio.metadata.exif.EXIFEntry;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;
import com.twelvemonkeys.lang.StringUtil;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public final class EXIFReader
extends MetadataReader {
    @Override
    public Directory read(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = new byte[2];
        imageInputStream.readFully(byArray);
        if (byArray[0] == 73 && byArray[1] == 73) {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (byArray[0] != 77 || byArray[1] != 77) {
            throw new IIOException(String.format("Invalid TIFF byte order mark '%s', expected: 'II' or 'MM'", StringUtil.decode(byArray, 0, byArray.length, "ASCII")));
        }
        int n = imageInputStream.readUnsignedShort();
        if (n != 42) {
            throw new IIOException(String.format("Wrong TIFF magic in EXIF data: %04x, expected: %04x", n, 42));
        }
        long l = imageInputStream.readUnsignedInt();
        return this.readDirectory(imageInputStream, l);
    }

    private EXIFDirectory readDirectory(ImageInputStream imageInputStream, long l) throws IOException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        imageInputStream.seek(l);
        int n = imageInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.readEntry(imageInputStream));
            ++n2;
        }
        long l2 = imageInputStream.readUnsignedInt();
        if (l2 != 0L) {
            EXIFDirectory eXIFDirectory = this.readDirectory(imageInputStream, l2);
            for (Entry entry : eXIFDirectory) {
                arrayList.add(entry);
            }
        }
        return new EXIFDirectory(arrayList);
    }

    private EXIFEntry readEntry(ImageInputStream imageInputStream) throws IOException {
        Object object;
        int n = imageInputStream.readUnsignedShort();
        short s = imageInputStream.readShort();
        int n2 = imageInputStream.readInt();
        if (n == 34665 || n == 34853 || n == 40965) {
            long l = imageInputStream.readUnsignedInt();
            imageInputStream.mark();
            try {
                object = this.readDirectory(imageInputStream, l);
            }
            finally {
                imageInputStream.reset();
            }
        } else {
            int n3 = this.getValueLength(s, n2);
            if (n3 > 0 && n3 <= 4) {
                object = this.readValueInLine(imageInputStream, s, n2);
                imageInputStream.skipBytes(4 - n3);
            } else {
                long l = imageInputStream.readUnsignedInt();
                object = this.readValue(imageInputStream, l, s, n2);
            }
        }
        return new EXIFEntry(n, object, s);
    }

    private Object readValue(ImageInputStream imageInputStream, long l, short s, int n) throws IOException {
        long l2 = imageInputStream.getStreamPosition();
        try {
            imageInputStream.seek(l);
            Object object = this.readValueInLine(imageInputStream, s, n);
            return object;
        }
        finally {
            imageInputStream.seek(l2);
        }
    }

    private Object readValueInLine(ImageInputStream imageInputStream, short s, int n) throws IOException {
        return EXIFReader.readValueDirect(imageInputStream, s, n);
    }

    private static Object readValueDirect(ImageInputStream imageInputStream, short s, int n) throws IOException {
        switch (s) {
            case 2: {
                byte[] byArray = new byte[n];
                imageInputStream.readFully(byArray);
                return StringUtil.decode(byArray, 0, byArray.length, "UTF-8");
            }
            case 1: {
                if (n == 1) {
                    return imageInputStream.readUnsignedByte();
                }
            }
            case 6: {
                if (n == 1) {
                    return imageInputStream.readByte();
                }
            }
            case 7: {
                byte[] byArray = new byte[n];
                imageInputStream.readFully(byArray);
                return byArray;
            }
            case 3: {
                if (n == 1) {
                    return imageInputStream.readUnsignedShort();
                }
            }
            case 8: {
                if (n == 1) {
                    return imageInputStream.readShort();
                }
                short[] sArray = new short[n];
                imageInputStream.readFully(sArray, 0, sArray.length);
                return sArray;
            }
            case 4: {
                if (n == 1) {
                    return imageInputStream.readUnsignedInt();
                }
            }
            case 9: {
                if (n == 1) {
                    return imageInputStream.readInt();
                }
                int[] nArray = new int[n];
                imageInputStream.readFully(nArray, 0, nArray.length);
                return nArray;
            }
            case 11: {
                if (n == 1) {
                    return Float.valueOf(imageInputStream.readFloat());
                }
                float[] fArray = new float[n];
                imageInputStream.readFully(fArray, 0, fArray.length);
                return fArray;
            }
            case 12: {
                if (n == 1) {
                    return imageInputStream.readDouble();
                }
                double[] dArray = new double[n];
                imageInputStream.readFully(dArray, 0, dArray.length);
                return dArray;
            }
            case 5: {
                if (n == 1) {
                    return new Rational(imageInputStream.readUnsignedInt(), imageInputStream.readUnsignedInt());
                }
                Rational[] rationalArray = new Rational[n];
                int n2 = 0;
                while (n2 < rationalArray.length) {
                    rationalArray[n2] = new Rational(imageInputStream.readUnsignedInt(), imageInputStream.readUnsignedInt());
                    ++n2;
                }
                return rationalArray;
            }
            case 10: {
                if (n == 1) {
                    return new Rational(imageInputStream.readInt(), imageInputStream.readInt());
                }
                Rational[] rationalArray = new Rational[n];
                int n3 = 0;
                while (n3 < rationalArray.length) {
                    rationalArray[n3] = new Rational(imageInputStream.readInt(), imageInputStream.readInt());
                    ++n3;
                }
                return rationalArray;
            }
        }
        throw new IIOException(String.format("Unknown EXIF type '%s'", s));
    }

    private int getValueLength(int n, int n2) {
        if (n > 0 && n <= TIFF.TYPE_LENGTHS.length) {
            return TIFF.TYPE_LENGTHS[n - 1] * n2;
        }
        return -1;
    }
}

