/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;

final class EXIFEntry
extends AbstractEntry {
    private final short mType;

    EXIFEntry(int n, Object object, short s) {
        super(n, object);
        if (s < 1 || s > TIFF.TYPE_NAMES.length) {
            throw new IllegalArgumentException(String.format("Illegal EXIF type: %s", s));
        }
        this.mType = s;
    }

    @Override
    public String getFieldName() {
        switch ((Integer)this.getIdentifier()) {
            case 259: {
                return "Compression";
            }
            case 274: {
                return "Orientation";
            }
            case 282: {
                return "XResolution";
            }
            case 283: {
                return "YResolution";
            }
            case 296: {
                return "ResolutionUnit";
            }
            case 513: {
                return "JPEGInterchangeFormat";
            }
            case 514: {
                return "JPEGInterchangeFormatLength";
            }
            case 305: {
                return "Software";
            }
            case 306: {
                return "DateTime";
            }
            case 315: {
                return "Artist";
            }
            case 33432: {
                return "Copyright";
            }
            case 40961: {
                return "ColorSpace";
            }
            case 40962: {
                return "PixelXDimension";
            }
            case 40963: {
                return "PixelYDimension";
            }
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return TIFF.TYPE_NAMES[this.mType - 1];
    }
}

