/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata;

import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.lang.Validate;
import java.lang.reflect.Array;

public abstract class AbstractEntry
implements Entry {
    private final Object mIdentifier;
    private final Object mValue;

    protected AbstractEntry(Object object, Object object2) {
        Validate.notNull(object, "identifier");
        this.mIdentifier = object;
        this.mValue = object2;
    }

    @Override
    public final Object getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public String getFieldName() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.mValue);
    }

    @Override
    public String getTypeName() {
        if (this.mValue == null) {
            return null;
        }
        return this.mValue.getClass().getSimpleName();
    }

    @Override
    public int valueCount() {
        if (this.mValue != null && this.mValue.getClass().isArray()) {
            return Array.getLength(this.mValue);
        }
        return 1;
    }

    public int hashCode() {
        return this.mIdentifier.hashCode() + 31 * this.mValue.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractEntry)) {
            return false;
        }
        AbstractEntry abstractEntry = (AbstractEntry)object;
        return this.mIdentifier.equals(abstractEntry.mIdentifier) && (this.mValue == null && abstractEntry.mValue == null || this.mValue != null && this.mValue.equals(abstractEntry.mValue));
    }

    public String toString() {
        String string = this.getFieldName();
        String string2 = string != null ? "/" + string : "";
        String string3 = this.getTypeName();
        String string4 = string3 != null ? " (" + string3 + ")" : "";
        return String.format("%s%s: %s%s", this.getIdentifier(), string2, this.getValueAsString(), string4);
    }
}

