/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDirectory
implements Directory {
    private final List<Entry> mEntries = new ArrayList<Entry>();

    protected AbstractDirectory(Collection<? extends Entry> collection) {
        if (collection != null) {
            this.mEntries.addAll(collection);
        }
    }

    @Override
    public Entry getEntryById(Object object) {
        for (Entry entry : this) {
            if (!entry.getIdentifier().equals(object)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Entry getEntryByFieldName(String string) {
        for (Entry entry : this) {
            if (entry.getFieldName() == null || !entry.getFieldName().equals(string)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.mEntries.iterator();
    }

    protected final void assertMutable() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Directory is read-only");
        }
    }

    @Override
    public boolean add(Entry entry) {
        this.assertMutable();
        return this.mEntries.add(entry);
    }

    @Override
    public boolean remove(Object object) {
        this.assertMutable();
        return this.mEntries.remove(object);
    }

    @Override
    public int size() {
        return this.mEntries.size();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public int hashCode() {
        return this.mEntries.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractDirectory abstractDirectory = (AbstractDirectory)object;
        return this.mEntries.equals(abstractDirectory.mEntries);
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.mEntries.toString());
    }
}

