/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio;

import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageReaderBase
extends ImageReader {
    protected ImageInputStream mImageInput;

    protected ImageReaderBase(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        this.resetMembers();
        super.setInput(object, bl, bl2);
        if (object instanceof ImageInputStream) {
            this.mImageInput = (ImageInputStream)object;
        }
    }

    @Override
    public void dispose() {
        this.resetMembers();
        super.dispose();
    }

    @Override
    public void reset() {
        this.resetMembers();
        super.reset();
    }

    protected abstract void resetMembers();

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.assertInput();
        return 1;
    }

    protected void checkBounds(int n) throws IOException {
        this.assertInput();
        if (n < this.getMinIndex()) {
            throw new IndexOutOfBoundsException("index < minIndex");
        }
        if (this.getNumImages(false) != -1 && n >= this.getNumImages(false)) {
            throw new IndexOutOfBoundsException("index >= numImages (" + n + " >= " + this.getNumImages(false) + ")");
        }
    }

    protected void assertInput() {
        if (this.getInput() == null) {
            throw new IllegalStateException("getInput() == null");
        }
    }

    public static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator<ImageTypeSpecifier> iterator, int n, int n2) throws IIOException {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = ImageReader.getDestination(imageReadParam, iterator, n, n2);
        if (imageReadParam != null && (bufferedImage = imageReadParam.getDestination()) != null) {
            boolean bl = false;
            while (iterator.hasNext()) {
                ImageTypeSpecifier imageTypeSpecifier = iterator.next();
                int n3 = imageTypeSpecifier.getBufferedImageType();
                if (n3 != 0 && n3 == bufferedImage.getType()) {
                    bl = true;
                    break;
                }
                if (imageTypeSpecifier.getSampleModel().getTransferType() != bufferedImage.getSampleModel().getTransferType() || imageTypeSpecifier.getNumBands() > bufferedImage.getSampleModel().getNumBands()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IIOException(String.format("Illegal explicit destination image %s", bufferedImage));
            }
        }
        return bufferedImage2;
    }

    protected static BufferedImage fakeAOI(BufferedImage bufferedImage, ImageReadParam imageReadParam) {
        return IIOUtil.fakeAOI(bufferedImage, ImageReaderBase.getSourceRegion(imageReadParam, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    protected static Image fakeSubsampling(Image image, ImageReadParam imageReadParam) {
        return IIOUtil.fakeSubsampling(image, imageReadParam);
    }
}

