/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.InverseColorMap;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.image.IndexColorModel;

public class InverseColorMapIndexColorModel
extends IndexColorModel {
    protected int[] mRGBs;
    protected int mMapSize;
    protected InverseColorMap mInverseMap = null;
    private static final int ALPHA_THRESHOLD = 128;
    private int mWhiteIndex = -1;
    private static final int WHITE = 0xFFFFFF;
    private static final int RGB_MASK = 0xFFFFFF;

    public InverseColorMapIndexColorModel(IndexColorModel indexColorModel) {
        this(indexColorModel, InverseColorMapIndexColorModel.getRGBs(indexColorModel));
    }

    private InverseColorMapIndexColorModel(IndexColorModel indexColorModel, int[] nArray) {
        super(indexColorModel.getComponentSize()[0], indexColorModel.getMapSize(), nArray, 0, ImageUtil.getTransferType(indexColorModel), indexColorModel.getValidPixels());
        this.mRGBs = nArray;
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    private static int[] getRGBs(IndexColorModel indexColorModel) {
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        return nArray;
    }

    public InverseColorMapIndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, n2, nArray, n3, bl, n4, n5);
        this.mRGBs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs, n4);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    public InverseColorMapIndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, n2, byArray, byArray2, byArray3, n3);
        this.mRGBs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs, n3);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    public InverseColorMapIndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n, n2, byArray, byArray2, byArray3);
        this.mRGBs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mMapSize = this.mRGBs.length;
        this.mInverseMap = new InverseColorMap(this.mRGBs);
        this.mWhiteIndex = this.getWhiteIndex();
    }

    private int getWhiteIndex() {
        int n = 0;
        while (n < this.mRGBs.length) {
            int n2 = this.mRGBs[n];
            if ((n2 & 0xFFFFFF) == 0xFFFFFF) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public Object getDataElements(int n, Object object) {
        int n2;
        int n3 = n >>> 24;
        int n4 = n3 < 128 && this.getTransparentPixel() != -1 ? this.getTransparentPixel() : ((n2 = n & 0xFFFFFF) == 0xFFFFFF && this.mWhiteIndex != -1 ? this.mWhiteIndex : this.mInverseMap.getIndexNearest(n2));
        return this.installpixel(object, n4);
    }

    private Object installpixel(Object object, int n) {
        switch (this.transferType) {
            case 3: {
                int[] nArray;
                if (object == null) {
                    nArray = new int[1];
                    object = nArray;
                } else {
                    nArray = (int[])object;
                }
                nArray[0] = n;
                break;
            }
            case 0: {
                byte[] byArray;
                if (object == null) {
                    byArray = new byte[1];
                    object = byArray;
                } else {
                    byArray = (byte[])object;
                }
                byArray[0] = (byte)n;
                break;
            }
            case 1: {
                short[] sArray;
                if (object == null) {
                    sArray = new short[1];
                    object = sArray;
                } else {
                    sArray = (short[])object;
                }
                sArray[0] = (short)n;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return object;
    }

    @Override
    public String toString() {
        return StringUtil.replace(super.toString(), "IndexColorModel: ", String.valueOf(this.getClass().getName()) + ": ");
    }
}

