/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BufferedImageFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class ImageUtil {
    private static final int BI_TYPE_ANY = -1;
    private static boolean VM_SUPPORTS_ACCELERATION = true;
    private static final Component NULL_COMPONENT = new Component(){};
    private static MediaTracker sTracker = new MediaTracker(NULL_COMPONENT);
    protected static final Point LOCATION_UPPER_LEFT = new Point(0, 0);
    private static final boolean COLORMODEL_TRANSFERTYPE_SUPPORTED = ImageUtil.isColorModelTransferTypeSupported();
    private static final GraphicsConfiguration DEFAULT_CONFIGURATION = ImageUtil.getDefaultGraphicsConfiguration();

    private static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!graphicsEnvironment.isHeadlessInstance()) {
                return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            }
        }
        catch (LinkageError linkageError) {
            VM_SUPPORTS_ACCELERATION = false;
        }
        return null;
    }

    private ImageUtil() {
    }

    private static boolean isColorModelTransferTypeSupported() {
        try {
            ColorModel.getRGBdefault().getTransferType();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static BufferedImage toBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (image == null) {
            throw new IllegalArgumentException("original == null");
        }
        BufferedImageFactory bufferedImageFactory = new BufferedImageFactory(image);
        return bufferedImageFactory.getBufferedImage();
    }

    static WritableRaster createRaster(int n, int n2, Object object, ColorModel colorModel) {
        int n3;
        Object object2;
        DataBuffer dataBuffer = null;
        WritableRaster writableRaster = null;
        if (object instanceof int[]) {
            object2 = (int[])object;
            dataBuffer = new DataBufferInt((int[])object2, ((int[])object2).length);
            n3 = colorModel.getNumComponents();
        } else if (object instanceof short[]) {
            object2 = (short[])object;
            dataBuffer = new DataBufferUShort((short[])object2, ((int[])object2).length);
            n3 = ((int[])object2).length / (n * n2);
        } else if (object instanceof byte[]) {
            object2 = (byte[])object;
            dataBuffer = new DataBufferByte((byte[])object2, ((int[])object2).length);
            n3 = colorModel instanceof IndexColorModel ? 1 : ((int[])object2).length / (n * n2);
        } else {
            n3 = -1;
            writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
            writableRaster.setDataElements(0, 0, n, n2, object);
        }
        if (writableRaster == null) {
            if (colorModel instanceof IndexColorModel && ImageUtil.isIndexedPacked((IndexColorModel)colorModel)) {
                writableRaster = Raster.createPackedRaster(dataBuffer, n, n2, colorModel.getPixelSize(), LOCATION_UPPER_LEFT);
            } else if (colorModel instanceof PackedColorModel) {
                object2 = (PackedColorModel)colorModel;
                writableRaster = Raster.createPackedRaster(dataBuffer, n, n2, n, ((PackedColorModel)object2).getMasks(), LOCATION_UPPER_LEFT);
            } else {
                object2 = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    object2[n4++] = n3 - n4;
                }
                writableRaster = Raster.createInterleavedRaster(dataBuffer, n, n2, n * n3, n3, (int[])object2, LOCATION_UPPER_LEFT);
            }
        }
        return writableRaster;
    }

    private static boolean isIndexedPacked(IndexColorModel indexColorModel) {
        return indexColorModel.getPixelSize() == 1 || indexColorModel.getPixelSize() == 2 || indexColorModel.getPixelSize() == 4;
    }

    static void drawOnto(BufferedImage bufferedImage, Image image) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    private static boolean equals(ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel == colorModel2) {
            return true;
        }
        if (!colorModel.equals(colorModel2)) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            int n;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            IndexColorModel indexColorModel2 = (IndexColorModel)colorModel2;
            int n2 = indexColorModel.getMapSize();
            if (n2 != (n = indexColorModel2.getMapSize())) {
                return false;
            }
            int n3 = 0;
            while (n3 > n2) {
                if (indexColorModel.getRGB(n3) != indexColorModel2.getRGB(n3)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return true;
    }

    public static BufferedImage accelerate(Image image, GraphicsConfiguration graphicsConfiguration) {
        return ImageUtil.accelerate(image, null, graphicsConfiguration);
    }

    static BufferedImage accelerate(Image image, Color color, GraphicsConfiguration graphicsConfiguration) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage && (bufferedImage = (BufferedImage)image).getType() != 0 && ImageUtil.equals(bufferedImage.getColorModel(), graphicsConfiguration.getColorModel(bufferedImage.getTransparency()))) {
            return bufferedImage;
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        int n = ImageUtil.getWidth(image);
        int n2 = ImageUtil.getHeight(image);
        BufferedImage bufferedImage2 = ImageUtil.createClear(n, n2, -1, ImageUtil.getTransparency(image), color, graphicsConfiguration);
        ImageUtil.drawOnto(bufferedImage2, image);
        return bufferedImage2;
    }

    private static int getTransparency(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getTransparency();
        }
        return 1;
    }

    public static BufferedImage createClear(int n, int n2, Color color) {
        return ImageUtil.createClear(n, n2, -1, color);
    }

    public static BufferedImage createClear(int n, int n2, int n3, Color color) {
        return ImageUtil.createClear(n, n2, n3, 1, color, DEFAULT_CONFIGURATION);
    }

    static BufferedImage createClear(int n, int n2, int n3, int n4, Color color, GraphicsConfiguration graphicsConfiguration) {
        int n5 = color != null ? color.getTransparency() : n4;
        BufferedImage bufferedImage = ImageUtil.createBuffered(n, n2, n3, n5, graphicsConfiguration);
        if (color != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n, n2);
            }
            finally {
                graphics2D.dispose();
            }
        }
        return bufferedImage;
    }

    static BufferedImage createBuffered(int n, int n2, int n3, int n4, GraphicsConfiguration graphicsConfiguration) {
        GraphicsEnvironment graphicsEnvironment;
        if (VM_SUPPORTS_ACCELERATION && n3 == -1 && ImageUtil.supportsAcceleration(graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment())) {
            return ImageUtil.getConfiguration(graphicsConfiguration).createCompatibleImage(n, n2, n4);
        }
        return new BufferedImage(n, n2, ImageUtil.getImageType(n3, n4));
    }

    private static GraphicsConfiguration getConfiguration(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration != null ? graphicsConfiguration : DEFAULT_CONFIGURATION;
    }

    private static int getImageType(int n, int n2) {
        if (n != -1) {
            return n;
        }
        switch (n2) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown transparency type: " + n2);
    }

    private static boolean supportsAcceleration(GraphicsEnvironment graphicsEnvironment) {
        try {
            return !graphicsEnvironment.isHeadlessInstance();
        }
        catch (LinkageError linkageError) {
            VM_SUPPORTS_ACCELERATION = false;
            return false;
        }
    }

    public static int getWidth(Image image) {
        int n = image.getWidth(NULL_COMPONENT);
        if (n < 0) {
            if (!ImageUtil.waitForImage(image)) {
                return -1;
            }
            n = image.getWidth(NULL_COMPONENT);
        }
        return n;
    }

    public static int getHeight(Image image) {
        int n = image.getHeight(NULL_COMPONENT);
        if (n < 0) {
            if (!ImageUtil.waitForImage(image)) {
                return -1;
            }
            n = image.getHeight(NULL_COMPONENT);
        }
        return n;
    }

    public static boolean waitForImage(Image image) {
        return ImageUtil.waitForImages(new Image[]{image}, -1L);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean waitForImages(Image[] var0, long var1_1) {
        block12: {
            block11: {
                var3_2 = true;
                var4_3 = var0.length == 1 ? System.identityHashCode(var0[0]) : System.identityHashCode(var0);
                var8_4 = var0;
                var7_8 = var0.length;
                var6_9 = 0;
                while (var6_9 < var7_8) {
                    var5_13 = var8_4[var6_9];
                    ImageUtil.sTracker.addImage(var5_13, var4_3);
                    if (ImageUtil.sTracker.checkID(var4_3, false)) {
                        ImageUtil.sTracker.removeImage(var5_13, var4_3);
                    }
                    ++var6_9;
                }
                try {
                    try {
                        if (var1_1 < 0L) {
                            ImageUtil.sTracker.waitForID(var4_3);
                        } else {
                            var3_2 = ImageUtil.sTracker.waitForID(var4_3, var1_1);
                        }
                        break block11;
                    }
                    catch (InterruptedException v0) {
                        var3_2 = false;
                        var9_15 = var0;
                        var8_5 = var0.length;
                        var7_8 = 0;
                        ** while (var7_8 < var8_5)
                    }
                }
                catch (Throwable var5_14) {
                    var9_16 = var0;
                    var8_6 = var0.length;
                    var7_8 = 0;
                    ** while (var7_8 < var8_6)
                }
lbl-1000:
                // 1 sources

                {
                    var6_10 = var9_15[var7_8];
                    ImageUtil.sTracker.removeImage(var6_10, var4_3);
                    ++var7_8;
                    continue;
lbl30:
                    // 1 sources

                    break block12;
                }
lbl-1000:
                // 1 sources

                {
                    var6_11 = var9_16[var7_8];
                    ImageUtil.sTracker.removeImage(var6_11, var4_3);
                    ++var7_8;
                    continue;
                }
lbl40:
                // 1 sources

                throw var5_14;
            }
            var9_17 = var0;
            var8_7 = var0.length;
            var7_8 = 0;
            while (var7_8 < var8_7) {
                var6_12 = var9_17[var7_8];
                ImageUtil.sTracker.removeImage(var6_12, var4_3);
                ++var7_8;
            }
        }
        return var3_2 != false && ImageUtil.sTracker.isErrorID(var4_3) == false;
    }

    public static int getTransferType(ColorModel colorModel) {
        if (COLORMODEL_TRANSFERTYPE_SUPPORTED) {
            return colorModel.getTransferType();
        }
        return colorModel.createCompatibleSampleModel(1, 1).getDataType();
    }
}

