/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class BufferedImageIcon
implements Icon {
    private final BufferedImage mImage;
    private int mWidth;
    private int mHeight;
    private final boolean mFast;

    public BufferedImageIcon(BufferedImage bufferedImage) {
        this(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public BufferedImageIcon(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Icon size must be positive");
        }
        this.mImage = bufferedImage;
        this.mWidth = n;
        this.mHeight = n2;
        this.mFast = bufferedImage.getWidth() == this.mWidth && bufferedImage.getHeight() == this.mHeight;
    }

    @Override
    public int getIconHeight() {
        return this.mHeight;
    }

    @Override
    public int getIconWidth() {
        return this.mWidth;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.mFast || !(graphics instanceof Graphics2D)) {
            graphics.drawImage(this.mImage, n, n2, this.mWidth, this.mHeight, null);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
            affineTransform.scale((double)this.mWidth / (double)this.mImage.getWidth(), (double)this.mHeight / (double)this.mImage.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(this.mImage, affineTransform, null);
        }
    }
}

