/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.ImageConversionException;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.image.SubsamplingFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.lang.reflect.Array;
import java.util.Hashtable;

public final class BufferedImageFactory {
    private ImageProducer mProducer;
    private boolean mError;
    private boolean mFetching;
    private boolean mReadColorModelOnly;
    private int mX = 0;
    private int mY = 0;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mXSub = 1;
    private int mYSub = 1;
    private int mOffset;
    private int mScanSize;
    private ColorModel mSourceColorModel;
    private Hashtable mSourceProperties;
    private Object mSourcePixels;
    private BufferedImage mBuffered;
    private ColorModel mColorModel;
    private final Consumer mConsumer = new Consumer();

    public BufferedImageFactory(Image image) {
        this(image.getSource());
    }

    public BufferedImageFactory(ImageProducer imageProducer) {
        this.mProducer = imageProducer;
    }

    public BufferedImage getBufferedImage() throws ImageConversionException {
        this.doFetch(false);
        return this.mBuffered;
    }

    public ColorModel getColorModel() throws ImageConversionException {
        this.doFetch(true);
        return this.mBuffered != null ? this.mBuffered.getColorModel() : this.mColorModel;
    }

    public void dispose() {
        this.freeResources();
        this.mBuffered = null;
        this.mColorModel = null;
    }

    private synchronized void doFetch(boolean bl) throws ImageConversionException {
        if (!this.mFetching && (!bl && this.mBuffered == null || this.mBuffered == null && this.mSourceColorModel == null)) {
            if (!(bl || this.mXSub <= 1 && this.mYSub <= 1)) {
                if (this.mWidth > 0 && this.mHeight > 0) {
                    this.mWidth = (this.mWidth + this.mXSub - 1) / this.mXSub;
                    this.mHeight = (this.mHeight + this.mYSub - 1) / this.mYSub;
                    this.mX = (this.mX + this.mXSub - 1) / this.mXSub;
                    this.mY = (this.mY + this.mYSub - 1) / this.mYSub;
                }
                this.mProducer = new FilteredImageSource(this.mProducer, new SubsamplingFilter(this.mXSub, this.mYSub));
            }
            this.mFetching = true;
            this.mReadColorModelOnly = bl;
            this.mProducer.startProduction(this.mConsumer);
            while (this.mFetching) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new ImageConversionException("Image conversion aborted: " + interruptedException.getMessage(), interruptedException);
                }
            }
            if (this.mError) {
                throw new ImageConversionException("Image conversion failed: ImageConsumer.IMAGEERROR.");
            }
            if (bl) {
                this.createColorModel();
            } else {
                this.createBuffered();
            }
        }
    }

    private void createColorModel() {
        this.mColorModel = this.mSourceColorModel;
        this.freeResources();
    }

    private void createBuffered() {
        if (this.mWidth > 0 && this.mHeight > 0) {
            if (this.mSourceColorModel != null && this.mSourcePixels != null) {
                WritableRaster writableRaster = ImageUtil.createRaster(this.mWidth, this.mHeight, this.mSourcePixels, this.mSourceColorModel);
                this.mBuffered = new BufferedImage(this.mSourceColorModel, writableRaster, this.mSourceColorModel.isAlphaPremultiplied(), this.mSourceProperties);
            } else {
                this.mBuffered = ImageUtil.createClear(this.mWidth, this.mHeight, null);
            }
        }
        this.freeResources();
    }

    private void freeResources() {
        this.mSourceColorModel = null;
        this.mSourcePixels = null;
        this.mSourceProperties = null;
    }

    private static short[] toShortPixels(int[] nArray) {
        short[] sArray = new short[nArray.length];
        int n = 0;
        while (n < sArray.length) {
            sArray[n] = (short)(nArray[n] & 0xFFFF);
            ++n;
        }
        return sArray;
    }

    private class Consumer
    implements ImageConsumer {
        private Consumer() {
        }

        private void setPixelsImpl(int n, int n2, int n3, int n4, ColorModel colorModel, Object object, int n5, int n6) {
            int n7;
            this.setColorModelOnce(colorModel);
            if (object == null) {
                return;
            }
            if (BufferedImageFactory.this.mSourcePixels == null) {
                BufferedImageFactory.this.mSourcePixels = Array.newInstance(object.getClass().getComponentType(), BufferedImageFactory.this.mWidth * BufferedImageFactory.this.mHeight);
                BufferedImageFactory.this.mScanSize = BufferedImageFactory.this.mWidth;
                BufferedImageFactory.this.mOffset = 0;
            } else if (BufferedImageFactory.this.mSourcePixels.getClass() != object.getClass()) {
                throw new IllegalStateException("Only one pixel type allowed");
            }
            if (n2 < BufferedImageFactory.this.mY) {
                n7 = BufferedImageFactory.this.mY - n2;
                if (n7 >= n4) {
                    return;
                }
                n5 += n6 * n7;
                n2 += n7;
                n4 -= n7;
            }
            if (n2 + n4 > BufferedImageFactory.this.mY + BufferedImageFactory.this.mHeight && (n4 = BufferedImageFactory.this.mY + BufferedImageFactory.this.mHeight - n2) <= 0) {
                return;
            }
            if (n < BufferedImageFactory.this.mX) {
                n7 = BufferedImageFactory.this.mX - n;
                if (n7 >= n3) {
                    return;
                }
                n5 += n7;
                n += n7;
                n3 -= n7;
            }
            if (n + n3 > BufferedImageFactory.this.mX + BufferedImageFactory.this.mWidth && (n3 = BufferedImageFactory.this.mX + BufferedImageFactory.this.mWidth - n) <= 0) {
                return;
            }
            n7 = BufferedImageFactory.this.mOffset + (n2 - BufferedImageFactory.this.mY) * BufferedImageFactory.this.mScanSize + (n - BufferedImageFactory.this.mX);
            int n8 = n4;
            while (n8 > 0) {
                System.arraycopy(object, n5, BufferedImageFactory.this.mSourcePixels, n7, n3);
                n5 += n6;
                n7 += BufferedImageFactory.this.mScanSize;
                --n8;
            }
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, short[] sArray, int n5, int n6) {
            this.setPixelsImpl(n, n2, n3, n4, colorModel, sArray, n5, n6);
        }

        private void setColorModelOnce(ColorModel colorModel) {
            if (BufferedImageFactory.this.mSourceColorModel != colorModel) {
                if (BufferedImageFactory.this.mSourcePixels == null) {
                    BufferedImageFactory.this.mSourceColorModel = colorModel;
                } else {
                    throw new IllegalStateException("Change of ColorModel after pixel delivery not supported");
                }
            }
            if (BufferedImageFactory.this.mReadColorModelOnly) {
                BufferedImageFactory.this.mConsumer.imageComplete(4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imageComplete(int n) {
            BufferedImageFactory.this.mFetching = false;
            if (BufferedImageFactory.this.mProducer != null) {
                BufferedImageFactory.this.mProducer.removeConsumer(this);
            }
            switch (n) {
                case 1: {
                    new Error().printStackTrace();
                    BufferedImageFactory.this.mError = true;
                }
            }
            BufferedImageFactory bufferedImageFactory = BufferedImageFactory.this;
            synchronized (bufferedImageFactory) {
                BufferedImageFactory.this.notifyAll();
            }
        }

        @Override
        public void setColorModel(ColorModel colorModel) {
            this.setColorModelOnce(colorModel);
        }

        @Override
        public void setDimensions(int n, int n2) {
            if (BufferedImageFactory.this.mWidth < 0) {
                BufferedImageFactory.this.mWidth = n - BufferedImageFactory.this.mX;
            }
            if (BufferedImageFactory.this.mHeight < 0) {
                BufferedImageFactory.this.mHeight = n2 - BufferedImageFactory.this.mY;
            }
            if (BufferedImageFactory.this.mWidth <= 0 || BufferedImageFactory.this.mHeight <= 0) {
                this.imageComplete(3);
            }
        }

        @Override
        public void setHints(int n) {
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            this.setPixelsImpl(n, n2, n3, n4, colorModel, byArray, n5, n6);
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            if (ImageUtil.getTransferType(colorModel) == 1) {
                this.setPixelsImpl(n, n2, n3, n4, colorModel, BufferedImageFactory.toShortPixels(nArray), n5, n6);
            } else {
                this.setPixelsImpl(n, n2, n3, n4, colorModel, nArray, n5, n6);
            }
        }

        public void setProperties(Hashtable hashtable) {
            BufferedImageFactory.this.mSourceProperties = hashtable;
        }
    }
}

