/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JaiI18N;
import com.sun.media.jai.util.Job;
import com.sun.media.jai.util.Request;
import com.sun.media.jai.util.RequestJob;
import com.sun.media.jai.util.TileJob;
import com.sun.media.jai.util.WorkerThread;
import java.awt.Point;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class SunTileScheduler
implements TileScheduler {
    private static final int NUM_THREADS_DEFAULT = 2;
    private static final int NUM_PREFETCH_THREADS_DEFAULT = 1;
    private static int numInstances = 0;
    private static String name = JaiI18N.getString("SunTileSchedulerName");
    private ThreadGroup rootGroup;
    private ThreadGroup standardGroup;
    private ThreadGroup prefetchGroup;
    private int parallelism = 2;
    private int prefetchParallelism = 1;
    private int priority = 5;
    private int prefetchPriority = 1;
    private LinkedList queue = null;
    private LinkedList prefetchQueue = null;
    private Vector workers = new Vector();
    private Vector prefetchWorkers = new Vector();
    private int numWorkerThreads = 0;
    private int numPrefetchThreads = 0;
    private Map tilesInProgress = new HashMap();
    Map tileRequests = new HashMap();
    Map tileJobs = new HashMap();
    private String nameOfThisInstance;

    static Object tileKey(PlanarImage planarImage, int n, int n2) {
        long l = (long)n2 * (long)planarImage.getNumXTiles() + (long)n;
        BigInteger bigInteger = (BigInteger)planarImage.getImageID();
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3 + 8];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        int n4 = 7;
        int n5 = 0;
        while (n4 >= 0) {
            byArray2[n3++] = (byte)(l >> n5);
            --n4;
            n5 += 8;
        }
        return new BigInteger(byArray2);
    }

    static Set getListeners(List list) {
        int n = list.size();
        HashSet hashSet = null;
        int n2 = 0;
        while (n2 < n) {
            Request request = (Request)list.get(n2);
            if (request.listeners != null && !request.listeners.isEmpty()) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.addAll(request.listeners);
            }
            ++n2;
        }
        return hashSet;
    }

    private static String getStackTraceString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public SunTileScheduler(int n, int n2, int n3, int n4) {
        this();
        this.setParallelism(n);
        this.setPriority(n2);
        this.setPrefetchParallelism(n3);
        this.setPrefetchPriority(n4);
    }

    public SunTileScheduler() {
        this.queue = new LinkedList();
        this.prefetchQueue = new LinkedList();
        this.nameOfThisInstance = String.valueOf(name) + numInstances;
        this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
        this.rootGroup.setDaemon(true);
        this.standardGroup = new ThreadGroup(this.rootGroup, String.valueOf(this.nameOfThisInstance) + "Standard");
        this.standardGroup.setDaemon(true);
        this.prefetchGroup = new ThreadGroup(this.rootGroup, String.valueOf(this.nameOfThisInstance) + "Prefetch");
        this.prefetchGroup.setDaemon(true);
        ++numInstances;
    }

    Exception compute(PlanarImage planarImage, Point[] pointArray, Raster[] rasterArray, int n, int n2, Request request) {
        Object object;
        Object object2;
        Exception exception = null;
        int n3 = n;
        if (request == null || request.listeners == null) {
            int n4 = 0;
            while (n4 < n2) {
                Point point = pointArray[n3];
                try {
                    rasterArray[n3] = planarImage.getTile(point.x, point.y);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    break;
                }
                ++n4;
                ++n3;
            }
        } else {
            TileRequest[] tileRequestArray = new Request[]{request};
            int n5 = 0;
            while (n5 < n2) {
                Point point = pointArray[n3];
                Integer n6 = new Integer(1);
                request.tileStatus.put(point, n6);
                try {
                    rasterArray[n3] = planarImage.getTile(point.x, point.y);
                    object2 = request.listeners.iterator();
                    while (object2.hasNext()) {
                        n6 = new Integer(2);
                        request.tileStatus.put(point, n6);
                        object = (TileComputationListener)object2.next();
                        object.tileComputed(this, tileRequestArray, planarImage, point.x, point.y, rasterArray[n3]);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                    break;
                }
                ++n5;
                ++n3;
            }
        }
        if (exception != null && request != null && request.listeners != null) {
            int n7 = n3;
            int n8 = n2 - (n7 - n);
            int n9 = 0;
            int n10 = n7;
            while (n9 < n8) {
                object2 = new Integer(4);
                request.tileStatus.put(pointArray[n10++], object2);
                ++n9;
            }
            TileRequest[] tileRequestArray = new Request[]{request};
            n10 = 0;
            int n11 = n7;
            while (n10 < n8) {
                object = pointArray[n11++];
                for (TileComputationListener tileComputationListener : request.listeners) {
                    tileComputationListener.tileComputationFailure(this, tileRequestArray, planarImage, ((Point)object).x, ((Point)object).y, exception);
                }
                ++n10;
            }
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Raster scheduleTile(OpImage opImage, int n, int n2) {
        if (opImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler1"));
        }
        Raster raster = null;
        Object object = SunTileScheduler.tileKey(opImage, n, n2);
        boolean bl = false;
        Object[] objectArray = null;
        Object object2 = this.tilesInProgress;
        synchronized (this.tilesInProgress) {
            bl = !this.tilesInProgress.containsKey(object);
            if (bl) {
                objectArray = new Object[1];
                this.tilesInProgress.put(object, objectArray);
            } else {
                objectArray = (Object[])this.tilesInProgress.get(object);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (bl) {
                try {
                    try {
                        try {
                            raster = opImage.computeTile(n, n2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            object2 = opImage.getTileCache();
                            if (object2 != null) {
                                object2.flush();
                                System.gc();
                            }
                            raster = opImage.computeTile(n, n2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            this.sendExceptionToListener(JaiI18N.getString("SunTileScheduler6"), throwable);
                        } else {
                            String string = JaiI18N.getString("SunTileScheduler6");
                            this.sendExceptionToListener(string, new ImagingException(string, throwable));
                        }
                        Object[] objectArray2 = objectArray;
                        synchronized (objectArray) {
                            objectArray[0] = raster != null ? raster : new Object();
                            objectArray.notifyAll();
                            Map map = this.tilesInProgress;
                            synchronized (map) {
                                this.tilesInProgress.remove(object);
                            }
                            // ** MonitorExit[var11_11] (shouldn't be in output)
                            return raster;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object[] objectArray3 = objectArray;
                    synchronized (objectArray) {
                        objectArray[0] = raster != null ? raster : new Object();
                        objectArray.notifyAll();
                        Map map = this.tilesInProgress;
                        synchronized (map) {
                            this.tilesInProgress.remove(object);
                        }
                        // ** MonitorExit[var11_12] (shouldn't be in output)
                        throw throwable;
                    }
                }
                Object[] objectArray4 = objectArray;
                synchronized (objectArray) {
                    objectArray[0] = raster != null ? raster : new Object();
                    objectArray.notifyAll();
                    Map map = this.tilesInProgress;
                    synchronized (map) {
                        this.tilesInProgress.remove(object);
                    }
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                    return raster;
                }
            }
            object2 = objectArray;
            synchronized (objectArray) {
                if (objectArray[0] == null) {
                    try {
                        objectArray.wait();
                    }
                    catch (Exception exception) {}
                }
                if (!(objectArray[0] instanceof Raster)) throw new RuntimeException(JaiI18N.getString("SunTileScheduler5"));
                return (Raster)objectArray[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object scheduleJob(PlanarImage var1_1, Point[] var2_2, boolean var3_3, boolean var4_4, TileComputationListener[] var5_5) {
        block31: {
            if (var1_1 == null) throw new IllegalArgumentException();
            if (var2_2 == null) {
                throw new IllegalArgumentException();
            }
            if ((var3_3 || var4_4) && var5_5 != null) {
                throw new IllegalArgumentException();
            }
            if (var3_3 && var4_4) {
                throw new IllegalArgumentException();
            }
            var6_6 = var2_2.length;
            var8_8 /* !! */  = var7_7 = new Raster[var6_6];
            var9_9 = 0;
            var10_10 = null;
            var11_11 = 0;
            var12_12 = this.getWorkers(var4_4);
            synchronized (var12_12) {
                block28: {
                    block30: {
                        var9_9 = this.getNumThreads(var4_4);
                        if (var9_9 <= 0) break block28;
                        if (var6_6 > var9_9 && (var3_3 || var4_4)) break block30;
                        var10_10 = new Job[var6_6];
                        if (var3_3 || var4_4) ** GOTO lbl80
                        var13_14 = new Request(this, var1_1, var2_2, var5_5);
                        var8_8 /* !! */  = var13_14;
                        var14_16 = 0;
                        if (true) ** GOTO lbl76
                    }
                    var13_15 = 1.0f / (2.0f * (float)var9_9);
                    var14_16 = var9_9 == 1 ? var6_6 : Math.min(Math.max(1, (int)(var13_15 * (float)var6_6 / 2.0f + 0.5f)), var6_6);
                    var15_20 = var9_9 == 1 ? 1 : (int)((float)var6_6 / (float)var14_16 + 0.5f);
                    var10_10 = new TileJob[var15_20];
                    var16_22 = 0;
                    var17_24 = var6_6 - var16_22;
                    while (var17_24 > 0) {
                        var18_26 = (int)(var13_15 * (float)var17_24 + 0.5f);
                        if (var18_26 < var14_16) {
                            var18_26 = var14_16;
                        }
                        if (var18_26 > var17_24) {
                            var18_26 = var17_24;
                        }
                        if ((var17_24 -= var18_26) < var14_16) {
                            var18_26 += var17_24;
                            var17_24 = 0;
                        }
                        var10_10[var11_11] = new TileJob(this, var3_3, var1_1, var2_2, var7_7, var16_22, var18_26);
                        this.addJob(var10_10[var11_11++], var4_4);
                        var16_22 += var18_26;
                    }
                    break block28;
                    do {
                        if (!SunTileScheduler.$assertionsDisabled && var14_16 >= var2_2.length) {
                            throw new AssertionError();
                        }
                        var15_19 = var2_2[var14_16];
                        var16_21 = SunTileScheduler.tileKey(var1_1, var15_19.x, var15_19.y);
                        var17_23 = this.tileRequests;
                        synchronized (var17_23) {
                            var18_25 = null;
                            if (this.tileRequests.containsKey(var16_21)) {
                                var18_25 = (List)this.tileRequests.get(var16_21);
                                var18_25.add(var13_14);
                                --var6_6;
                            } else {
                                var18_25 = new ArrayList<Object>();
                                var18_25.add(var13_14);
                                this.tileRequests.put(var16_21, var18_25);
                                var10_10[var11_11] = new RequestJob(this, var1_1, var15_19.x, var15_19.y, var7_7, var11_11);
                                this.tileJobs.put(var16_21, var10_10[var11_11]);
                                this.addJob(var10_10[var11_11++], false);
                            }
                        }
                        ++var14_16;
lbl76:
                        // 2 sources

                    } while (var11_11 < var6_6);
                    break block28;
lbl-1000:
                    // 1 sources

                    {
                        var10_10[var11_11] = new TileJob(this, var3_3, var1_1, var2_2, var7_7, var11_11, 1);
                        this.addJob(var10_10[var11_11++], var4_4);
lbl80:
                        // 2 sources

                        ** while (var11_11 < var6_6)
                    }
                }
                if (var9_9 == 0) break block31;
            }
            if (var3_3 == false) return var8_8 /* !! */ ;
            this.getQueue(var4_4);
            var12_13 = 0;
            if (true) ** GOTO lbl117
        }
        var12_12 = null;
        if (!var3_3 && !var4_4) {
            var12_12 = new Request(this, var1_1, var2_2, var5_5);
            var8_8 /* !! */  = var12_12;
        }
        if ((var13_14 = this.compute(var1_1, var2_2, var7_7, 0, var6_6, (Request)var12_12)) == null) return var8_8 /* !! */ ;
        var14_18 = JaiI18N.getString("SunTileScheduler7");
        this.sendExceptionToListener(var14_18, new ImagingException(var14_18, (Throwable)var13_14));
        return var8_8 /* !! */ ;
        do {
            var13_14 = this;
            synchronized (var13_14) {
                while (true) {
                    if (!var10_10[var12_13].notDone()) {
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException v2) {}
                }
            }
            var13_14 = var10_10[var12_13].getException();
            if (var13_14 != null) {
                var14_17 = JaiI18N.getString("SunTileScheduler7");
                this.sendExceptionToListener(var14_17, new ImagingException(var14_17, (Throwable)var13_14));
            }
            ++var12_13;
lbl117:
            // 2 sources

        } while (var12_13 < var11_11);
        return var8_8 /* !! */ ;
    }

    @Override
    public Raster[] scheduleTiles(OpImage opImage, Point[] pointArray) {
        if (opImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        return (Raster[])this.scheduleJob(opImage, pointArray, true, false, null);
    }

    @Override
    public TileRequest scheduleTiles(PlanarImage planarImage, Point[] pointArray, TileComputationListener[] tileComputationListenerArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler4"));
        }
        return (TileRequest)this.scheduleJob(planarImage, pointArray, false, false, tileComputationListenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        Point[] pointArray2;
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler3"));
        }
        Request request = (Request)tileRequest;
        Map map = this.tileRequests;
        // MONITORENTER : map
        List list = request.indices;
        if (pointArray != null && pointArray.length > 0) {
            List<Point> list2 = Arrays.asList(pointArray);
            list2.retainAll(list);
            pointArray2 = list2.toArray(new Point[0]);
        } else {
            pointArray2 = list.toArray(new Point[0]);
        }
        int n = pointArray2.length;
        Integer n2 = new Integer(3);
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                // MONITOREXIT : map
                return;
            }
            Point point = pointArray2[n3];
            Object object = SunTileScheduler.tileKey(request.image, point.x, point.y);
            List list3 = (List)this.tileRequests.get(object);
            if (list3 != null) {
                TileRequest[] tileRequestArray;
                list3.remove(request);
                if (list3.isEmpty()) {
                    tileRequestArray = this.queue;
                    // MONITORENTER : this.queue
                    Object v = this.tileJobs.remove(object);
                    if (v != null) {
                        this.queue.remove(v);
                    }
                    // MONITOREXIT : tileRequestArray
                    this.tileRequests.remove(object);
                }
                request.tileStatus.put(point, n2);
                if (request.listeners != null) {
                    tileRequestArray = new TileRequest[]{request};
                    for (TileComputationListener tileComputationListener : request.listeners) {
                        tileComputationListener.tileCancelled(this, tileRequestArray, request.image, point.x, point.y);
                    }
                }
            }
            ++n3;
        }
    }

    @Override
    public void prefetchTiles(PlanarImage planarImage, Point[] pointArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        this.scheduleJob(planarImage, pointArray, false, true, null);
    }

    @Override
    public void setParallelism(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.parallelism = n;
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public void setPrefetchParallelism(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.prefetchParallelism = n;
    }

    @Override
    public int getPrefetchParallelism() {
        return this.prefetchParallelism;
    }

    @Override
    public void setPriority(int n) {
        this.priority = Math.max(Math.min(n, 10), 1);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPrefetchPriority(int n) {
        this.prefetchPriority = Math.max(Math.min(n, 10), 1);
    }

    @Override
    public int getPrefetchPriority() {
        return this.prefetchPriority;
    }

    private void createThreadGroup(boolean bl) {
        if (this.rootGroup == null || this.rootGroup.isDestroyed()) {
            this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
            this.rootGroup.setDaemon(true);
        }
        if (bl && (this.prefetchGroup == null || this.prefetchGroup.isDestroyed())) {
            this.prefetchGroup = new ThreadGroup(this.rootGroup, String.valueOf(this.nameOfThisInstance) + "Prefetch");
            this.prefetchGroup.setDaemon(true);
        }
        if (!bl && (this.standardGroup == null || this.standardGroup.isDestroyed())) {
            this.standardGroup = new ThreadGroup(this.rootGroup, String.valueOf(this.nameOfThisInstance) + "Standard");
            this.standardGroup.setDaemon(true);
        }
        Vector vector = this.getWorkers(bl);
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            Thread thread = (Thread)vector.get(n2);
            if (!thread.isAlive()) {
                vector.remove(thread);
            }
            --n2;
        }
        if (bl) {
            this.numPrefetchThreads = vector.size();
        } else {
            this.numWorkerThreads = vector.size();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getNumThreads(boolean var1_1) {
        block9: {
            this.createThreadGroup(var1_1);
            var2_2 = this.getWorkers(var1_1);
            if (var1_1) {
                var3_3 = this.numPrefetchThreads;
                var4_4 = this.prefetchParallelism;
                var5_5 = this.prefetchPriority;
            } else {
                var3_3 = this.numWorkerThreads;
                var4_4 = this.parallelism;
                var5_5 = this.priority;
            }
            if (var3_3 > 0 && ((Thread)var2_2.get(0)).getPriority() != var5_5) {
                var6_6 = var2_2.size();
                var7_8 = 0;
                while (var7_8 < var6_6) {
                    var8_9 = (Thread)var2_2.get(var7_8);
                    if (var8_9 != null && var8_9.getThreadGroup() != null) {
                        var8_9.setPriority(var5_5);
                    }
                    ++var7_8;
                }
            }
            if (var3_3 >= var4_4) ** GOTO lbl31
            while (var3_3 < var4_4) {
                var6_7 = new WorkerThread(var1_1 != false ? this.prefetchGroup : this.standardGroup, this, var1_1);
                var6_7.setPriority(var5_5);
                var2_2.add(var6_7);
                ++var3_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                this.addJob(WorkerThread.TERMINATE, var1_1);
                --var3_3;
lbl31:
                // 2 sources

                ** while (var3_3 > var4_4)
            }
        }
        if (var1_1) {
            this.numPrefetchThreads = var3_3;
        } else {
            this.numWorkerThreads = var3_3;
        }
        return var3_3;
    }

    Vector getWorkers(boolean bl) {
        return bl ? this.workers : this.prefetchWorkers;
    }

    LinkedList getQueue(boolean bl) {
        return bl ? this.prefetchQueue : this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(Object object, boolean bl) {
        LinkedList linkedList;
        if (object == null || object != WorkerThread.TERMINATE && !(object instanceof Job)) {
            throw new IllegalArgumentException();
        }
        LinkedList linkedList2 = linkedList = this.getQueue(bl);
        synchronized (linkedList) {
            if (bl || linkedList.isEmpty() || object instanceof RequestJob) {
                linkedList.addLast(object);
            } else {
                boolean bl2 = false;
                int n = linkedList.size() - 1;
                while (n >= 0) {
                    if (linkedList.get(n) instanceof TileJob) {
                        linkedList.add(n + 1, object);
                        bl2 = true;
                        break;
                    }
                    --n;
                }
                if (!bl2) {
                    linkedList.addFirst(object);
                }
            }
            linkedList.notify();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.terminateAll(false);
        this.terminateAll(true);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAll(boolean bl) {
        Vector vector = this.getWorkers(bl);
        synchronized (vector) {
            int n = bl ? this.numPrefetchThreads : this.numWorkerThreads;
            int n2 = 0;
            while (n2 < n) {
                this.addJob(WorkerThread.TERMINATE, bl);
                if (bl) {
                    --this.numPrefetchThreads;
                } else {
                    --this.numWorkerThreads;
                }
                ++n2;
            }
        }
    }

    void sendExceptionToListener(String string, Throwable throwable) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(null);
        imagingListener.errorOccurred(string, throwable, this, false);
    }
}

