/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import javax.media.jai.CachedTile;
import javax.media.jai.PlanarImage;
import javax.media.jai.remote.SerializableRenderedImage;

final class SunCachedTile
implements CachedTile {
    Raster tile;
    WeakReference owner;
    int tileX;
    int tileY;
    Object tileCacheMetric;
    long timeStamp;
    Object key;
    long memorySize;
    SunCachedTile previous;
    SunCachedTile next;
    int action = 0;

    SunCachedTile(RenderedImage renderedImage, int n, int n2, Raster raster, Object object) {
        this.owner = new WeakReference<RenderedImage>(renderedImage);
        this.tile = raster;
        this.tileX = n;
        this.tileY = n2;
        this.tileCacheMetric = object;
        this.key = SunCachedTile.hashKey(renderedImage, n, n2);
        DataBuffer dataBuffer = raster.getDataBuffer();
        this.memorySize = (long)DataBuffer.getDataTypeSize(dataBuffer.getDataType()) / 8L * (long)dataBuffer.getSize() * (long)dataBuffer.getNumBanks();
    }

    static Object hashKey(RenderedImage renderedImage, int n, int n2) {
        long l = (long)n2 * (long)renderedImage.getNumXTiles() + (long)n;
        BigInteger bigInteger = null;
        if (renderedImage instanceof PlanarImage) {
            bigInteger = (BigInteger)((PlanarImage)renderedImage).getImageID();
        } else if (renderedImage instanceof SerializableRenderedImage) {
            bigInteger = (BigInteger)((SerializableRenderedImage)renderedImage).getImageID();
        }
        if (bigInteger != null) {
            byte[] byArray = bigInteger.toByteArray();
            int n3 = byArray.length;
            byte[] byArray2 = new byte[n3 + 8];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            int n4 = 7;
            int n5 = 0;
            while (n4 >= 0) {
                byArray2[n3++] = (byte)(l >> n5);
                --n4;
                n5 += 8;
            }
            return new BigInteger(byArray2);
        }
        return new Long((long)renderedImage.hashCode() << 32 | (l &= 0xFFFFFFFFL));
    }

    public String toString() {
        RenderedImage renderedImage = this.getOwner();
        String string = renderedImage == null ? "null" : renderedImage.toString();
        Raster raster = this.getTile();
        String string2 = raster == null ? "null" : raster.toString();
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + string + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + string2 + " key = " + (this.key instanceof Long ? Long.toHexString((Long)this.key) : this.key.toString()) + " memorySize = " + Long.toString(this.memorySize) + " timeStamp = " + Long.toString(this.timeStamp);
    }

    @Override
    public Raster getTile() {
        return this.tile;
    }

    @Override
    public RenderedImage getOwner() {
        return (RenderedImage)this.owner.get();
    }

    @Override
    public long getTileTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    @Override
    public long getTileSize() {
        return this.memorySize;
    }

    @Override
    public int getAction() {
        return this.action;
    }
}

