/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class PropertyUtil {
    private static Hashtable<String, ResourceBundle> bundles = new Hashtable();

    public static InputStream getFileFromClasspath(String string) throws IOException {
        InputStream inputStream = PropertyUtil.class.getResourceAsStream("/" + string);
        if (inputStream != null) {
            return inputStream;
        }
        File file = new File("com.deltawalker.image", string);
        inputStream = file.isFile() ? new FileInputStream(file) : new FileInputStream(string);
        return inputStream;
    }

    private static ResourceBundle getBundle(String string) {
        PropertyResourceBundle propertyResourceBundle = null;
        InputStream inputStream = null;
        try {
            String string2 = string.replace('.', '/');
            inputStream = PropertyUtil.getFileFromClasspath(String.valueOf(string2) + "/" + string + ".properties");
            if (inputStream != null) {
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
                bundles.put(string, propertyResourceBundle);
                return propertyResourceBundle;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String getString(String string, String string2) {
        ResourceBundle resourceBundle = bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = PropertyUtil.getBundle(string);
        }
        return resourceBundle != null ? resourceBundle.getString(string2) : string2;
    }

    public static String[] getPropertyNames(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyUtil0"));
        }
        string = string.toLowerCase();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toLowerCase().startsWith(string)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        int n2 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            stringArray2[n2++] = (String)iterator.next();
        }
        return stringArray2;
    }
}

