/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import javax.media.jai.Interpolation;

public class InterpAverage
extends Interpolation {
    public InterpAverage(int n, int n2) {
        super(n, n2, (n - 1) / 2, n - 1 - (n - 1) / 2, (n2 - 1) / 2, n2 - 1 - (n2 - 1) / 2, 32, 32);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("blockX <= 0 || blockY <= 0");
        }
    }

    @Override
    public int interpolateH(int[] nArray, int n) {
        int n2 = nArray.length;
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d += (double)(nArray[n3] / n2);
            ++n3;
        }
        return (int)(d + 0.5);
    }

    @Override
    public float interpolateH(float[] fArray, float f) {
        int n = fArray.length;
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            f2 += fArray[n2] / (float)n;
            ++n2;
        }
        return f2;
    }

    @Override
    public double interpolateH(double[] dArray, float f) {
        int n = dArray.length;
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2] / (double)n;
            ++n2;
        }
        return d;
    }
}

