/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.text.MessageFormat;
import javax.media.jai.JAI;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;

public class TileCodecUtils {
    private static MessageFormat formatter = new MessageFormat("");

    public static TileCodecDescriptor getTileCodecDescriptor(String string, String string2) {
        return (TileCodecDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor(string, string2);
    }

    public static Raster deserializeRaster(Object object) {
        if (!(object instanceof SerializableState)) {
            return null;
        }
        SerializableState serializableState = (SerializableState)object;
        Class clazz = serializableState.getObjectClass();
        if (Raster.class.isAssignableFrom(clazz)) {
            return (Raster)serializableState.getObject();
        }
        return null;
    }

    public static SampleModel deserializeSampleModel(Object object) {
        if (!(object instanceof SerializableState)) {
            return null;
        }
        SerializableState serializableState = (SerializableState)object;
        Class clazz = serializableState.getObjectClass();
        if (SampleModel.class.isAssignableFrom(clazz)) {
            return (SampleModel)serializableState.getObject();
        }
        return null;
    }

    public static Object serializeRaster(Raster raster) {
        return SerializerFactory.getState(raster, null);
    }

    public static Object serializeSampleModel(SampleModel sampleModel) {
        return SerializerFactory.getState(sampleModel, null);
    }
}

