/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGQTable;
import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.RasterFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderImpl;
import javax.media.jai.util.ImagingListener;

public class JPEGTileDecoder
extends TileDecoderImpl {
    private TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileDecoder", "jpeg");

    public JPEGTileDecoder(InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        super("jpeg", inputStream, tileCodecParameterList);
    }

    @Override
    public Raster decode() throws IOException {
        if (!this.tcd.includesLocationInfo()) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGTileDecoder0"));
        }
        return this.decode(null);
    }

    @Override
    public Raster decode(Point point) throws IOException {
        SampleModel sampleModel = null;
        byte[] byArray = null;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(this.inputStream);){
            try {
                this.paramList.setParameter("quality", objectInputStream.readFloat());
                this.paramList.setParameter("qualitySet", objectInputStream.readBoolean());
                sampleModel = TileCodecUtils.deserializeSampleModel(objectInputStream.readObject());
                point = (Point)objectInputStream.readObject();
                byArray = (byte[])objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ImagingListener imagingListener = ImageUtil.getImagingListener(null);
                imagingListener.errorOccurred(JaiI18N.getString("ClassNotFound"), classNotFoundException, this, false);
                objectInputStream.close();
                return null;
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        Raster raster = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(point.x, point.y);
        this.extractParameters(jPEGImageDecoder.getJPEGDecodeParam(), raster.getSampleModel().getNumBands());
        if (sampleModel != null) {
            int n = raster.getMinX();
            int n2 = raster.getMinY();
            int n3 = raster.getHeight();
            int n4 = raster.getWidth();
            double[] dArray = raster.getPixels(n, n2, n4, n3, (double[])null);
            raster = RasterFactory.createWritableRaster(sampleModel, new Point(n, n2));
            ((WritableRaster)raster).setPixels(n, n2, n4, n3, dArray);
        }
        return raster;
    }

    private void extractParameters(JPEGDecodeParam jPEGDecodeParam, int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = jPEGDecodeParam.getHorizontalSubsampling(n2);
            ++n2;
        }
        this.paramList.setParameter("horizontalSubsampling", nArray);
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = jPEGDecodeParam.getVerticalSubsampling(n3);
            ++n3;
        }
        this.paramList.setParameter("verticalSubsampling", nArray2);
        if (!this.paramList.getBooleanParameter("qualitySet")) {
            n3 = 0;
            while (n3 < 4) {
                JPEGQTable jPEGQTable = jPEGDecodeParam.getQTable(n3);
                this.paramList.setParameter("quantizationTable" + n3, jPEGQTable == null ? null : jPEGQTable.getTable());
                ++n3;
            }
        } else {
            ParameterListDescriptor parameterListDescriptor = this.paramList.getParameterListDescriptor();
            int n4 = 0;
            while (n4 < 4) {
                this.paramList.setParameter("quantizationTable" + n4, parameterListDescriptor.getParamDefaultValue("quantizationTable" + n4));
                ++n4;
            }
        }
        int[] nArray3 = new int[n];
        int n5 = 0;
        while (n5 < n) {
            nArray3[n5] = jPEGDecodeParam.getQTableComponentMapping(n5);
            ++n5;
        }
        this.paramList.setParameter("quantizationTableMapping", nArray3);
        this.paramList.setParameter("writeTableInfo", jPEGDecodeParam.isTableInfoValid());
        this.paramList.setParameter("writeImageInfo", jPEGDecodeParam.isImageInfoValid());
        this.paramList.setParameter("restartInterval", jPEGDecodeParam.getRestartInterval());
        this.paramList.setParameter("writeJFIFHeader", jPEGDecodeParam.getMarker(224));
    }
}

