/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ColorModelState;
import com.sun.media.jai.rmi.DataBufferState;
import com.sun.media.jai.rmi.HashSetState;
import com.sun.media.jai.rmi.HashtableState;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.RasterState;
import com.sun.media.jai.rmi.RenderContextState;
import com.sun.media.jai.rmi.RenderedImageState;
import com.sun.media.jai.rmi.RenderingHintsState;
import com.sun.media.jai.rmi.RenderingKeyState;
import com.sun.media.jai.rmi.SampleModelState;
import com.sun.media.jai.rmi.SerializableStateImpl;
import com.sun.media.jai.rmi.ShapeState;
import com.sun.media.jai.rmi.VectorState;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.Serializer;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class SerializerImpl
implements Serializer {
    private Class theClass;
    private boolean areSubclassesPermitted;
    private Constructor ctor;

    public static final void registerSerializers() {
        SerializerImpl.registerSerializers(ColorModelState.class);
        SerializerImpl.registerSerializers(DataBufferState.class);
        SerializerImpl.registerSerializers(HashSetState.class);
        SerializerImpl.registerSerializers(HashtableState.class);
        SerializerImpl.registerSerializers(RasterState.class);
        SerializerImpl.registerSerializers(RenderedImageState.class);
        SerializerImpl.registerSerializers(RenderContextState.class);
        SerializerImpl.registerSerializers(RenderingHintsState.class);
        SerializerImpl.registerSerializers(RenderingKeyState.class);
        SerializerImpl.registerSerializers(SampleModelState.class);
        SerializerImpl.registerSerializers(VectorState.class);
        SerializerImpl.registerSerializers(ShapeState.class);
    }

    private static void registerSerializers(Class clazz) {
        Object object;
        Object object2;
        if (clazz == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!SerializableStateImpl.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializerImpl0"));
        }
        ImagingListener imagingListener = ImageUtil.getImagingListener(null);
        Class[] classArray = null;
        try {
            Method method = clazz.getMethod("getSupportedClasses", null);
            classArray = (Class[])method.invoke(null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object2 = JaiI18N.getString("SerializerImpl1");
            imagingListener.errorOccurred((String)object2, new RemoteImagingException((String)object2, noSuchMethodException), SerializerImpl.class, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = JaiI18N.getString("SerializerImpl1");
            imagingListener.errorOccurred((String)object2, new RemoteImagingException((String)object2, illegalAccessException), SerializerImpl.class, false);
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = JaiI18N.getString("SerializerImpl1");
            imagingListener.errorOccurred((String)object2, new RemoteImagingException((String)object2, invocationTargetException), SerializerImpl.class, false);
        }
        boolean bl = false;
        try {
            object2 = clazz.getMethod("permitsSubclasses", null);
            object = (Boolean)((Method)object2).invoke(null, null);
            bl = (Boolean)object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = JaiI18N.getString("SerializerImpl4");
            imagingListener.errorOccurred((String)object, new RemoteImagingException((String)object, noSuchMethodException), SerializerImpl.class, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = JaiI18N.getString("SerializerImpl4");
            imagingListener.errorOccurred((String)object, new RemoteImagingException((String)object, illegalAccessException), SerializerImpl.class, false);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = JaiI18N.getString("SerializerImpl4");
            imagingListener.errorOccurred((String)object, new RemoteImagingException((String)object, invocationTargetException), SerializerImpl.class, false);
        }
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            SerializerImpl serializerImpl = new SerializerImpl(clazz, classArray[n2], bl);
            SerializerFactory.registerSerializer(serializerImpl);
            ++n2;
        }
    }

    protected SerializerImpl(Class clazz, Class clazz2, boolean bl) {
        this.theClass = clazz2;
        this.areSubclassesPermitted = bl;
        try {
            Class[] classArray = new Class[]{Class.class, Object.class, RenderingHints.class};
            this.ctor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = String.valueOf(this.theClass.getName()) + ": " + JaiI18N.getString("SerializerImpl2");
            this.sendExceptionToListener(string, new RemoteImagingException(string, noSuchMethodException));
        }
    }

    @Override
    public SerializableState getState(Object object, RenderingHints renderingHints) {
        Object var3_3 = null;
        try {
            var3_3 = this.ctor.newInstance(this.theClass, object, renderingHints);
        }
        catch (InstantiationException instantiationException) {
            String string = String.valueOf(this.theClass.getName()) + ": " + JaiI18N.getString("SerializerImpl3");
            this.sendExceptionToListener(string, new RemoteImagingException(string, instantiationException));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = String.valueOf(this.theClass.getName()) + ": " + JaiI18N.getString("SerializerImpl3");
            this.sendExceptionToListener(string, new RemoteImagingException(string, illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = String.valueOf(this.theClass.getName()) + ": " + JaiI18N.getString("SerializerImpl3");
            this.sendExceptionToListener(string, new RemoteImagingException(string, invocationTargetException));
        }
        return var3_3;
    }

    @Override
    public Class getSupportedClass() {
        return this.theClass;
    }

    @Override
    public boolean permitsSubclasses() {
        return this.areSubclassesPermitted;
    }

    private void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(null);
        imagingListener.errorOccurred(string, new ImagingException(string, exception), this, false);
    }
}

