/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ColorModelProxy;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.NullPropertyTag;
import com.sun.media.jai.rmi.RMIImage;
import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.RenderContextProxy;
import com.sun.media.jai.rmi.SampleModelProxy;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.util.ImagingListener;

public class RMIImageImpl
implements RMIImage {
    public static final Object NULL_PROPERTY = new NullPropertyTag();
    private static long idCounter = 0L;
    private static Hashtable sources = null;
    private static Hashtable propertySources = null;

    private static synchronized void addSource(Long l, RenderedImage renderedImage, PropertySource propertySource) {
        if (sources == null) {
            sources = new Hashtable();
            propertySources = new Hashtable();
        }
        sources.put(l, renderedImage);
        propertySources.put(l, propertySource);
    }

    private static PlanarImage getSource(Long l) throws RemoteException {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (sources == null) break block2;
                Object v = sources.get(l);
                var1_1 = v;
                if (v != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    private static PropertySource getPropertySource(Long l) throws RemoteException {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (propertySources == null) break block2;
                Object v = propertySources.get(l);
                var1_1 = v;
                if (v != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    public RMIImageImpl() throws RemoteException {
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (RemoteException remoteException) {
            ImagingListener imagingListener = ImageUtil.getImagingListener(null);
            String string = JaiI18N.getString("RMIImageImpl0");
            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
        }
    }

    @Override
    public synchronized Long getRemoteID() throws RemoteException {
        return new Long(++idCounter);
    }

    @Override
    public void setSource(Long l, RenderedImage renderedImage) throws RemoteException {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RMIImageImpl.addSource(l, planarImage, planarImage);
    }

    @Override
    public void setSource(Long l, RenderedOp renderedOp) throws RemoteException {
        RMIImageImpl.addSource(l, renderedOp.getRendering(), renderedOp);
    }

    @Override
    public void setSource(Long l, RenderableOp renderableOp, RenderContextProxy renderContextProxy) throws RemoteException {
        RenderContext renderContext = renderContextProxy.getRenderContext();
        RenderedImage renderedImage = renderableOp.createRendering(renderContext);
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RMIImageImpl.addSource(l, planarImage, planarImage);
    }

    @Override
    public void dispose(Long l) throws RemoteException {
        if (sources != null) {
            sources.remove(l);
            propertySources.remove(l);
        }
    }

    @Override
    public Object getProperty(Long l, String string) throws RemoteException {
        PropertySource propertySource = RMIImageImpl.getPropertySource(l);
        Object object = propertySource.getProperty(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            object = NULL_PROPERTY;
        }
        return object;
    }

    @Override
    public String[] getPropertyNames(Long l) throws RemoteException {
        PropertySource propertySource = RMIImageImpl.getPropertySource(l);
        return propertySource.getPropertyNames();
    }

    @Override
    public int getMinX(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMinX();
    }

    public int getMaxX(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMaxX();
    }

    @Override
    public int getMinY(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMinY();
    }

    public int getMaxY(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMaxY();
    }

    @Override
    public int getWidth(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getWidth();
    }

    @Override
    public int getHeight(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getHeight();
    }

    @Override
    public int getTileWidth(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getTileWidth();
    }

    @Override
    public int getTileHeight(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getTileHeight();
    }

    @Override
    public int getTileGridXOffset(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getTileGridYOffset();
    }

    @Override
    public int getMinTileX(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMinTileX();
    }

    @Override
    public int getNumXTiles(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getNumXTiles();
    }

    @Override
    public int getMinTileY(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMinTileY();
    }

    @Override
    public int getNumYTiles(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getNumYTiles();
    }

    public int getMaxTileX(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMaxTileX();
    }

    public int getMaxTileY(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getMaxTileY();
    }

    @Override
    public SampleModelProxy getSampleModel(Long l) throws RemoteException {
        return new SampleModelProxy(RMIImageImpl.getSource(l).getSampleModel());
    }

    @Override
    public ColorModelProxy getColorModel(Long l) throws RemoteException {
        return new ColorModelProxy(RMIImageImpl.getSource(l).getColorModel());
    }

    @Override
    public Vector getSources(Long l) throws RemoteException {
        Vector vector = RMIImageImpl.getSource(l).getSources();
        int n = vector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            RenderedImage renderedImage = (RenderedImage)vector.get(n2);
            if (!(renderedImage instanceof Serializable)) {
                if (!bl) {
                    vector = (Vector)vector.clone();
                }
                vector.set(n2, new SerializableRenderedImage(renderedImage, false));
            }
            ++n2;
        }
        return vector;
    }

    public Rectangle getBounds(Long l) throws RemoteException {
        return RMIImageImpl.getSource(l).getBounds();
    }

    @Override
    public RasterProxy getTile(Long l, int n, int n2) throws RemoteException {
        return new RasterProxy(RMIImageImpl.getSource(l).getTile(n, n2));
    }

    @Override
    public RasterProxy getData(Long l) throws RemoteException {
        return new RasterProxy(RMIImageImpl.getSource(l).getData());
    }

    @Override
    public RasterProxy getData(Long l, Rectangle rectangle) throws RemoteException {
        RasterProxy rasterProxy = null;
        if (rectangle == null) {
            rasterProxy = this.getData(l);
        } else {
            rectangle = rectangle.intersection(this.getBounds(l));
            rasterProxy = new RasterProxy(RMIImageImpl.getSource(l).getData(rectangle));
        }
        return rasterProxy;
    }

    @Override
    public RasterProxy copyData(Long l, Rectangle rectangle) throws RemoteException {
        return this.getData(l, rectangle);
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        String string = null;
        int n = 1099;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-host")) {
                string = stringArray[++n2];
            } else if (stringArray[n2].equalsIgnoreCase("-port")) {
                n = Integer.parseInt(stringArray[++n2]);
            }
            ++n2;
        }
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(String.valueOf(JaiI18N.getString("RMIImageImpl1")) + unknownHostException.getMessage());
                unknownHostException.printStackTrace();
            }
        }
        System.out.println(String.valueOf(JaiI18N.getString("RMIImageImpl3")) + " " + string + ":" + n);
        try {
            RMIImageImpl rMIImageImpl = new RMIImageImpl();
            String string2 = new String("rmi://" + string + ":" + n + "/" + "RemoteImageServer");
            System.out.println(String.valueOf(JaiI18N.getString("RMIImageImpl4")) + " \"" + string2 + "\".");
            Naming.rebind(string2, rMIImageImpl);
            System.out.println(JaiI18N.getString("RMIImageImpl5"));
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(JaiI18N.getString("RMIImageImpl0")) + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

