/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.InterfaceHandler;
import com.sun.media.jai.rmi.JaiI18N;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.media.jai.JAI;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.Serializer;

public class InterfaceState
implements SerializableState {
    private transient Object theObject;
    private transient Serializer[] theSerializers;
    private transient RenderingHints hints;

    public InterfaceState(Object object, Serializer[] serializerArray, RenderingHints renderingHints) {
        if (object == null || serializerArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.theObject = object;
        this.theSerializers = serializerArray;
        this.hints = renderingHints == null ? null : (RenderingHints)renderingHints.clone();
    }

    @Override
    public Object getObject() {
        return this.theObject;
    }

    @Override
    public Class getObjectClass() {
        return this.theObject.getClass();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.theSerializers.length;
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Serializer serializer = this.theSerializers[n2];
            objectOutputStream.writeObject(serializer.getSupportedClass());
            objectOutputStream.writeObject(serializer.getState(this.theObject, this.hints));
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        Class[] classArray = new Class[n];
        SerializableState[] serializableStateArray = new SerializableState[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = (Class)objectInputStream.readObject();
            serializableStateArray[n2] = (SerializableState)objectInputStream.readObject();
            ++n2;
        }
        InterfaceHandler interfaceHandler = new InterfaceHandler(classArray, serializableStateArray);
        this.theObject = Proxy.newProxyInstance(JAI.class.getClassLoader(), classArray, (InvocationHandler)interfaceHandler);
    }
}

