/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.media.jai.remote.SerializableState;

class InterfaceHandler
implements InvocationHandler {
    private Hashtable interfaceMap;

    public InterfaceHandler(Class[] classArray, SerializableState[] serializableStateArray) {
        if (classArray == null || serializableStateArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (classArray.length != serializableStateArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("InterfaceHandler0"));
        }
        int n = classArray.length;
        this.interfaceMap = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            SerializableState serializableState = serializableStateArray[n2];
            if (!clazz.isAssignableFrom(serializableState.getObjectClass())) {
                throw new RuntimeException(JaiI18N.getString("InterfaceHandler1"));
            }
            Object object = serializableState.getObject();
            this.interfaceMap.put(clazz, object);
            ++n2;
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        Object object2;
        Class<?> clazz = method.getDeclaringClass();
        if (!this.interfaceMap.containsKey(clazz)) {
            object2 = this.interfaceMap.keySet().toArray(new Class[0]);
            int n = 0;
            while (n < ((Class[])object2).length) {
                Class clazz2 = object2[n];
                if (clazz.isAssignableFrom(clazz2)) {
                    this.interfaceMap.put(clazz, this.interfaceMap.get(clazz2));
                    break;
                }
                ++n;
            }
            if (!this.interfaceMap.containsKey(clazz)) {
                throw new RuntimeException(String.valueOf(clazz.getName()) + JaiI18N.getString("InterfaceHandler2"));
            }
        }
        object2 = null;
        try {
            Object v = this.interfaceMap.get(clazz);
            object2 = method.invoke(v, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(String.valueOf(method.getName()) + JaiI18N.getString("InterfaceHandler3"));
        }
        return object2;
    }
}

