/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.SerializableStateImpl;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.RenderingHints;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;

public class DataBufferState
extends SerializableStateImpl {
    private static Class[] J2DDataBufferClasses = null;
    private transient DataBuffer dataBuffer;

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.image.DataBufferFloat");
            Class<?> clazz2 = Class.forName("java.awt.image.DataBufferDouble");
            J2DDataBufferClasses = new Class[]{clazz, clazz2};
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static Class[] getSupportedClasses() {
        Class[] classArray = null;
        classArray = J2DDataBufferClasses != null ? new Class[]{DataBufferByte.class, DataBufferShort.class, DataBufferUShort.class, DataBufferInt.class, J2DDataBufferClasses[0], J2DDataBufferClasses[1], DataBufferFloat.class, DataBufferDouble.class} : new Class[]{DataBufferByte.class, DataBufferShort.class, DataBufferUShort.class, DataBufferInt.class, DataBufferFloat.class, DataBufferDouble.class};
        return classArray;
    }

    public DataBufferState(Class clazz, Object object, RenderingHints renderingHints) {
        super(clazz, object, renderingHints);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        DataBuffer dataBuffer = (DataBuffer)this.theObject;
        int n = dataBuffer.getDataType();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeObject(dataBuffer.getOffsets());
        objectOutputStream.writeInt(dataBuffer.getSize());
        Object object = null;
        switch (n) {
            case 0: {
                object = ((DataBufferByte)dataBuffer).getBankData();
                break;
            }
            case 2: {
                object = ((DataBufferShort)dataBuffer).getBankData();
                break;
            }
            case 1: {
                object = ((DataBufferUShort)dataBuffer).getBankData();
                break;
            }
            case 3: {
                object = ((DataBufferInt)dataBuffer).getBankData();
                break;
            }
            case 4: {
                object = DataBufferUtils.getBankDataFloat(dataBuffer);
                break;
            }
            case 5: {
                object = DataBufferUtils.getBankDataDouble(dataBuffer);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferState0"));
            }
        }
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DataBuffer dataBuffer = null;
        int n = -1;
        int[] nArray = null;
        int n2 = -1;
        Object object = null;
        n = objectInputStream.readInt();
        nArray = (int[])objectInputStream.readObject();
        n2 = objectInputStream.readInt();
        object = objectInputStream.readObject();
        switch (n) {
            case 0: {
                dataBuffer = new DataBufferByte((byte[][])object, n2, nArray);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort((short[][])object, n2, nArray);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort((short[][])object, n2, nArray);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt((int[][])object, n2, nArray);
                break;
            }
            case 4: {
                dataBuffer = DataBufferUtils.createDataBufferFloat((float[][])object, n2, nArray);
                break;
            }
            case 5: {
                dataBuffer = DataBufferUtils.createDataBufferDouble((double[][])object, n2, nArray);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferState0"));
            }
        }
        this.theObject = dataBuffer;
    }
}

