/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.WarpBilinearOpImage;
import com.sun.media.jai.opimage.WarpGeneralOpImage;
import com.sun.media.jai.opimage.WarpNearestOpImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.Warp;

public class WarpRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Warp warp = (Warp)parameterBlock.getObjectParameter(0);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(1);
        double[] dArray = (double[])parameterBlock.getObjectParameter(2);
        if (interpolation instanceof InterpolationNearest) {
            return new WarpNearestOpImage(renderedImage, renderingHints, imageLayout, warp, interpolation, dArray);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new WarpBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, warp, interpolation, dArray);
        }
        return new WarpGeneralOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, warp, interpolation, dArray);
    }
}

