/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;

public final class TranslateIntOpImage
extends OpImage {
    private int transX;
    private int transY;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, int n, int n2) {
        ImageLayout imageLayout = new ImageLayout(renderedImage.getMinX() + n, renderedImage.getMinY() + n2, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getTileGridXOffset() + n, renderedImage.getTileGridYOffset() + n2, renderedImage.getTileWidth(), renderedImage.getTileHeight(), renderedImage.getSampleModel(), renderedImage.getColorModel());
        return imageLayout;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
                map2.remove(JAI.KEY_TILE_CACHE);
            } else if (map2.containsKey(JAI.KEY_TILE_CACHE)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.remove(JAI.KEY_TILE_CACHE);
            }
        }
        return map2;
    }

    public TranslateIntOpImage(RenderedImage renderedImage, Map map, int n, int n2) {
        super(TranslateIntOpImage.vectorize(renderedImage), TranslateIntOpImage.layoutHelper(renderedImage, n, n2), TranslateIntOpImage.configHelper(map), false);
        this.transX = n;
        this.transY = n2;
    }

    @Override
    public boolean computesUniqueTiles() {
        return false;
    }

    @Override
    public Raster computeTile(int n, int n2) {
        return this.getTile(n, n2);
    }

    @Override
    public Raster getTile(int n, int n2) {
        Raster raster = this.getSource(0).getTile(n, n2);
        if (raster == null) {
            return null;
        }
        return raster.createTranslatedChild(this.tileXToX(n), this.tileYToY(n2));
    }

    @Override
    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("TranslateIntOpImage0"));
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(this.transX, this.transY);
        return rectangle2;
    }

    @Override
    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("TranslateIntOpImage0"));
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(-this.transX, -this.transY);
        return rectangle2;
    }
}

