/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.ScaleBicubicOpImage;
import com.sun.media.jai.opimage.ScaleBilinearBinaryOpImage;
import com.sun.media.jai.opimage.ScaleBilinearOpImage;
import com.sun.media.jai.opimage.ScaleGeneralOpImage;
import com.sun.media.jai.opimage.ScaleNearestBinaryOpImage;
import com.sun.media.jai.opimage.ScaleNearestOpImage;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;

public class TranslateCRIF
extends CRIFImpl {
    private static final float TOLERANCE = 0.01f;

    public TranslateCRIF() {
        super("translate");
    }

    @Override
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl;
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(2);
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (Math.abs(f - (float)((int)f)) < 0.01f && Math.abs(f2 - (float)((int)f2)) < 0.01f && imageLayout == null) {
            return new TranslateIntOpImage(renderedImage, renderingHints, (int)f, (int)f2);
        }
        RIFUtil.getTileCacheHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f3 = 1.0f;
        float f4 = 1.0f;
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        if (interpolation instanceof InterpolationNearest) {
            if (bl) {
                return new ScaleNearestBinaryOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f3, f4, f, f2, interpolation);
            }
            return new ScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f3, f4, f, f2, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            if (bl) {
                return new ScaleBilinearBinaryOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f3, f4, f, f2, interpolation);
            }
            return new ScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f3, f4, f, f2, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new ScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f3, f4, f, f2, interpolation);
        }
        return new ScaleGeneralOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f3, f4, f, f2, interpolation);
    }

    @Override
    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        return parameterBlock.getRenderedSource(0);
    }

    @Override
    public RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(parameterBlock.getFloatParameter(0), parameterBlock.getFloatParameter(1));
        RenderContext renderContext2 = (RenderContext)renderContext.clone();
        AffineTransform affineTransform2 = renderContext2.getTransform();
        affineTransform2.concatenate(affineTransform);
        renderContext2.setTransform(affineTransform2);
        return renderContext2;
    }

    @Override
    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        return new Rectangle2D.Float(renderableImage.getMinX() + f, renderableImage.getMinY() + f2, renderableImage.getWidth(), renderableImage.getHeight());
    }
}

