/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ThresholdOpImage
extends ColormapOpImage {
    private double[] low;
    private double[] high;
    private double[] constants;
    private byte[][] byteTable = null;

    public ThresholdOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, imageLayout, map, true);
        int n = this.getSampleModel().getNumBands();
        this.low = new double[n];
        this.high = new double[n];
        this.constants = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.low[n2] = dArray.length < n ? dArray[0] : dArray[n2];
            this.high[n2] = dArray2.length < n ? dArray2[0] : dArray2[n2];
            this.constants[n2] = dArray3.length < n ? dArray3[0] : dArray3[n2];
            ++n2;
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    @Override
    protected void transformColormap(byte[][] byArray) {
        this.initByteTable();
        int n = 0;
        while (n < 3) {
            byte[] byArray2 = byArray[n];
            byte[] byArray3 = this.byteTable[n >= this.byteTable.length ? 0 : n];
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byArray2[n3] = byArray3[byArray2[n3] & 0xFF];
                ++n3;
            }
            ++n;
        }
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getWidth() * n3;
        int n6 = rasterAccessor2.getHeight() * n4;
        int n7 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getByteDataArrays(), n3, n4, nArray2, rasterAccessor2.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getIntDataArrays(), n3, n4, nArray2, rasterAccessor2.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getFloatDataArrays(), n3, n4, nArray2, rasterAccessor2.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getDoubleDataArrays(), n3, n4, nArray2, rasterAccessor2.getDoubleDataArrays());
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2) {
        this.initByteTable();
        int n8 = 0;
        while (n8 < n3) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            byte[] byArray5 = this.byteTable[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    byArray4[n13] = byArray5[byArray3[n14] & 0xFF];
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            short s = (short)this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    short s2 = sArray3[n14];
                    sArray4[n13] = (double)s2 >= d && (double)s2 <= d2 ? s : s2;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void ushortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            short s = (short)this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    int n15 = sArray3[n14] & 0xFFFF;
                    sArray4[n13] = (double)n15 >= d && (double)n15 <= d2 ? s : (short)n15;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4) {
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            int n9 = (int)this.constants[n8];
            int n10 = nArray3[n8] + n2;
            int n11 = nArray3[n8];
            int n12 = nArray[n8];
            while (n11 < n10) {
                int n13 = n11 + n;
                int n14 = n11;
                int n15 = n12;
                while (n14 < n13) {
                    int n16 = nArray5[n15];
                    nArray6[n14] = (double)n16 >= d && (double)n16 <= d2 ? n9 : n16;
                    n14 += n6;
                    n15 += n4;
                }
                n11 += n7;
                n12 += n5;
            }
            ++n8;
        }
    }

    private void floatLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int n6, int n7, int[] nArray2, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            float f = (float)this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    float f2 = fArray3[n14];
                    fArray4[n13] = (double)f2 >= d && (double)f2 <= d2 ? f : f2;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private void doubleLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6, int n7, int[] nArray2, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            double d3 = this.constants[n8];
            int n9 = nArray2[n8] + n2;
            int n10 = nArray2[n8];
            int n11 = nArray[n8];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    double d4 = dArray3[n14];
                    dArray4[n13] = d4 >= d && d4 <= d2 ? d3 : d4;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
            ++n8;
        }
    }

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        int n = this.getSampleModel().getNumBands();
        this.byteTable = new byte[n][256];
        int n2 = 0;
        while (n2 < n) {
            double d = this.low[n2];
            double d2 = this.high[n2];
            byte by = (byte)this.constants[n2];
            byte[] byArray = this.byteTable[n2];
            int n3 = 0;
            while (n3 < 256) {
                byArray[n3] = (double)n3 >= d && (double)n3 <= d2 ? by : (byte)n3;
                ++n3;
            }
            ++n2;
        }
    }
}

