/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

public class SubsampleBinaryToGrayOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float invScaleX;
    protected float invScaleY;
    private float floatTol;
    private int blockX;
    private int blockY;
    private int dWidth;
    private int dHeight;
    private int[] xValues;
    private int[] yValues;
    private int[] lut = new int[256];
    protected byte[] lutGray;

    static ImageLayout layoutHelper(RenderedImage renderedImage, float f, float f2, ImageLayout imageLayout, Map map) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        float f3 = f * (float)n;
        float f4 = f2 * (float)n2;
        float f5 = 0.1f * Math.min(f / (f3 + 1.0f), f2 / (f4 + 1.0f));
        int n3 = (int)f3;
        int n4 = (int)f4;
        if (Math.abs((float)Math.round(f3) - f3) < f5) {
            n3 = Math.round(f3);
        }
        if (Math.abs((float)Math.round(f4) - f4) < f5) {
            n4 = Math.round(f4);
        }
        imageLayout2.setMinX((int)(f * (float)renderedImage.getMinX()));
        imageLayout2.setMinY((int)(f2 * (float)renderedImage.getMinY()));
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        SampleModel sampleModel = imageLayout2.getSampleModel(null);
        if (sampleModel == null || sampleModel.getDataType() != 0 || !(sampleModel instanceof PixelInterleavedSampleModel) && (!(sampleModel instanceof SinglePixelPackedSampleModel) || sampleModel.getNumBands() != 1)) {
            sampleModel = new PixelInterleavedSampleModel(0, 1, 1, 1, 1, new int[1]);
        }
        imageLayout2.setSampleModel(sampleModel);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public SubsampleBinaryToGrayOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, float f, float f2) {
        super(SubsampleBinaryToGrayOpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, f, f2, imageLayout, map), SubsampleBinaryToGrayOpImage.configHelper(map), true, null, null, null);
        this.scaleX = f;
        this.scaleY = f2;
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        this.computeDestInfo(n3, n4);
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
        this.computeXYValues(n3, n4, n, n2);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / (double)this.scaleX, point2D.getY() / (double)this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * (double)this.scaleX, point2D.getY() * (double)this.scaleY);
        return point2D2;
    }

    @Override
    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x - this.blockX + 1;
        int n3 = rectangle.y - this.blockY + 1;
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 < 0 ? 0 : n3;
        int n4 = (int)((float)n2 * this.scaleX);
        int n5 = (int)((float)n3 * this.scaleY);
        while (this.xValues[n4] > n2 && n4 > 0) {
            --n4;
        }
        while (this.yValues[n5] > n3 && n5 > 0) {
            --n5;
        }
        int n6 = rectangle.x + rectangle.width - 1;
        int n7 = rectangle.y + rectangle.height - 1;
        int n8 = Math.round((float)n6 * this.scaleX);
        int n9 = Math.round((float)n7 * this.scaleY);
        n8 = n8 >= this.dWidth ? this.dWidth - 1 : n8;
        n9 = n9 >= this.dHeight ? this.dHeight - 1 : n9;
        while (this.xValues[n8] < n6 && n8 < this.dWidth - 1) {
            ++n8;
        }
        while (this.yValues[n9] < n7 && n9 < this.dHeight - 1) {
            ++n9;
        }
        return new Rectangle(n4 += this.minX, n5 += this.minY, (n8 += this.minX) - n4 + 1, (n9 += this.minY) - n5 + 1);
    }

    @Override
    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = this.xValues[rectangle.x - this.minX];
        int n3 = this.yValues[rectangle.y - this.minY];
        int n4 = this.xValues[rectangle.x - this.minX + rectangle.width - 1];
        int n5 = this.yValues[rectangle.y - this.minY + rectangle.height - 1];
        return new Rectangle(n2, n3, n4 - n2 + this.blockX, n5 - n3 + this.blockY);
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2;
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n3 = packedImageData.offset;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = packedImageData.rect.x;
        int n9 = packedImageData.rect.y;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n10 = writableRaster.getSampleModelTranslateX();
        int n11 = writableRaster.getSampleModelTranslateY();
        int n12 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n13 = dataBufferByte.getOffset();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        int n14 = 0;
        while (n14 < n6) {
            n2 = this.xValues[n4 + n14 - this.minX];
            n = packedImageData.bitOffset + (n2 - n8);
            nArray[n14] = n >> 3;
            nArray2[n14] = n % 8;
            ++n14;
        }
        n14 = 0;
        while (n14 < n7) {
            n2 = 0;
            while (n2 < n6) {
                nArray3[n2] = 0;
                ++n2;
            }
            n2 = this.yValues[n5 + n14 - this.minY];
            while (n2 < this.yValues[n5 + n14 - this.minY] + this.blockY) {
                n = (n2 - n9) * packedImageData.lineStride + n3;
                int n15 = 0;
                int n16 = 0;
                while (n16 < n6) {
                    n15 = 0;
                    int n17 = nArray2[n16] + this.blockX - 1;
                    int n18 = nArray[n16] + (n17 >> 3);
                    n17 %= 8;
                    int n19 = 0xFF & byArray[n + nArray[n16]];
                    if (nArray[n16] == n18) {
                        n19 <<= 24 + nArray2[n16];
                        n15 += this.lut[n19 >>>= 31 - n17 + nArray2[n16]];
                    } else {
                        n19 <<= 24 + nArray2[n16];
                        n15 += this.lut[n19 >>>= 24];
                        int n20 = nArray[n16] + 1;
                        while (n20 < n18) {
                            n19 = 0xFF & byArray[n + n20];
                            n15 += this.lut[n19];
                            ++n20;
                        }
                        n19 = 0xFF & byArray[n + n18];
                        n15 += this.lut[n19 >>>= 7 - n17];
                    }
                    int n21 = n16++;
                    nArray3[n21] = nArray3[n21] + n15;
                }
                ++n2;
            }
            n2 = (n14 + n5 - n11) * n12 + n13;
            n2 += n4 - n10;
            n = 0;
            while (n < n6) {
                byArray2[n2 + n] = this.lutGray[nArray3[n]];
                ++n;
            }
            ++n14;
        }
    }

    private void computeDestInfo(int n, int n2) {
        this.invScaleX = 1.0f / this.scaleX;
        this.invScaleY = 1.0f / this.scaleY;
        this.blockX = (int)Math.ceil(this.invScaleX);
        this.blockY = (int)Math.ceil(this.invScaleY);
        float f = this.scaleX * (float)n;
        float f2 = this.scaleY * (float)n2;
        this.floatTol = 0.1f * Math.min(this.scaleX / (f + 1.0f), this.scaleY / (f2 + 1.0f));
        this.dWidth = (int)f;
        this.dHeight = (int)f2;
        if (Math.abs((float)Math.round(f) - f) < this.floatTol) {
            this.dWidth = Math.round(f);
        }
        if (Math.abs((float)Math.round(f2) - f2) < this.floatTol) {
            this.dHeight = Math.round(f2);
        }
        if (Math.abs((float)Math.round(this.invScaleX) - this.invScaleX) < this.floatTol) {
            this.invScaleX = Math.round(this.invScaleX);
            this.blockX = (int)this.invScaleX;
        }
        if (Math.abs((float)Math.round(this.invScaleY) - this.invScaleY) < this.floatTol) {
            this.invScaleY = Math.round(this.invScaleY);
            this.blockY = (int)this.invScaleY;
        }
    }

    private final void buildLookupTables() {
        this.lut[0] = 0;
        this.lut[1] = 1;
        this.lut[2] = 1;
        this.lut[3] = 2;
        this.lut[4] = 1;
        this.lut[5] = 2;
        this.lut[6] = 2;
        this.lut[7] = 3;
        this.lut[8] = 1;
        this.lut[9] = 2;
        this.lut[10] = 2;
        this.lut[11] = 3;
        this.lut[12] = 2;
        this.lut[13] = 3;
        this.lut[14] = 3;
        this.lut[15] = 4;
        int n = 16;
        while (n < 256) {
            this.lut[n] = this.lut[n & 0xF] + this.lut[n >> 4 & 0xF];
            ++n;
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        n = 0;
        while (n < this.lutGray.length) {
            int n2 = Math.round(255.0f * (float)n / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n] = (byte)(n2 > 255 ? -1 : (byte)n2);
            ++n;
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n = 0;
            while (n < this.lutGray.length) {
                this.lutGray[n] = (byte)(255 - (0xFF & this.lutGray[n]));
                ++n;
            }
        }
    }

    private void computeXYValues(int n, int n2, int n3, int n4) {
        float f;
        if (this.xValues == null || this.yValues == null) {
            this.xValues = new int[this.dWidth];
            this.yValues = new int[this.dHeight];
        }
        int n5 = 0;
        while (n5 < this.dWidth) {
            f = this.invScaleX * (float)n5;
            this.xValues[n5] = Math.round(f);
            ++n5;
        }
        if (this.xValues[this.dWidth - 1] + this.blockX > n) {
            int n6 = this.dWidth - 1;
            this.xValues[n6] = this.xValues[n6] - 1;
        }
        n5 = 0;
        while (n5 < this.dHeight) {
            f = this.invScaleY * (float)n5;
            this.yValues[n5] = Math.round(f);
            ++n5;
        }
        if (this.yValues[this.dHeight - 1] + this.blockY > n2) {
            int n7 = this.dHeight - 1;
            this.yValues[n7] = this.yValues[n7] - 1;
        }
        if (n3 != 0) {
            n5 = 0;
            while (n5 < this.dWidth) {
                int n8 = n5++;
                this.xValues[n8] = this.xValues[n8] + n3;
            }
        }
        if (n4 != 0) {
            n5 = 0;
            while (n5 < this.dHeight) {
                int n9 = n5++;
                this.yValues[n9] = this.yValues[n9] + n4;
            }
        }
    }

    static boolean isMinWhite(ColorModel colorModel) {
        if (colorModel == null || !(colorModel instanceof IndexColorModel)) {
            return false;
        }
        byte[] byArray = new byte[256];
        ((IndexColorModel)colorModel).getReds(byArray);
        return byArray[0] == -1;
    }
}

