/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.SubsampleBinaryToGrayOpImage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

class SubsampleBinaryToGray4x4OpImage
extends GeometricOpImage {
    private int blockX = 4;
    private int blockY = 4;
    private int dWidth;
    private int dHeight;
    private int[] xValues;
    private int[] yValues;
    private int[] lut;
    private byte[] lutGray;

    public SubsampleBinaryToGray4x4OpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        super(SubsampleBinaryToGray4x4OpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, 0.25f, 0.25f, imageLayout, map), map, true, null, null, null);
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        this.blockY = 4;
        this.blockX = 4;
        this.dWidth = n / this.blockX;
        this.dHeight = n2 / this.blockY;
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
        this.computeXYValues(this.dWidth, this.dHeight);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * 4.0, point2D.getY() * 4.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / 4.0, point2D.getY() / 4.0);
        return point2D2;
    }

    @Override
    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = n2 / this.blockX;
        int n5 = n3 / this.blockY;
        int n6 = rectangle.x + rectangle.width - 1;
        int n7 = rectangle.y + rectangle.height - 1;
        int n8 = n6 / this.blockX;
        int n9 = n7 / this.blockY;
        return new Rectangle(n4, n5, n8 - n4 + 1, n9 - n5 + 1);
    }

    @Override
    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x * this.blockX;
        int n3 = rectangle.y * this.blockY;
        int n4 = (rectangle.x + rectangle.width - 1) * this.blockX;
        int n5 = (rectangle.y + rectangle.height - 1) * this.blockY;
        return new Rectangle(n2, n3, n4 - n2 + this.blockX, n5 - n3 + this.blockY);
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop4x4(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop4x4(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        if (packedImageData.bitOffset % 4 != 0) {
            this.byteLoop(raster, writableRaster, rectangle);
            return;
        }
        byte[] byArray = packedImageData.data;
        int n = packedImageData.offset;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = packedImageData.rect.x;
        int n7 = packedImageData.rect.y;
        int n8 = packedImageData.bitOffset;
        int n9 = packedImageData.lineStride;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n10 = writableRaster.getSampleModelTranslateX();
        int n11 = writableRaster.getSampleModelTranslateY();
        int n12 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n13 = dataBufferByte.getOffset();
        int[] nArray = new int[2];
        int n14 = 0;
        while (n14 < n5) {
            int n15 = n3 + n14 << 2;
            int n16 = (n15 - n7) * n9 + n;
            int n17 = (n14 + n3 - n11) * n12 + n13;
            n17 += n2 - n10;
            int n18 = (n2 << 2) - n6 + n8;
            int n19 = 0;
            while (n19 < n4) {
                int n20 = n18 >> 3;
                int n21 = n18 % 8;
                int n22 = n16 + n20;
                nArray[1] = 0;
                nArray[0] = 0;
                int n23 = 0;
                while (n23 < 4) {
                    int n24 = 0xFF & byArray[n22];
                    nArray[1] = nArray[1] + this.lut[n24 & 0xF];
                    nArray[0] = nArray[0] + this.lut[n24 >> 4];
                    ++n23;
                    n22 += n9;
                }
                n21 >>= 2;
                while (n21 < 2 && n19 < n4) {
                    byArray2[n17 + n19] = this.lutGray[nArray[n21]];
                    ++n21;
                    ++n19;
                    n18 += this.blockX;
                }
            }
            ++n14;
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2;
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n3 = packedImageData.offset;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = packedImageData.rect.x;
        int n9 = packedImageData.rect.y;
        int n10 = packedImageData.bitOffset;
        int n11 = packedImageData.lineStride;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n12 = writableRaster.getSampleModelTranslateX();
        int n13 = writableRaster.getSampleModelTranslateY();
        int n14 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n15 = dataBufferByte.getOffset();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        int n16 = 0;
        while (n16 < n6) {
            n2 = this.xValues[n4 + n16];
            n = n10 + (n2 - n8);
            nArray[n16] = n >> 3;
            nArray2[n16] = n % 8;
            ++n16;
        }
        n16 = 0;
        while (n16 < n7) {
            n2 = 0;
            while (n2 < n6) {
                nArray3[n2] = 0;
                ++n2;
            }
            n2 = this.yValues[n5 + n16];
            while (n2 < this.yValues[n5 + n16] + this.blockY) {
                n = (n2 - n9) * n11 + n3;
                int n17 = 0;
                while (n17 < n6) {
                    int n18 = 0;
                    int n19 = nArray2[n17] + this.blockX - 1;
                    int n20 = nArray[n17] + (n19 >> 3);
                    n19 %= 8;
                    int n21 = 0xFF & byArray[n + nArray[n17]];
                    int n22 = 24 + nArray2[n17];
                    if (nArray[n17] == n20) {
                        n21 <<= n22;
                        n18 += this.lut[n21 >>>= 31 - n19 + nArray2[n17]];
                    } else {
                        n21 <<= n22;
                        n18 += this.lut[n21 >>>= n22];
                        int n23 = nArray[n17] + 1;
                        while (n23 < n20) {
                            n21 = 0xFF & byArray[n + n23];
                            n18 += this.lut[n21];
                            ++n23;
                        }
                        n21 = 0xFF & byArray[n + n20];
                        n18 += this.lut[n21 >>>= 7 - n19];
                    }
                    int n24 = n17++;
                    nArray3[n24] = nArray3[n24] + n18;
                }
                ++n2;
            }
            n2 = (n16 + n5 - n13) * n14 + n15;
            n2 += n4 - n12;
            n = 0;
            while (n < n6) {
                byArray2[n2 + n] = this.lutGray[nArray3[n]];
                ++n;
            }
            ++n16;
        }
    }

    private final void buildLookupTables() {
        this.lut = new int[16];
        this.lut[0] = 0;
        this.lut[1] = 1;
        this.lut[2] = 1;
        this.lut[3] = 2;
        this.lut[4] = 1;
        this.lut[5] = 2;
        this.lut[6] = 2;
        this.lut[7] = 3;
        int n = 8;
        while (n < 16) {
            this.lut[n] = 1 + this.lut[n - 8];
            ++n;
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        n = 0;
        while (n < this.lutGray.length) {
            int n2 = Math.round(255.0f * (float)n / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n] = (byte)(n2 > 255 ? -1 : (byte)n2);
            ++n;
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n = 0;
            while (n < this.lutGray.length) {
                this.lutGray[n] = (byte)(255 - (0xFF & this.lutGray[n]));
                ++n;
            }
        }
    }

    private void computeXYValues(int n, int n2) {
        if (this.xValues == null || this.yValues == null) {
            this.xValues = new int[n];
            this.yValues = new int[n2];
        }
        int n3 = 0;
        while (n3 < n) {
            this.xValues[n3] = n3 << 2;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.yValues[n3] = n3 << 2;
            ++n3;
        }
    }
}

