/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.SubsampleBinaryToGrayOpImage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

class SubsampleBinaryToGray2x2OpImage
extends GeometricOpImage {
    private int blockX = 2;
    private int blockY = 2;
    private int dWidth;
    private int dHeight;
    private int[] lut4_45;
    private int[] lut4_67;
    private byte[] lutGray;

    public SubsampleBinaryToGray2x2OpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        super(SubsampleBinaryToGray2x2OpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, 0.5f, 0.5f, imageLayout, map), map, true, null, null, null);
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        this.dWidth = n / this.blockX;
        this.dHeight = n2 / this.blockY;
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * 2.0, point2D.getY() * 2.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / 2.0, point2D.getY() / 2.0);
        return point2D2;
    }

    @Override
    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x / this.blockX;
        int n3 = rectangle.y / this.blockY;
        int n4 = (rectangle.x + rectangle.width - 1) / this.blockX;
        int n5 = (rectangle.y + rectangle.height - 1) / this.blockY;
        return new Rectangle(n2, n3, n4 - n2 + 1, n5 - n3 + 1);
    }

    @Override
    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x * this.blockX;
        int n3 = rectangle.y * this.blockY;
        int n4 = (rectangle.x + rectangle.width - 1) * this.blockX;
        int n5 = (rectangle.y + rectangle.height - 1) * this.blockY;
        return new Rectangle(n2, n3, n4 - n2 + this.blockX, n5 - n3 + this.blockY);
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop2x2(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop2x2(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n = packedImageData.offset;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = packedImageData.rect.x;
        int n7 = packedImageData.rect.y;
        int n8 = packedImageData.bitOffset;
        int n9 = packedImageData.lineStride;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n10 = writableRaster.getSampleModelTranslateX();
        int n11 = writableRaster.getSampleModelTranslateY();
        int n12 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n13 = dataBufferByte.getOffset();
        int[] nArray = new int[4];
        if ((n8 & 1) == 0) {
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n3 + n14 << 1;
                int n16 = (n15 - n7) * n9 + n;
                int n17 = n16 + n9;
                int n18 = (n14 + n3 - n11) * n12 + n13;
                n18 += n2 - n10;
                int n19 = (n2 << 1) - n6 + n8;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = n19 >> 3;
                    int n22 = n19 % 8;
                    int n23 = 0xFF & byArray[n16 + n21];
                    nArray[2] = this.lut4_45[n23 & 0xF];
                    nArray[3] = this.lut4_67[n23 & 0xF];
                    nArray[0] = this.lut4_45[n23 >>= 4];
                    nArray[1] = this.lut4_67[n23];
                    n23 = 0xFF & byArray[n17 + n21];
                    nArray[2] = nArray[2] + this.lut4_45[n23 & 0xF];
                    nArray[3] = nArray[3] + this.lut4_67[n23 & 0xF];
                    nArray[0] = nArray[0] + this.lut4_45[n23 >>= 4];
                    nArray[1] = nArray[1] + this.lut4_67[n23];
                    n22 >>= 1;
                    while (n22 < 4 && n20 < n4) {
                        byArray2[n18 + n20] = this.lutGray[nArray[n22]];
                        ++n22;
                        ++n20;
                        n19 += this.blockX;
                    }
                }
                ++n14;
            }
        } else {
            int n24 = 0;
            while (n24 < n5) {
                int n25 = n3 + n24 << 1;
                int n26 = (n25 - n7) * n9 + n;
                int n27 = n26 + n9;
                int n28 = (n24 + n3 - n11) * n12 + n13;
                n28 += n2 - n10;
                int n29 = (n2 << 1) - n6 + n8;
                int n30 = 0;
                while (n30 < n4) {
                    int n31 = n29 >> 3;
                    int n32 = n29 % 8;
                    int n33 = 0xFF & byArray[n26 + n31] << 1;
                    nArray[2] = this.lut4_45[n33 & 0xF];
                    nArray[3] = this.lut4_67[n33 & 0xF];
                    nArray[0] = this.lut4_45[n33 >>= 4];
                    nArray[1] = this.lut4_67[n33];
                    n33 = 0xFF & byArray[n27 + n31] << 1;
                    nArray[2] = nArray[2] + this.lut4_45[n33 & 0xF];
                    nArray[3] = nArray[3] + this.lut4_67[n33 & 0xF];
                    nArray[0] = nArray[0] + this.lut4_45[n33 >>= 4];
                    nArray[1] = nArray[1] + this.lut4_67[n33];
                    if (++n31 < byArray.length - n27) {
                        nArray[3] = nArray[3] + (byArray[n26 + n31] < 0 ? 1 : 0);
                        nArray[3] = nArray[3] + (byArray[n27 + n31] < 0 ? 1 : 0);
                    }
                    n32 >>= 1;
                    while (n32 < 4 && n30 < n4) {
                        byArray2[n28 + n30] = this.lutGray[nArray[n32]];
                        ++n32;
                        ++n30;
                        n29 += this.blockX;
                    }
                }
                ++n24;
            }
        }
    }

    private final void buildLookupTables() {
        this.lut4_45 = new int[16];
        this.lut4_67 = new int[16];
        this.lut4_67[0] = 0;
        this.lut4_67[1] = 1;
        this.lut4_67[2] = 1;
        this.lut4_67[3] = 2;
        int n = 4;
        while (n < 16) {
            this.lut4_67[n] = this.lut4_67[n & 3];
            ++n;
        }
        n = 0;
        while (n < 16) {
            this.lut4_45[n] = this.lut4_67[n >> 2];
            ++n;
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        n = 0;
        while (n < this.lutGray.length) {
            int n2 = Math.round(255.0f * (float)n / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n] = (byte)(n2 > 255 ? -1 : (byte)n2);
            ++n;
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n = 0;
            while (n < this.lutGray.length) {
                this.lutGray[n] = (byte)(255 - (0xFF & this.lutGray[n]));
                ++n;
            }
        }
    }
}

