/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import javax.media.jai.OpImage;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.TileCache;

class StreamImage
extends RenderedImageAdapter {
    private InputStream stream;

    public StreamImage(RenderedImage renderedImage, InputStream inputStream) {
        super(renderedImage);
        this.stream = inputStream;
        if (renderedImage instanceof OpImage) {
            this.setProperty("tile_cache_key", renderedImage);
            TileCache tileCache = ((OpImage)renderedImage).getTileCache();
            this.setProperty("tile_cache", tileCache == null ? Image.UndefinedProperty : tileCache);
        }
    }

    @Override
    public void dispose() {
        RenderedImage renderedImage = this.getWrappedImage();
        Method method = null;
        try {
            Class<?> clazz = renderedImage.getClass();
            method = clazz.getMethod("dispose", null);
            if (!method.isAccessible()) {
                AccessibleObject.setAccessible(new AccessibleObject[]{method}, true);
            }
            method.invoke((Object)renderedImage, null);
        }
        catch (Exception exception) {}
    }

    @Override
    protected void finalize() throws Throwable {
        this.stream.close();
        super.finalize();
    }
}

