/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleGeneralOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    Rational half = new Rational(1L, 2L);
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n2];
                nArray3 = new int[n];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n2];
                fArray = new float[n];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        long l = n8;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n7;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray[n11] = (n10 - n) * n3;
            nArray3[n11] = (int)((float)l8 / (float)l9 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < n6) {
            nArray2[n11] = (n9 - n2) * n4;
            nArray4[n11] = (int)((float)l3 / (float)l4 * (float)this.one);
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n11;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        long l = n8;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n7;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray[n11] = (n10 - n) * n3;
            fArray[n11] = (float)l8 / (float)l9;
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < n6) {
            nArray2[n11] = (n9 - n2) * n4;
            fArray2[n11] = (float)l3 / (float)l4;
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n11;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = 0;
                while (n15 < n3) {
                    int n16 = nArray3[n15];
                    int n17 = nArray[n15];
                    int n18 = this.interp_left * n + this.interp_top * n2;
                    n18 = n17 + n14 - n18;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    while (n21 < this.interp_height) {
                        int n22 = n18;
                        int n23 = 0;
                        while (n23 < this.interp_width) {
                            nArray7[n20][n19++] = byArray4[n18] & 0xFF;
                            n18 += n;
                            ++n23;
                        }
                        ++n20;
                        n19 = 0;
                        n18 = n22 + n2;
                        ++n21;
                    }
                    int n24 = this.interp.interpolate(nArray7, n16, n13);
                    if (n24 > 255) {
                        n24 = 255;
                    } else if (n24 < 0) {
                        n24 = 0;
                    }
                    byArray3[n12] = (byte)(n24 & 0xFF);
                    n12 += n6;
                    ++n15;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = 0;
                while (n15 < n3) {
                    int n16 = nArray3[n15];
                    int n17 = nArray[n15];
                    int n18 = this.interp_left * n + this.interp_top * n2;
                    n18 = n17 + n14 - n18;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    while (n21 < this.interp_height) {
                        int n22 = n18;
                        int n23 = 0;
                        while (n23 < this.interp_width) {
                            nArray7[n20][n19++] = sArray4[n18];
                            n18 += n;
                            ++n23;
                        }
                        ++n20;
                        n19 = 0;
                        n18 = n22 + n2;
                        ++n21;
                    }
                    int n24 = this.interp.interpolate(nArray7, n16, n13);
                    if (n24 > Short.MAX_VALUE) {
                        n24 = Short.MAX_VALUE;
                    } else if (n24 < Short.MIN_VALUE) {
                        n24 = Short.MIN_VALUE;
                    }
                    sArray3[n12] = (short)n24;
                    n12 += n6;
                    ++n15;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = 0;
                while (n15 < n3) {
                    int n16 = nArray3[n15];
                    int n17 = nArray[n15];
                    int n18 = this.interp_left * n + this.interp_top * n2;
                    n18 = n17 + n14 - n18;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    while (n21 < this.interp_height) {
                        int n22 = n18;
                        int n23 = 0;
                        while (n23 < this.interp_width) {
                            nArray7[n20][n19++] = sArray4[n18] & 0xFFFF;
                            n18 += n;
                            ++n23;
                        }
                        ++n20;
                        n19 = 0;
                        n18 = n22 + n2;
                        ++n21;
                    }
                    int n24 = this.interp.interpolate(nArray7, n16, n13);
                    if (n24 > 65536) {
                        n24 = 65536;
                    } else if (n24 < 0) {
                        n24 = 0;
                    }
                    sArray3[n12] = (short)(n24 & 0xFFFF);
                    n12 += n6;
                    ++n15;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        int[][] nArray9 = new int[this.interp_height][this.interp_width];
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray10 = nArray5[n8];
            int[] nArray11 = nArray7[n8];
            int n9 = nArray6[n8];
            int n10 = nArray8[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = 0;
                while (n15 < n3) {
                    int n16;
                    int n17 = nArray3[n15];
                    int n18 = nArray[n15];
                    int n19 = this.interp_left * n + this.interp_top * n2;
                    n19 = n18 + n14 - n19;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < this.interp_height) {
                        int n23 = n19;
                        int n24 = 0;
                        while (n24 < this.interp_width) {
                            nArray9[n21][n20++] = nArray11[n19];
                            n19 += n;
                            ++n24;
                        }
                        ++n21;
                        n20 = 0;
                        n19 = n23 + n2;
                        ++n22;
                    }
                    nArray10[n12] = n16 = this.interp.interpolate(nArray9, n17, n13);
                    n12 += n6;
                    ++n15;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        float[][] fArray5 = new float[this.interp_height][this.interp_width];
        int n8 = 0;
        while (n8 < n5) {
            float[] fArray6 = fArray3[n8];
            float[] fArray7 = fArray4[n8];
            int n9 = nArray3[n8];
            int n10 = nArray4[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                float f = fArray2[n11];
                int n13 = nArray2[n11] + n10;
                int n14 = 0;
                while (n14 < n3) {
                    float f2 = fArray[n14];
                    int n15 = nArray[n14];
                    int n16 = this.interp_left * n + this.interp_top * n2;
                    n16 = n15 + n13 - n16;
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    while (n19 < this.interp_height) {
                        int n20 = n16;
                        int n21 = 0;
                        while (n21 < this.interp_width) {
                            fArray5[n18][n17++] = fArray7[n16];
                            n16 += n;
                            ++n21;
                        }
                        ++n18;
                        n17 = 0;
                        n16 = n20 + n2;
                        ++n19;
                    }
                    float f3 = this.interp.interpolate(fArray5, f2, f);
                    if (f3 > Float.MAX_VALUE) {
                        f3 = Float.MAX_VALUE;
                    } else if (f3 < -3.4028235E38f) {
                        f3 = -3.4028235E38f;
                    }
                    fArray6[n12] = f3;
                    n12 += n6;
                    ++n14;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        double[][] dArray3 = new double[this.interp_height][this.interp_width];
        int n8 = 0;
        while (n8 < n5) {
            double[] dArray4 = dArray[n8];
            double[] dArray5 = dArray2[n8];
            int n9 = nArray3[n8];
            int n10 = nArray4[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                float f = fArray2[n11];
                int n13 = nArray2[n11] + n10;
                int n14 = 0;
                while (n14 < n3) {
                    double d;
                    float f2 = fArray[n14];
                    int n15 = nArray[n14];
                    int n16 = this.interp_left * n + this.interp_top * n2;
                    n16 = n15 + n13 - n16;
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    while (n19 < this.interp_height) {
                        int n20 = n16;
                        int n21 = 0;
                        while (n21 < this.interp_width) {
                            dArray3[n18][n17++] = dArray5[n16];
                            n16 += n;
                            ++n21;
                        }
                        ++n18;
                        n17 = 0;
                        n16 = n20 + n2;
                        ++n19;
                    }
                    dArray4[n12] = d = this.interp.interpolate(dArray3, f2, f);
                    n12 += n6;
                    ++n14;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }
}

