/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBilinearOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    Rational half = new Rational(1L, 2L);
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n2];
                nArray3 = new int[n];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n2];
                fArray = new float[n];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        long l = n8;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n7;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray[n11] = (n10 - n) * n3;
            nArray3[n11] = (int)((float)l8 / (float)l9 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < n6) {
            nArray2[n11] = (n9 - n2) * n4;
            nArray4[n11] = (int)((float)l3 / (float)l4 * (float)this.one);
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n11;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rectangle.x;
        int n8 = rectangle.y;
        long l = n8;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n7;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray[n11] = (n10 - n) * n3;
            fArray[n11] = (float)l8 / (float)l9;
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < n6) {
            nArray2[n11] = (n9 - n2) * n4;
            fArray2[n11] = (float)l3 / (float)l4;
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n11;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        rasterAccessor.getWidth();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 + n2;
                int n16 = 0;
                while (n16 < n3) {
                    int n17 = nArray3[n16];
                    int n18 = nArray[n16];
                    int n19 = n18 + n;
                    int n20 = byArray4[n18 + n14] & 0xFF;
                    int n21 = byArray4[n19 + n14] & 0xFF;
                    int n22 = byArray4[n18 + n15] & 0xFF;
                    int n23 = byArray4[n19 + n15] & 0xFF;
                    int n24 = (n21 - n20) * n17 + (n20 << this.subsampleBits);
                    int n25 = (n23 - n22) * n17 + (n22 << this.subsampleBits);
                    int n26 = (n25 - n24) * n13 + (n24 << this.subsampleBits) + this.round2 >> this.shift2;
                    byArray3[n12] = (byte)(n26 & 0xFF);
                    n12 += n6;
                    ++n16;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        rasterAccessor.getWidth();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 + n2;
                int n16 = 0;
                while (n16 < n3) {
                    int n17 = nArray3[n16];
                    int n18 = nArray[n16];
                    int n19 = n18 + n;
                    short s = sArray4[n18 + n14];
                    short s2 = sArray4[n19 + n14];
                    short s3 = sArray4[n18 + n15];
                    short s4 = sArray4[n19 + n15];
                    int n20 = (s2 - s) * n17 + (s << this.subsampleBits);
                    int n21 = (s4 - s3) * n17 + (s3 << this.subsampleBits);
                    int n22 = (n21 - n20) * n13 + (n20 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n12] = (short)n22;
                    n12 += n6;
                    ++n16;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        rasterAccessor.getWidth();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 + n2;
                int n16 = 0;
                while (n16 < n3) {
                    int n17 = nArray3[n16];
                    int n18 = nArray[n16];
                    int n19 = n18 + n;
                    int n20 = sArray4[n18 + n14] & 0xFFFF;
                    int n21 = sArray4[n19 + n14] & 0xFFFF;
                    int n22 = sArray4[n18 + n15] & 0xFFFF;
                    int n23 = sArray4[n19 + n15] & 0xFFFF;
                    int n24 = (n21 - n20) * n17 + (n20 << this.subsampleBits);
                    int n25 = (n23 - n22) * n17 + (n22 << this.subsampleBits);
                    int n26 = (n25 - n24) * n13 + (n24 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n12] = (short)(n26 & 0xFFFF);
                    n12 += n6;
                    ++n16;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        rasterAccessor.getWidth();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        int n8 = 29 - this.subsampleBits;
        int n9 = 0;
        while (n9 < n5) {
            int[] nArray9 = nArray5[n9];
            int[] nArray10 = nArray7[n9];
            int n10 = nArray6[n9];
            int n11 = nArray8[n9];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 + n2;
                int n17 = 0;
                while (n17 < n3) {
                    long l;
                    long l2;
                    int n18 = nArray3[n17];
                    int n19 = nArray[n17];
                    int n20 = n19 + n;
                    int n21 = nArray10[n19 + n15];
                    int n22 = nArray10[n20 + n15];
                    int n23 = nArray10[n19 + n16];
                    int n24 = nArray10[n20 + n16];
                    if ((n21 | n23) >>> n8 == 0) {
                        if ((n22 | n24) >>> n8 == 0) {
                            l2 = (n22 - n21) * n18 + (n21 << this.subsampleBits);
                            l = (n24 - n23) * n18 + (n23 << this.subsampleBits);
                        } else {
                            l2 = ((long)n22 - (long)n21) * (long)n18 + (long)(n21 << this.subsampleBits);
                            l = ((long)n24 - (long)n23) * (long)n18 + (long)(n23 << this.subsampleBits);
                        }
                    } else {
                        l2 = ((long)n22 - (long)n21) * (long)n18 + ((long)n21 << this.subsampleBits);
                        l = ((long)n24 - (long)n23) * (long)n18 + ((long)n23 << this.subsampleBits);
                    }
                    nArray9[n13] = (int)((l - l2) * (long)n14 + (l2 << this.subsampleBits) + (long)this.round2 >> this.shift2);
                    n13 += n6;
                    ++n17;
                }
                n10 += n7;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        rasterAccessor.getWidth();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            float[] fArray5 = fArray3[n8];
            float[] fArray6 = fArray4[n8];
            int n9 = nArray3[n8];
            int n10 = nArray4[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                float f = fArray2[n11];
                int n13 = nArray2[n11] + n10;
                int n14 = n13 + n2;
                int n15 = 0;
                while (n15 < n3) {
                    float f2 = fArray[n15];
                    int n16 = nArray[n15];
                    int n17 = n16 + n;
                    float f3 = fArray6[n16 + n13];
                    float f4 = fArray6[n17 + n13];
                    float f5 = fArray6[n16 + n14];
                    float f6 = fArray6[n17 + n14];
                    float f7 = (f4 - f3) * f2 + f3;
                    float f8 = (f6 - f5) * f2 + f5;
                    fArray5[n12] = (f8 - f7) * f + f7;
                    n12 += n6;
                    ++n15;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        rasterAccessor.getWidth();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray3[n8];
            int n10 = nArray4[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                double d = fArray2[n11];
                int n13 = nArray2[n11] + n10;
                int n14 = n13 + n2;
                int n15 = 0;
                while (n15 < n3) {
                    double d2 = fArray[n15];
                    int n16 = nArray[n15];
                    int n17 = n16 + n;
                    double d3 = dArray4[n16 + n13];
                    double d4 = dArray4[n17 + n13];
                    double d5 = dArray4[n16 + n14];
                    double d6 = dArray4[n17 + n14];
                    double d7 = (d4 - d3) * d2 + d3;
                    double d8 = (d6 - d5) * d2 + d5;
                    dArray3[n12] = (d8 - d7) * d + d7;
                    n12 += n6;
                    ++n15;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }
}

