/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.ScaleOpImage;

public final class ScaleBilinearBinaryOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleBilinearBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int cfr_ignored_0 = rectangle2.x;
        int cfr_ignored_1 = rectangle2.y;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n4];
        long l = n;
        long l2 = 1L;
        long l3 = n2;
        long l4 = 1L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l3 = l3 * this.transYRationalDenom - this.transYRationalNum * l4;
        l = 2L * l + (l2 *= this.transXRationalDenom);
        l2 *= 2L;
        l3 = 2L * l3 + (l4 *= this.transYRationalDenom);
        l4 *= 2L;
        l *= this.invScaleXRationalNum;
        l3 *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleXRationalDenom);
        l3 = 2L * l3 - (l4 *= this.invScaleYRationalDenom);
        l4 *= 2L;
        int n5 = Rational.floor(l, l2 *= 2L);
        long l5 = l % l2;
        if (n5 < 0) {
            l5 = l2 + l5;
        }
        int n6 = Rational.floor(l3, l4);
        long l6 = l3 % l4;
        if (n6 < 0) {
            l6 = l4 + l6;
        }
        long l7 = l2 * this.invScaleXRationalDenom;
        l5 *= this.invScaleXRationalDenom;
        long l8 = this.invScaleXFrac * l2;
        long l9 = l4 * this.invScaleYRationalDenom;
        l6 *= this.invScaleYRationalDenom;
        long l10 = this.invScaleYFrac * l4;
        int n7 = 0;
        while (n7 < n3) {
            nArray[n7] = n5;
            nArray3[n7] = (int)((float)l5 / (float)l7 * (float)this.one);
            n5 = (int)((long)n5 + this.invScaleXInt);
            if ((l5 += l8) >= l7) {
                ++n5;
                l5 -= l7;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n4) {
            nArray2[n7] = n6;
            nArray4[n7] = (int)((float)l6 / (float)l9 * (float)this.one);
            n6 = (int)((long)n6 + this.invScaleYInt);
            if ((l6 += l10) >= l9) {
                ++n6;
                l6 -= l9;
            }
            ++n7;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, n, n2, n3, n4, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, n, n2, n3, n4, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, n, n2, n3, n4, nArray, nArray2, nArray3, nArray4);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        writableRaster.getMinX();
        writableRaster.getMinY();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n14 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n15 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n16 = dataBufferByte2.getOffset();
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n17 = 0;
        while (n17 < n3) {
            n6 = nArray[n17];
            n5 = n9 + (n6 - n7);
            nArray5[n17] = n5 >> 3;
            nArray6[n17] = 7 - (n5 & 7);
            ++n17;
        }
        int n18 = 0;
        int n19 = 0;
        int n20 = (n2 - n12) * n14 + n16;
        int n21 = n13 + (n - n11);
        int n22 = 0;
        int n23 = 0;
        n23 = 0;
        while (n23 < n4) {
            n19 = nArray2[n23];
            int n24 = nArray4[n23];
            n17 = (n19 - n8) * n10 + n15;
            n21 = n13 + (n - n11);
            n22 = 0;
            while (n22 < n3) {
                int n25 = nArray3[n22];
                n18 = nArray[n22];
                int n26 = n9 + (n18 + 1 - n7);
                int n27 = n26 >> 3;
                int n28 = 7 - (n26 & 7);
                n6 = byArray[n17 + nArray5[n22]] >> nArray6[n22] & 1;
                n5 = byArray[n17 + n27] >> n28 & 1;
                int n29 = byArray[n17 + n10 + nArray5[n22]] >> nArray6[n22] & 1;
                int n30 = byArray[n17 + n10 + n27] >> n28 & 1;
                int n31 = (n5 - n6) * n25 + (n6 << this.subsampleBits);
                int n32 = (n30 - n29) * n25 + (n29 << this.subsampleBits);
                int n33 = (n32 - n31) * n24 + ((n31 << this.subsampleBits) + this.round2) >> this.shift2;
                int n34 = n21 >> 3;
                int n35 = 7 - (n21 & 7);
                if (n33 == 1) {
                    int n36 = n20 + n34;
                    byArray2[n36] = (byte)(byArray2[n36] | 1 << n35);
                } else {
                    int n37 = n20 + n34;
                    byArray2[n37] = (byte)(byArray2[n37] & 255 - (1 << n35));
                }
                ++n21;
                ++n22;
            }
            n20 += n14;
            ++n23;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        writableRaster.getMinX();
        writableRaster.getMinY();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n14 = multiPixelPackedSampleModel2.getScanlineStride();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n15 = dataBufferUShort.getOffset();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray2 = dataBufferUShort2.getData();
        int n16 = dataBufferUShort2.getOffset();
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n17 = 0;
        while (n17 < n3) {
            n6 = nArray[n17];
            n5 = n9 + (n6 - n7);
            nArray5[n17] = n5 >> 4;
            nArray6[n17] = 15 - (n5 & 0xF);
            ++n17;
        }
        int n18 = (n2 - n12) * n14 + n16;
        int n19 = n13 + (n - n11);
        int n20 = 0;
        while (n20 < n4) {
            int n21 = nArray2[n20];
            int n22 = nArray4[n20];
            n17 = (n21 - n8) * n10 + n15;
            n19 = n13 + (n - n11);
            int n23 = 0;
            while (n23 < n3) {
                int n24 = nArray3[n23];
                int n25 = nArray[n23];
                int n26 = n9 + (n25 + 1 - n7);
                int n27 = n26 >> 4;
                int n28 = 15 - (n26 & 0xF);
                n6 = sArray[n17 + nArray5[n23]] >> nArray6[n23] & 1;
                n5 = sArray[n17 + n27] >> n28 & 1;
                int n29 = sArray[n17 + n10 + nArray5[n23]] >> nArray6[n23] & 1;
                int n30 = sArray[n17 + n10 + n27] >> n28 & 1;
                int n31 = (n5 - n6) * n24 + (n6 << this.subsampleBits);
                int n32 = (n30 - n29) * n24 + (n29 << this.subsampleBits);
                int n33 = (n32 - n31) * n22 + (n31 << this.subsampleBits) + this.round2 >> this.shift2;
                int n34 = n19 >> 4;
                int n35 = 15 - (n19 & 0xF);
                if (n33 == 1) {
                    int n36 = n18 + n34;
                    sArray2[n36] = (short)(sArray2[n36] | 1 << n35);
                } else {
                    int n37 = n18 + n34;
                    sArray2[n37] = (short)(sArray2[n37] & 65535 - (1 << n35));
                }
                ++n19;
                ++n23;
            }
            n18 += n14;
            ++n20;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        writableRaster.getMinX();
        writableRaster.getMinY();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n14 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray5 = dataBufferInt.getData();
        int n15 = dataBufferInt.getOffset();
        int[] nArray6 = dataBufferInt2.getData();
        int n16 = dataBufferInt2.getOffset();
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        int n17 = 0;
        while (n17 < n3) {
            n6 = nArray[n17];
            n5 = n9 + (n6 - n7);
            nArray7[n17] = n5 >> 5;
            nArray8[n17] = 31 - (n5 & 0x1F);
            ++n17;
        }
        int n18 = (n2 - n12) * n14 + n16;
        int n19 = n13 + (n - n11);
        int n20 = 0;
        while (n20 < n4) {
            int n21 = nArray2[n20];
            int n22 = nArray4[n20];
            n17 = (n21 - n8) * n10 + n15;
            n19 = n13 + (n - n11);
            int n23 = 0;
            while (n23 < n3) {
                int n24 = nArray3[n23];
                int n25 = nArray[n23];
                int n26 = n9 + (n25 + 1 - n7);
                int n27 = n26 >> 5;
                int n28 = 31 - (n26 & 0x1F);
                n6 = nArray5[n17 + nArray7[n23]] >> nArray8[n23] & 1;
                n5 = nArray5[n17 + n27] >> n28 & 1;
                int n29 = nArray5[n17 + n10 + nArray7[n23]] >> nArray8[n23] & 1;
                int n30 = nArray5[n17 + n10 + n27] >> n28 & 1;
                int n31 = (n5 - n6) * n24 + (n6 << this.subsampleBits);
                int n32 = (n30 - n29) * n24 + (n29 << this.subsampleBits);
                int n33 = (n32 - n31) * n22 + (n31 << this.subsampleBits) + this.round2 >> this.shift2;
                int n34 = n19 >> 5;
                int n35 = 31 - (n19 & 0x1F);
                if (n33 == 1) {
                    int n36 = n18 + n34;
                    nArray6[n36] = nArray6[n36] | 1 << n35;
                } else {
                    int n37 = n18 + n34;
                    nArray6[n37] = nArray6[n37] & 255 - (1 << n35);
                }
                ++n19;
                ++n23;
            }
            n18 += n14;
            ++n20;
        }
    }
}

