/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBicubicOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    private int[] tableDataHi = null;
    private int[] tableDataVi = null;
    private float[] tableDataHf = null;
    private float[] tableDataVf = null;
    private double[] tableDataHd = null;
    private double[] tableDataVd = null;
    private int precisionBits;
    private int round;
    private Rational half = new Rational(1L, 2L);
    InterpolationTable interpTable;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBicubicOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.interpTable = (InterpolationTable)interpolation;
        this.one = 1 << this.subsampleBits;
        this.precisionBits = this.interpTable.getPrecisionBits();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n5];
        long l = n4;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n9 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n3;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n10 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        int n11 = 0;
        while (n11 < n5) {
            nArray2[n11] = (n10 - n) * n7;
            nArray4[n11] = (int)((float)l8 / (float)l9 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l8 += l10) >= l9) {
                ++n10;
                l8 -= l9;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < n6) {
            nArray[n11] = (n9 - n2) * n8;
            nArray3[n11] = (int)((float)l3 / (float)l4 * (float)this.one);
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l3 += l5) >= l4) {
                ++n9;
                l3 -= l4;
            }
            ++n11;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.initTableDataI();
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 2: {
                this.initTableDataI();
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 1: {
                this.initTableDataI();
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 3: {
                this.initTableDataI();
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 4: {
                this.initTableDataF();
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 5: {
                this.initTableDataD();
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 - n2;
                int n16 = n14 + n2;
                int n17 = n16 + n2;
                int n18 = 0;
                while (n18 < n3) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 - n;
                    int n22 = n20 + n;
                    int n23 = n22 + n;
                    int n24 = byArray4[n21 + n15] & 0xFF;
                    int n25 = byArray4[n20 + n15] & 0xFF;
                    int n26 = byArray4[n22 + n15] & 0xFF;
                    int n27 = byArray4[n23 + n15] & 0xFF;
                    int n28 = byArray4[n21 + n14] & 0xFF;
                    int n29 = byArray4[n20 + n14] & 0xFF;
                    int n30 = byArray4[n22 + n14] & 0xFF;
                    int n31 = byArray4[n23 + n14] & 0xFF;
                    int n32 = byArray4[n21 + n16] & 0xFF;
                    int n33 = byArray4[n20 + n16] & 0xFF;
                    int n34 = byArray4[n22 + n16] & 0xFF;
                    int n35 = byArray4[n23 + n16] & 0xFF;
                    int n36 = byArray4[n21 + n17] & 0xFF;
                    int n37 = byArray4[n20 + n17] & 0xFF;
                    int n38 = byArray4[n22 + n17] & 0xFF;
                    int n39 = byArray4[n23 + n17] & 0xFF;
                    int n40 = 4 * n19;
                    int n41 = n40 + 1;
                    int n42 = n40 + 2;
                    int n43 = n40 + 3;
                    long l = (long)this.tableDataHi[n40] * (long)n24;
                    l += (long)this.tableDataHi[n41] * (long)n25;
                    l += (long)this.tableDataHi[n42] * (long)n26;
                    l += (long)this.tableDataHi[n43] * (long)n27;
                    long l2 = (long)this.tableDataHi[n40] * (long)n28;
                    l2 += (long)this.tableDataHi[n41] * (long)n29;
                    l2 += (long)this.tableDataHi[n42] * (long)n30;
                    l2 += (long)this.tableDataHi[n43] * (long)n31;
                    long l3 = (long)this.tableDataHi[n40] * (long)n32;
                    l3 += (long)this.tableDataHi[n41] * (long)n33;
                    l3 += (long)this.tableDataHi[n42] * (long)n34;
                    l3 += (long)this.tableDataHi[n43] * (long)n35;
                    long l4 = (long)this.tableDataHi[n40] * (long)n36;
                    l4 += (long)this.tableDataHi[n41] * (long)n37;
                    l4 += (long)this.tableDataHi[n42] * (long)n38;
                    l4 += (long)this.tableDataHi[n43] * (long)n39;
                    l = l + (long)this.round >> this.precisionBits;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    int n44 = 4 * n13;
                    long l5 = (long)this.tableDataVi[n44] * l;
                    l5 += (long)this.tableDataVi[n44 + 1] * l2;
                    l5 += (long)this.tableDataVi[n44 + 2] * l3;
                    int n45 = (int)((l5 += (long)this.tableDataVi[n44 + 3] * l4) + (long)this.round >> this.precisionBits);
                    if (n45 > 255) {
                        n45 = 255;
                    } else if (n45 < 0) {
                        n45 = 0;
                    }
                    byArray3[n12] = (byte)(n45 & 0xFF);
                    n12 += n6;
                    ++n18;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 - n2;
                int n16 = n14 + n2;
                int n17 = n16 + n2;
                int n18 = 0;
                while (n18 < n3) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 - n;
                    int n22 = n20 + n;
                    int n23 = n22 + n;
                    short s = sArray4[n21 + n15];
                    short s2 = sArray4[n20 + n15];
                    short s3 = sArray4[n22 + n15];
                    short s4 = sArray4[n23 + n15];
                    short s5 = sArray4[n21 + n14];
                    short s6 = sArray4[n20 + n14];
                    short s7 = sArray4[n22 + n14];
                    short s8 = sArray4[n23 + n14];
                    short s9 = sArray4[n21 + n16];
                    short s10 = sArray4[n20 + n16];
                    short s11 = sArray4[n22 + n16];
                    short s12 = sArray4[n23 + n16];
                    short s13 = sArray4[n21 + n17];
                    short s14 = sArray4[n20 + n17];
                    short s15 = sArray4[n22 + n17];
                    short s16 = sArray4[n23 + n17];
                    int n24 = 4 * n19;
                    int n25 = n24 + 1;
                    int n26 = n24 + 2;
                    int n27 = n24 + 3;
                    long l = (long)this.tableDataHi[n24] * (long)s;
                    l += (long)this.tableDataHi[n25] * (long)s2;
                    l += (long)this.tableDataHi[n26] * (long)s3;
                    l += (long)this.tableDataHi[n27] * (long)s4;
                    long l2 = (long)this.tableDataHi[n24] * (long)s5;
                    l2 += (long)this.tableDataHi[n25] * (long)s6;
                    l2 += (long)this.tableDataHi[n26] * (long)s7;
                    l2 += (long)this.tableDataHi[n27] * (long)s8;
                    long l3 = (long)this.tableDataHi[n24] * (long)s9;
                    l3 += (long)this.tableDataHi[n25] * (long)s10;
                    l3 += (long)this.tableDataHi[n26] * (long)s11;
                    l3 += (long)this.tableDataHi[n27] * (long)s12;
                    long l4 = (long)this.tableDataHi[n24] * (long)s13;
                    l4 += (long)this.tableDataHi[n25] * (long)s14;
                    l4 += (long)this.tableDataHi[n26] * (long)s15;
                    l4 += (long)this.tableDataHi[n27] * (long)s16;
                    l = l + (long)this.round >> this.precisionBits;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    int n28 = 4 * n13;
                    long l5 = (long)this.tableDataVi[n28] * l;
                    l5 += (long)this.tableDataVi[n28 + 1] * l2;
                    l5 += (long)this.tableDataVi[n28 + 2] * l3;
                    int n29 = (int)((l5 += (long)this.tableDataVi[n28 + 3] * l4) + (long)this.round >> this.precisionBits);
                    if (n29 > Short.MAX_VALUE) {
                        n29 = Short.MAX_VALUE;
                    } else if (n29 < Short.MIN_VALUE) {
                        n29 = Short.MIN_VALUE;
                    }
                    sArray3[n12] = (short)n29;
                    n12 += n6;
                    ++n18;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 - n2;
                int n16 = n14 + n2;
                int n17 = n16 + n2;
                int n18 = 0;
                while (n18 < n3) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 - n;
                    int n22 = n20 + n;
                    int n23 = n22 + n;
                    int n24 = sArray4[n21 + n15] & 0xFFFF;
                    int n25 = sArray4[n20 + n15] & 0xFFFF;
                    int n26 = sArray4[n22 + n15] & 0xFFFF;
                    int n27 = sArray4[n23 + n15] & 0xFFFF;
                    int n28 = sArray4[n21 + n14] & 0xFFFF;
                    int n29 = sArray4[n20 + n14] & 0xFFFF;
                    int n30 = sArray4[n22 + n14] & 0xFFFF;
                    int n31 = sArray4[n23 + n14] & 0xFFFF;
                    int n32 = sArray4[n21 + n16] & 0xFFFF;
                    int n33 = sArray4[n20 + n16] & 0xFFFF;
                    int n34 = sArray4[n22 + n16] & 0xFFFF;
                    int n35 = sArray4[n23 + n16] & 0xFFFF;
                    int n36 = sArray4[n21 + n17] & 0xFFFF;
                    int n37 = sArray4[n20 + n17] & 0xFFFF;
                    int n38 = sArray4[n22 + n17] & 0xFFFF;
                    int n39 = sArray4[n23 + n17] & 0xFFFF;
                    int n40 = 4 * n19;
                    int n41 = n40 + 1;
                    int n42 = n40 + 2;
                    int n43 = n40 + 3;
                    long l = (long)this.tableDataHi[n40] * (long)n24;
                    l += (long)this.tableDataHi[n41] * (long)n25;
                    l += (long)this.tableDataHi[n42] * (long)n26;
                    l += (long)this.tableDataHi[n43] * (long)n27;
                    long l2 = (long)this.tableDataHi[n40] * (long)n28;
                    l2 += (long)this.tableDataHi[n41] * (long)n29;
                    l2 += (long)this.tableDataHi[n42] * (long)n30;
                    l2 += (long)this.tableDataHi[n43] * (long)n31;
                    long l3 = (long)this.tableDataHi[n40] * (long)n32;
                    l3 += (long)this.tableDataHi[n41] * (long)n33;
                    l3 += (long)this.tableDataHi[n42] * (long)n34;
                    l3 += (long)this.tableDataHi[n43] * (long)n35;
                    long l4 = (long)this.tableDataHi[n40] * (long)n36;
                    l4 += (long)this.tableDataHi[n41] * (long)n37;
                    l4 += (long)this.tableDataHi[n42] * (long)n38;
                    l4 += (long)this.tableDataHi[n43] * (long)n39;
                    l = l + (long)this.round >> this.precisionBits;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    int n44 = 4 * n13;
                    long l5 = (long)this.tableDataVi[n44] * l;
                    l5 += (long)this.tableDataVi[n44 + 1] * l2;
                    l5 += (long)this.tableDataVi[n44 + 2] * l3;
                    int n45 = (int)((l5 += (long)this.tableDataVi[n44 + 3] * l4) + (long)this.round >> this.precisionBits);
                    if (n45 > 65536) {
                        n45 = 65536;
                    } else if (n45 < 0) {
                        n45 = 0;
                    }
                    sArray3[n12] = (short)(n45 & 0xFFFF);
                    n12 += n6;
                    ++n18;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray9 = nArray5[n8];
            int[] nArray10 = nArray7[n8];
            int n9 = nArray6[n8];
            int n10 = nArray8[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                long l = nArray4[n11];
                int n13 = nArray2[n11] + n10;
                int n14 = n13 - n2;
                int n15 = n13 + n2;
                int n16 = n15 + n2;
                int n17 = 0;
                while (n17 < n3) {
                    int n18;
                    long l2 = nArray3[n17];
                    int n19 = nArray[n17];
                    int n20 = n19 - n;
                    int n21 = n19 + n;
                    int n22 = n21 + n;
                    int n23 = nArray10[n20 + n14];
                    int n24 = nArray10[n19 + n14];
                    int n25 = nArray10[n21 + n14];
                    int n26 = nArray10[n22 + n14];
                    int n27 = nArray10[n20 + n13];
                    int n28 = nArray10[n19 + n13];
                    int n29 = nArray10[n21 + n13];
                    int n30 = nArray10[n22 + n13];
                    int n31 = nArray10[n20 + n15];
                    int n32 = nArray10[n19 + n15];
                    int n33 = nArray10[n21 + n15];
                    int n34 = nArray10[n22 + n15];
                    int n35 = nArray10[n20 + n16];
                    int n36 = nArray10[n19 + n16];
                    int n37 = nArray10[n21 + n16];
                    int n38 = nArray10[n22 + n16];
                    int n39 = (int)(4L * l2);
                    int n40 = n39 + 1;
                    int n41 = n39 + 2;
                    int n42 = n39 + 3;
                    long l3 = (long)this.tableDataHi[n39] * (long)n23;
                    l3 += (long)this.tableDataHi[n40] * (long)n24;
                    l3 += (long)this.tableDataHi[n41] * (long)n25;
                    l3 += (long)this.tableDataHi[n42] * (long)n26;
                    long l4 = (long)this.tableDataHi[n39] * (long)n27;
                    l4 += (long)this.tableDataHi[n40] * (long)n28;
                    l4 += (long)this.tableDataHi[n41] * (long)n29;
                    l4 += (long)this.tableDataHi[n42] * (long)n30;
                    long l5 = (long)this.tableDataHi[n39] * (long)n31;
                    l5 += (long)this.tableDataHi[n40] * (long)n32;
                    l5 += (long)this.tableDataHi[n41] * (long)n33;
                    l5 += (long)this.tableDataHi[n42] * (long)n34;
                    long l6 = (long)this.tableDataHi[n39] * (long)n35;
                    l6 += (long)this.tableDataHi[n40] * (long)n36;
                    l6 += (long)this.tableDataHi[n41] * (long)n37;
                    l6 += (long)this.tableDataHi[n42] * (long)n38;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    l6 = l6 + (long)this.round >> this.precisionBits;
                    int n43 = (int)(4L * l);
                    long l7 = (long)this.tableDataVi[n43] * l3;
                    l7 += (long)this.tableDataVi[n43 + 1] * l4;
                    l7 += (long)this.tableDataVi[n43 + 2] * l5;
                    nArray9[n12] = n18 = (int)((l7 += (long)this.tableDataVi[n43 + 3] * l6) + (long)this.round >> this.precisionBits);
                    n12 += n6;
                    ++n17;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 - n2;
                int n16 = n14 + n2;
                int n17 = n16 + n2;
                int n18 = 0;
                while (n18 < n3) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 - n;
                    int n22 = n20 + n;
                    int n23 = n22 + n;
                    float f = fArray4[n21 + n15];
                    float f2 = fArray4[n20 + n15];
                    float f3 = fArray4[n22 + n15];
                    float f4 = fArray4[n23 + n15];
                    float f5 = fArray4[n21 + n14];
                    float f6 = fArray4[n20 + n14];
                    float f7 = fArray4[n22 + n14];
                    float f8 = fArray4[n23 + n14];
                    float f9 = fArray4[n21 + n16];
                    float f10 = fArray4[n20 + n16];
                    float f11 = fArray4[n22 + n16];
                    float f12 = fArray4[n23 + n16];
                    float f13 = fArray4[n21 + n17];
                    float f14 = fArray4[n20 + n17];
                    float f15 = fArray4[n22 + n17];
                    float f16 = fArray4[n23 + n17];
                    int n24 = 4 * n19;
                    int n25 = n24 + 1;
                    int n26 = n24 + 2;
                    int n27 = n24 + 3;
                    double d = this.tableDataHf[n24] * f;
                    d += (double)(this.tableDataHf[n25] * f2);
                    d += (double)(this.tableDataHf[n26] * f3);
                    d += (double)(this.tableDataHf[n27] * f4);
                    double d2 = this.tableDataHf[n24] * f5;
                    d2 += (double)(this.tableDataHf[n25] * f6);
                    d2 += (double)(this.tableDataHf[n26] * f7);
                    d2 += (double)(this.tableDataHf[n27] * f8);
                    double d3 = this.tableDataHf[n24] * f9;
                    d3 += (double)(this.tableDataHf[n25] * f10);
                    d3 += (double)(this.tableDataHf[n26] * f11);
                    d3 += (double)(this.tableDataHf[n27] * f12);
                    double d4 = this.tableDataHf[n24] * f13;
                    d4 += (double)(this.tableDataHf[n25] * f14);
                    d4 += (double)(this.tableDataHf[n26] * f15);
                    d4 += (double)(this.tableDataHf[n27] * f16);
                    int n28 = 4 * n13;
                    double d5 = (double)this.tableDataVf[n28] * d;
                    d5 += (double)this.tableDataVf[n28 + 1] * d2;
                    d5 += (double)this.tableDataVf[n28 + 2] * d3;
                    if ((d5 += (double)this.tableDataVf[n28 + 3] * d4) > 3.4028234663852886E38) {
                        d5 = 3.4028234663852886E38;
                    } else if (d5 < -3.4028234663852886E38) {
                        d5 = -3.4028234663852886E38;
                    }
                    fArray3[n12] = (float)d5;
                    n12 += n6;
                    ++n18;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < n5) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray5[n8];
            int n10 = nArray6[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = nArray4[n11];
                int n14 = nArray2[n11] + n10;
                int n15 = n14 - n2;
                int n16 = n14 + n2;
                int n17 = n16 + n2;
                int n18 = 0;
                while (n18 < n3) {
                    int n19 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 - n;
                    int n22 = n20 + n;
                    int n23 = n22 + n;
                    double d = dArray4[n21 + n15];
                    double d2 = dArray4[n20 + n15];
                    double d3 = dArray4[n22 + n15];
                    double d4 = dArray4[n23 + n15];
                    double d5 = dArray4[n21 + n14];
                    double d6 = dArray4[n20 + n14];
                    double d7 = dArray4[n22 + n14];
                    double d8 = dArray4[n23 + n14];
                    double d9 = dArray4[n21 + n16];
                    double d10 = dArray4[n20 + n16];
                    double d11 = dArray4[n22 + n16];
                    double d12 = dArray4[n23 + n16];
                    double d13 = dArray4[n21 + n17];
                    double d14 = dArray4[n20 + n17];
                    double d15 = dArray4[n22 + n17];
                    double d16 = dArray4[n23 + n17];
                    int n24 = 4 * n19;
                    int n25 = n24 + 1;
                    int n26 = n24 + 2;
                    int n27 = n24 + 3;
                    double d17 = this.tableDataHd[n24] * d;
                    d17 += this.tableDataHd[n25] * d2;
                    d17 += this.tableDataHd[n26] * d3;
                    d17 += this.tableDataHd[n27] * d4;
                    double d18 = this.tableDataHd[n24] * d5;
                    d18 += this.tableDataHd[n25] * d6;
                    d18 += this.tableDataHd[n26] * d7;
                    d18 += this.tableDataHd[n27] * d8;
                    double d19 = this.tableDataHd[n24] * d9;
                    d19 += this.tableDataHd[n25] * d10;
                    d19 += this.tableDataHd[n26] * d11;
                    d19 += this.tableDataHd[n27] * d12;
                    double d20 = this.tableDataHd[n24] * d13;
                    d20 += this.tableDataHd[n25] * d14;
                    d20 += this.tableDataHd[n26] * d15;
                    int n28 = 4 * n13;
                    double d21 = this.tableDataVd[n28] * d17;
                    d21 += this.tableDataVd[n28 + 1] * d18;
                    d21 += this.tableDataVd[n28 + 2] * d19;
                    dArray3[n12] = d21 += this.tableDataVd[n28 + 3] * (d20 += this.tableDataHd[n27] * d16);
                    n12 += n6;
                    ++n18;
                }
                n9 += n7;
                ++n11;
            }
            ++n8;
        }
    }

    private synchronized void initTableDataI() {
        if (this.tableDataHi == null || this.tableDataVi == null) {
            this.tableDataHi = this.interpTable.getHorizontalTableData();
            this.tableDataVi = this.interpTable.getVerticalTableData();
        }
    }

    private synchronized void initTableDataF() {
        if (this.tableDataHf == null || this.tableDataVf == null) {
            this.tableDataHf = this.interpTable.getHorizontalTableDataFloat();
            this.tableDataVf = this.interpTable.getVerticalTableDataFloat();
        }
    }

    private synchronized void initTableDataD() {
        if (this.tableDataHd == null || this.tableDataVd == null) {
            this.tableDataHd = this.interpTable.getHorizontalTableDataDouble();
            this.tableDataVd = this.interpTable.getVerticalTableDataDouble();
        }
    }
}

