/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageMIPMap;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.RenderedOp;

public class RenderableCRIF
extends CRIFImpl {
    private Hashtable mresTable = null;

    private static final Object getKey(ParameterBlock parameterBlock) {
        String string = new String();
        string = String.valueOf(string) + String.valueOf(parameterBlock.getRenderedSource(0).hashCode());
        string = String.valueOf(string) + RenderableCRIF.getKey((RenderedOp)parameterBlock.getObjectParameter(0));
        string = String.valueOf(string) + String.valueOf(parameterBlock.getIntParameter(1));
        string = String.valueOf(string) + String.valueOf(parameterBlock.getFloatParameter(2));
        string = String.valueOf(string) + String.valueOf(parameterBlock.getFloatParameter(3));
        string = String.valueOf(string) + String.valueOf(parameterBlock.getFloatParameter(4));
        return string;
    }

    private static final String getKey(RenderedOp renderedOp) {
        String string = new String(String.valueOf(renderedOp.hashCode()));
        ParameterBlock parameterBlock = renderedOp.getParameterBlock();
        int n = parameterBlock.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            RenderedImage renderedImage = parameterBlock.getRenderedSource(n2);
            string = renderedImage instanceof RenderedOp ? String.valueOf(string) + RenderableCRIF.getKey((RenderedOp)renderedImage) : String.valueOf(string) + String.valueOf(renderedImage.hashCode());
            ++n2;
        }
        n2 = parameterBlock.getNumParameters();
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + parameterBlock.getObjectParameter(n3).toString();
            ++n3;
        }
        return string;
    }

    private RenderableImage createRenderable(ParameterBlock parameterBlock) {
        if (this.mresTable == null) {
            this.mresTable = new Hashtable();
        }
        Object object = RenderableCRIF.getKey(parameterBlock);
        SoftReference softReference = (SoftReference)this.mresTable.get(object);
        RenderableImage renderableImage = null;
        if (softReference != null && (renderableImage = (RenderableImage)softReference.get()) == null) {
            this.mresTable.remove(object);
        }
        if (renderableImage == null) {
            RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
            RenderedOp renderedOp = (RenderedOp)parameterBlock.getObjectParameter(0);
            int n = parameterBlock.getIntParameter(1);
            float f = parameterBlock.getFloatParameter(2);
            float f2 = parameterBlock.getFloatParameter(3);
            float f3 = parameterBlock.getFloatParameter(4);
            ImageMIPMap imageMIPMap = new ImageMIPMap(renderedImage, renderedOp);
            Vector<RenderedImage> vector = new Vector<RenderedImage>();
            RenderedImage renderedImage2 = imageMIPMap.getCurrentImage();
            vector.add(renderedImage2);
            while (renderedImage2.getWidth() > n || renderedImage2.getHeight() > n) {
                RenderedImage renderedImage3 = imageMIPMap.getDownImage();
                if (renderedImage3.getWidth() >= renderedImage2.getWidth() || renderedImage3.getHeight() >= renderedImage2.getHeight()) {
                    throw new IllegalArgumentException(JaiI18N.getString("RenderableCRIF0"));
                }
                vector.add(renderedImage3);
                renderedImage2 = renderedImage3;
            }
            renderableImage = new MultiResolutionRenderableImage(vector, f, f2, f3);
            this.mresTable.put(object, new SoftReference<RenderableImage>(renderableImage));
        }
        return renderableImage;
    }

    @Override
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return parameterBlock.getRenderedSource(0);
    }

    @Override
    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        RenderableImage renderableImage = this.createRenderable(parameterBlock);
        return renderableImage.createRendering(renderContext);
    }

    @Override
    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        RenderableImage renderableImage = this.createRenderable(parameterBlock);
        return new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
    }
}

