/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;

public class PointMapperOpImage
extends NullOpImage {
    private AffineTransform transform;
    private AffineTransform inverseTransform;

    public PointMapperOpImage(PlanarImage planarImage, Map map, AffineTransform affineTransform) throws NoninvertibleTransformException {
        super((RenderedImage)planarImage, null, map, 1);
        if (affineTransform == null) {
            throw new IllegalArgumentException("transform == null!");
        }
        this.transform = affineTransform;
        this.inverseTransform = affineTransform.createInverse();
    }

    @Override
    public Point2D mapDestPoint(Point2D point2D, int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("sourceIndex != 0!");
        }
        return this.inverseTransform.transform(point2D, null);
    }

    @Override
    public Point2D mapSourcePoint(Point2D point2D, int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("sourceIndex != 0!");
        }
        return this.inverseTransform.transform(point2D, null);
    }

    @Override
    public synchronized void dispose() {
        this.getSourceImage(0).dispose();
        super.dispose();
    }
}

