/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage
extends OpImage {
    private static final int WEIGHT_TYPE_ALPHA = 1;
    private static final int WEIGHT_TYPE_ROI = 2;
    private static final int WEIGHT_TYPE_THRESHOLD = 3;
    protected MosaicType mosaicType;
    protected PlanarImage[] sourceAlpha;
    protected ROI[] sourceROI;
    protected double[][] sourceThreshold;
    protected double[] backgroundValues;
    protected int numBands = this.sampleModel.getNumBands();
    protected int[] background;
    protected int[][] threshold;
    protected boolean isAlphaBitmask = false;
    private BorderExtender sourceExtender;
    private BorderExtender zeroExtender;
    private PlanarImage[] roiImage;

    private static final ImageLayout getLayout(Vector vector, ImageLayout imageLayout) {
        SampleModel sampleModel;
        Object object;
        RenderedImage renderedImage = null;
        SampleModel sampleModel2 = null;
        int n = vector.size();
        if (n > 0) {
            renderedImage = (RenderedImage)vector.get(0);
            sampleModel2 = renderedImage.getSampleModel();
            renderedImage.getColorModel();
        } else if (imageLayout != null && imageLayout.isValid(268)) {
            sampleModel2 = imageLayout.getSampleModel(null);
            if (sampleModel2 == null) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage7"));
            }
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage8"));
        }
        int n2 = sampleModel2.getDataType();
        int n3 = sampleModel2.getNumBands();
        int n4 = sampleModel2.getSampleSize(0);
        int n5 = 1;
        while (n5 < n3) {
            if (sampleModel2.getSampleSize(n5) != n4) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
            }
            ++n5;
        }
        if (n < 1) {
            return (ImageLayout)imageLayout.clone();
        }
        n5 = 1;
        while (n5 < n) {
            object = (RenderedImage)vector.get(n5);
            sampleModel = object.getSampleModel();
            if (sampleModel.getDataType() != n2) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage2"));
            }
            if (sampleModel.getNumBands() != n3) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage3"));
            }
            int n6 = 0;
            while (n6 < n3) {
                if (sampleModel.getSampleSize(n6) != n4) {
                    throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
                }
                ++n6;
            }
            ++n5;
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        object = new Rectangle();
        if (imageLayout2.isValid(15)) {
            ((Rectangle)object).setBounds(imageLayout2.getMinX(null), imageLayout2.getMinY(null), imageLayout2.getWidth(null), imageLayout2.getHeight(null));
        } else if (n > 0) {
            ((Rectangle)object).setBounds(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            int n7 = 1;
            while (n7 < n) {
                RenderedImage renderedImage2 = (RenderedImage)vector.get(n7);
                Rectangle rectangle = new Rectangle(renderedImage2.getMinX(), renderedImage2.getMinY(), renderedImage2.getWidth(), renderedImage2.getHeight());
                object = ((Rectangle)object).union(rectangle);
                ++n7;
            }
        }
        imageLayout2.setMinX(((Rectangle)object).x);
        imageLayout2.setMinY(((Rectangle)object).y);
        imageLayout2.setWidth(((Rectangle)object).width);
        imageLayout2.setHeight(((Rectangle)object).height);
        if (imageLayout2.isValid(256)) {
            sampleModel = imageLayout2.getSampleModel(null);
            boolean bl = sampleModel.getNumBands() != n3 || sampleModel.getDataType() != n2;
            int n8 = 0;
            while (!bl && n8 < n3) {
                if (sampleModel.getSampleSize(n8) != n4) {
                    bl = true;
                }
                ++n8;
            }
            if (bl) {
                imageLayout2.unsetValid(256);
            }
        }
        return imageLayout2;
    }

    public MosaicOpImage(Vector vector, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] object, double[] dArray) {
        super(vector, MosaicOpImage.getLayout(vector, imageLayout), map, true);
        double d;
        int n;
        int n2 = this.getNumSources();
        this.mosaicType = mosaicType;
        this.sourceAlpha = null;
        if (planarImageArray != null) {
            n = 0;
            while (n < planarImageArray.length) {
                if (planarImageArray[n] != null) {
                    SampleModel sampleModel = planarImageArray[n].getSampleModel();
                    if (sampleModel.getNumBands() != 1) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                    if (sampleModel.getDataType() != this.sampleModel.getDataType()) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage5"));
                    }
                    if (sampleModel.getSampleSize(0) != this.sampleModel.getSampleSize(0)) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage6"));
                    }
                }
                ++n;
            }
            this.sourceAlpha = new PlanarImage[n2];
            System.arraycopy(planarImageArray, 0, this.sourceAlpha, 0, Math.min(planarImageArray.length, n2));
        }
        this.sourceROI = null;
        if (rOIArray != null) {
            this.sourceROI = new ROI[n2];
            System.arraycopy(rOIArray, 0, this.sourceROI, 0, Math.min(rOIArray.length, n2));
        }
        boolean bl = this.isAlphaBitmask = mosaicType != MosaicDescriptor.MOSAIC_TYPE_BLEND || planarImageArray == null || planarImageArray.length < n2;
        if (!this.isAlphaBitmask) {
            n = 0;
            while (n < n2) {
                if (planarImageArray[n] == null) {
                    this.isAlphaBitmask = true;
                    break;
                }
                ++n;
            }
        }
        this.sourceThreshold = new double[n2][this.numBands];
        if (object == null) {
            object = new double[][]{{1.0}};
        }
        n = 0;
        while (n < n2) {
            if (n < ((double[][])object).length && object[n] != null) {
                if (object[n].length < this.numBands) {
                    Arrays.fill(this.sourceThreshold[n], object[n][0]);
                } else {
                    System.arraycopy(object[n], 0, this.sourceThreshold[n], 0, this.numBands);
                }
            } else {
                this.sourceThreshold[n] = this.sourceThreshold[0];
            }
            ++n;
        }
        this.threshold = new int[n2][this.numBands];
        n = 0;
        while (n < n2) {
            int n3 = 0;
            while (n3 < this.numBands) {
                this.threshold[n][n3] = (int)this.sourceThreshold[n][n3];
                ++n3;
            }
            ++n;
        }
        this.backgroundValues = new double[this.numBands];
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        if (dArray.length < this.numBands) {
            Arrays.fill(this.backgroundValues, dArray[0]);
        } else {
            System.arraycopy(dArray, 0, this.backgroundValues, 0, this.numBands);
        }
        this.background = new int[this.backgroundValues.length];
        n = this.sampleModel.getDataType();
        int n4 = 0;
        while (n4 < this.background.length) {
            switch (n) {
                case 0: {
                    this.background[n4] = ImageUtil.clampRoundByte(this.backgroundValues[n4]);
                    break;
                }
                case 1: {
                    this.background[n4] = ImageUtil.clampRoundUShort(this.backgroundValues[n4]);
                    break;
                }
                case 2: {
                    this.background[n4] = ImageUtil.clampRoundShort(this.backgroundValues[n4]);
                    break;
                }
                case 3: {
                    this.background[n4] = ImageUtil.clampRoundInt(this.backgroundValues[n4]);
                }
            }
            ++n4;
        }
        switch (n) {
            case 0: {
                d = 0.0;
                break;
            }
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = -32768.0;
                break;
            }
            case 3: {
                d = -2.147483648E9;
                break;
            }
            case 4: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = -1.7976931348623157E308;
            }
        }
        BorderExtender borderExtender = this.sourceExtender = d == 0.0 ? BorderExtender.createInstance(0) : new BorderExtenderConstant(new double[]{d});
        if (planarImageArray != null || rOIArray != null) {
            this.zeroExtender = BorderExtender.createInstance(0);
        }
        if (rOIArray != null) {
            this.roiImage = new PlanarImage[n2];
            int n5 = 0;
            while (n5 < rOIArray.length) {
                if (rOIArray[n5] != null) {
                    this.roiImage[n5] = rOIArray[n5].getAsImage();
                }
                ++n5;
            }
        }
    }

    @Override
    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getSourceImage(n).getBounds());
    }

    @Override
    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getBounds());
    }

    @Override
    public Raster computeTile(int n, int n2) {
        Object object;
        Object object2;
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
        Rectangle rectangle = this.getTileRect(n, n2);
        int n3 = this.getNumSources();
        Raster[] rasterArray = new Raster[n3];
        Raster[] rasterArray2 = this.sourceAlpha != null ? new Raster[n3] : null;
        Raster[] rasterArray3 = this.sourceROI != null ? new Raster[n3] : null;
        int n4 = 0;
        while (n4 < n3) {
            object2 = this.getSourceImage(n4);
            object = this.mapDestRect(rectangle, n4);
            Raster raster = rasterArray[n4] = object != null && ((Rectangle)object).isEmpty() ? null : ((PlanarImage)object2).getExtendedData(rectangle, this.sourceExtender);
            if (rasterArray[n4] != null) {
                if (this.sourceAlpha != null && this.sourceAlpha[n4] != null) {
                    rasterArray2[n4] = this.sourceAlpha[n4].getExtendedData(rectangle, this.zeroExtender);
                }
                if (this.sourceROI != null && this.sourceROI[n4] != null) {
                    rasterArray3[n4] = this.roiImage[n4].getExtendedData(rectangle, this.zeroExtender);
                }
            }
            ++n4;
        }
        this.computeRect(rasterArray, writableRaster, rectangle, rasterArray2, rasterArray3);
        n4 = 0;
        while (n4 < n3) {
            object2 = rasterArray[n4];
            if (object2 != null && ((PlanarImage)(object = this.getSourceImage(n4))).overlapsMultipleTiles(((Raster)object2).getBounds())) {
                this.recycleTile((Raster)object2);
            }
            ++n4;
        }
        return writableRaster;
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.computeRect(rasterArray, writableRaster, rectangle, null, null);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        RasterAccessor[] rasterAccessorArray;
        int n = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n);
        int n2 = 0;
        while (n2 < n) {
            if (rasterArray[n2] != null) {
                arrayList.add(rasterArray[n2]);
            }
            ++n2;
        }
        n2 = arrayList.size();
        if (n2 == 0) {
            ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            return;
        }
        SampleModel[] sampleModelArray = new SampleModel[n2];
        int n3 = 0;
        while (n3 < n2) {
            sampleModelArray[n3] = ((Raster)arrayList.get(n3)).getSampleModel();
            ++n3;
        }
        n3 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterAccessor[] rasterAccessorArray2 = new RasterAccessor[n];
        int n4 = 0;
        while (n4 < n) {
            if (rasterArray[n4] != null) {
                rasterAccessorArray = new RasterFormatTag(rasterArray[n4].getSampleModel(), n3);
                rasterAccessorArray2[n4] = new RasterAccessor(rasterArray[n4], rectangle, (RasterFormatTag)rasterAccessorArray, null);
            }
            ++n4;
        }
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, new RasterFormatTag(writableRaster.getSampleModel(), n3), null);
        rasterAccessorArray = new RasterAccessor[n];
        if (rasterArray2 != null) {
            int n5 = 0;
            while (n5 < n) {
                if (rasterArray2[n5] != null) {
                    SampleModel sampleModel = rasterArray2[n5].getSampleModel();
                    int n6 = RasterAccessor.findCompatibleTag(null, sampleModel);
                    RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel, n6);
                    rasterAccessorArray[n5] = new RasterAccessor(rasterArray2[n5], rectangle, rasterFormatTag, this.sourceAlpha[n5].getColorModel());
                }
                ++n5;
            }
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        byte[][][] byArrayArray = new byte[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                byArrayArray[n2] = rasterAccessorArray[n2].getByteDataArrays();
            }
            ++n2;
        }
        n2 = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        boolean bl = false;
        int n11 = 0;
        while (n11 < n) {
            if (rasterAccessorArray2[n11] != null) {
                bl = true;
                break;
            }
            ++n11;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        byte[][][] byArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            byArrayArray2 = new byte[n][][];
            int n12 = 0;
            while (n12 < n) {
                if (rasterAccessorArray2[n12] != null) {
                    nArray4[n12] = rasterAccessorArray2[n12].getScanlineStride();
                    nArray5[n12] = rasterAccessorArray2[n12].getPixelStride();
                    nArrayArray2[n12] = rasterAccessorArray2[n12].getBandOffsets();
                    byArrayArray2[n12] = rasterAccessorArray2[n12].getByteDataArrays();
                }
                ++n12;
            }
        }
        int[] nArray6 = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray6[n13] = 3;
            if (rasterAccessorArray2[n13] != null) {
                nArray6[n13] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n13] != null) {
                nArray6[n13] = 2;
            }
            ++n13;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        byte[][] byArrayArray3 = new byte[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        byte[][] byArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            byArrayArray4 = new byte[n][];
        }
        int n14 = 0;
        while (n14 < n8) {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20 = 0;
            while (n20 < n) {
                if (rasterAccessorArray[n20] != null) {
                    byArrayArray3[n20] = byArrayArray[n20][n14];
                    nArray7[n20] = nArrayArray[n20][n14];
                }
                if (nArray6[n20] == 1) {
                    byArrayArray4[n20] = byArrayArray2[n20][0];
                    nArray9[n20] = nArrayArray2[n20][0];
                }
                ++n20;
            }
            byte[] byArray2 = byArray[n14];
            int n21 = nArray3[n14];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n19 = n3;
                while (n19 < n7) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n22 = n18;
                            nArray7[n22] = nArray7[n22] + nArray[n18];
                        }
                        if (rasterAccessorArray2[n18] != null) {
                            nArray10[n18] = nArray9[n18];
                            int n23 = n18;
                            nArray9[n23] = nArray9[n23] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n18 = n21;
                    n21 += n9;
                    n17 = n2;
                    while (n17 < n6) {
                        boolean bl2 = false;
                        int n24 = 0;
                        while (n24 < n) {
                            if (rasterAccessorArray[n24] != null) {
                                n16 = byArrayArray3[n24][nArray8[n24]];
                                int n25 = n24;
                                nArray8[n25] = nArray8[n25] + nArray2[n24];
                                switch (nArray6[n24]) {
                                    case 1: {
                                        bl2 = byArrayArray4[n24][nArray10[n24]] != 0;
                                        int n26 = n24;
                                        nArray10[n26] = nArray10[n26] + nArray5[n24];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n24].getSample(n17, n19, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)(n16 & 0xFF) >= this.sourceThreshold[n24][n14];
                                    }
                                }
                                if (bl2) {
                                    byArray2[n18] = n16;
                                    n15 = n24 + 1;
                                    while (n15 < n) {
                                        if (rasterAccessorArray[n15] != null) {
                                            int n27 = n15;
                                            nArray8[n27] = nArray8[n27] + nArray2[n15];
                                        }
                                        if (rasterAccessorArray2[n15] != null) {
                                            int n28 = n15;
                                            nArray10[n28] = nArray10[n28] + nArray5[n15];
                                        }
                                        ++n15;
                                    }
                                    break;
                                }
                            }
                            ++n24;
                        }
                        if (!bl2) {
                            byArray2[n18] = (byte)this.background[n14];
                        }
                        n18 += n10;
                        ++n17;
                    }
                    ++n19;
                }
            } else {
                n19 = n3;
                while (n19 < n7) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n29 = n18;
                            nArray7[n29] = nArray7[n29] + nArray[n18];
                        }
                        if (nArray6[n18] == 1) {
                            nArray10[n18] = nArray9[n18];
                            int n30 = n18;
                            nArray9[n30] = nArray9[n30] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n18 = n21;
                    n21 += n9;
                    n17 = n2;
                    while (n17 < n6) {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        n16 = 0;
                        while (n16 < n) {
                            if (rasterAccessorArray[n16] != null) {
                                n15 = byArrayArray3[n16][nArray8[n16]];
                                int n31 = n16;
                                nArray8[n31] = nArray8[n31] + nArray2[n16];
                                float f3 = 0.0f;
                                switch (nArray6[n16]) {
                                    case 1: {
                                        f3 = byArrayArray4[n16][nArray10[n16]] & 0xFF;
                                        f3 = f3 > 0.0f && this.isAlphaBitmask ? 1.0f : (f3 /= 255.0f);
                                        int n32 = n16;
                                        nArray10[n32] = nArray10[n32] + nArray5[n16];
                                        break;
                                    }
                                    case 2: {
                                        f3 = rasterArray[n16].getSample(n17, n19, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f3 = (double)(n15 & 0xFF) >= this.sourceThreshold[n16][n14] ? 1.0f : 0.0f;
                                    }
                                }
                                f += f3 * (float)(n15 & 0xFF);
                                f2 += f3;
                            }
                            ++n16;
                        }
                        byArray2[n18] = (double)f2 == 0.0 ? (byte)this.background[n14] : ImageUtil.clampRoundByte(f / f2);
                        n18 += n10;
                        ++n17;
                    }
                    ++n19;
                }
            }
            ++n14;
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        short[][][] sArrayArray = new short[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                sArrayArray[n2] = rasterAccessorArray[n2].getShortDataArrays();
            }
            ++n2;
        }
        n2 = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n11 = 0;
        while (n11 < n) {
            if (rasterAccessorArray2[n11] != null) {
                bl = true;
                break;
            }
            ++n11;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        short[][][] sArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            sArrayArray2 = new short[n][][];
            int n12 = 0;
            while (n12 < n) {
                if (rasterAccessorArray2[n12] != null) {
                    nArray4[n12] = rasterAccessorArray2[n12].getScanlineStride();
                    nArray5[n12] = rasterAccessorArray2[n12].getPixelStride();
                    nArrayArray2[n12] = rasterAccessorArray2[n12].getBandOffsets();
                    sArrayArray2[n12] = rasterAccessorArray2[n12].getShortDataArrays();
                }
                ++n12;
            }
        }
        int[] nArray6 = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray6[n13] = 3;
            if (rasterAccessorArray2[n13] != null) {
                nArray6[n13] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n13] != null) {
                nArray6[n13] = 2;
            }
            ++n13;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        short[][] sArrayArray3 = new short[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        short[][] sArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            sArrayArray4 = new short[n][];
        }
        int n14 = 0;
        while (n14 < n8) {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20 = 0;
            while (n20 < n) {
                if (rasterAccessorArray[n20] != null) {
                    sArrayArray3[n20] = sArrayArray[n20][n14];
                    nArray7[n20] = nArrayArray[n20][n14];
                }
                if (nArray6[n20] == 1) {
                    sArrayArray4[n20] = sArrayArray2[n20][0];
                    nArray9[n20] = nArrayArray2[n20][0];
                }
                ++n20;
            }
            short[] sArray2 = sArray[n14];
            int n21 = nArray3[n14];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n19 = n3;
                while (n19 < n7) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n22 = n18;
                            nArray7[n22] = nArray7[n22] + nArray[n18];
                        }
                        if (rasterAccessorArray2[n18] != null) {
                            nArray10[n18] = nArray9[n18];
                            int n23 = n18;
                            nArray9[n23] = nArray9[n23] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n18 = n21;
                    n21 += n9;
                    n17 = n2;
                    while (n17 < n6) {
                        boolean bl2 = false;
                        int n24 = 0;
                        while (n24 < n) {
                            if (rasterAccessorArray[n24] != null) {
                                n16 = sArrayArray3[n24][nArray8[n24]];
                                int n25 = n24;
                                nArray8[n25] = nArray8[n25] + nArray2[n24];
                                switch (nArray6[n24]) {
                                    case 1: {
                                        bl2 = sArrayArray4[n24][nArray10[n24]] != 0;
                                        int n26 = n24;
                                        nArray10[n26] = nArray10[n26] + nArray5[n24];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n24].getSample(n17, n19, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)(n16 & 0xFFFF) >= this.sourceThreshold[n24][n14];
                                    }
                                }
                                if (bl2) {
                                    sArray2[n18] = n16;
                                    n15 = n24 + 1;
                                    while (n15 < n) {
                                        if (rasterAccessorArray[n15] != null) {
                                            int n27 = n15;
                                            nArray8[n27] = nArray8[n27] + nArray2[n15];
                                        }
                                        if (rasterAccessorArray2[n15] != null) {
                                            int n28 = n15;
                                            nArray10[n28] = nArray10[n28] + nArray5[n15];
                                        }
                                        ++n15;
                                    }
                                    break;
                                }
                            }
                            ++n24;
                        }
                        if (!bl2) {
                            sArray2[n18] = (short)this.background[n14];
                        }
                        n18 += n10;
                        ++n17;
                    }
                    ++n19;
                }
            } else {
                n19 = n3;
                while (n19 < n7) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n29 = n18;
                            nArray7[n29] = nArray7[n29] + nArray[n18];
                        }
                        if (nArray6[n18] == 1) {
                            nArray10[n18] = nArray9[n18];
                            int n30 = n18;
                            nArray9[n30] = nArray9[n30] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n18 = n21;
                    n21 += n9;
                    n17 = n2;
                    while (n17 < n6) {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        n16 = 0;
                        while (n16 < n) {
                            if (rasterAccessorArray[n16] != null) {
                                n15 = sArrayArray3[n16][nArray8[n16]];
                                int n31 = n16;
                                nArray8[n31] = nArray8[n31] + nArray2[n16];
                                float f3 = 0.0f;
                                switch (nArray6[n16]) {
                                    case 1: {
                                        f3 = sArrayArray4[n16][nArray10[n16]] & 0xFFFF;
                                        f3 = f3 > 0.0f && this.isAlphaBitmask ? 1.0f : (f3 /= 65535.0f);
                                        int n32 = n16;
                                        nArray10[n32] = nArray10[n32] + nArray5[n16];
                                        break;
                                    }
                                    case 2: {
                                        f3 = rasterArray[n16].getSample(n17, n19, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f3 = (double)(n15 & 0xFFFF) >= this.sourceThreshold[n16][n14] ? 1.0f : 0.0f;
                                    }
                                }
                                f += f3 * (float)(n15 & 0xFFFF);
                                f2 += f3;
                            }
                            ++n16;
                        }
                        sArray2[n18] = (double)f2 == 0.0 ? (short)this.background[n14] : ImageUtil.clampRoundUShort(f / f2);
                        n18 += n10;
                        ++n17;
                    }
                    ++n19;
                }
            }
            ++n14;
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        short[][][] sArrayArray = new short[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                sArrayArray[n2] = rasterAccessorArray[n2].getShortDataArrays();
            }
            ++n2;
        }
        n2 = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n11 = 0;
        while (n11 < n) {
            if (rasterAccessorArray2[n11] != null) {
                bl = true;
                break;
            }
            ++n11;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        short[][][] sArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            sArrayArray2 = new short[n][][];
            int n12 = 0;
            while (n12 < n) {
                if (rasterAccessorArray2[n12] != null) {
                    nArray4[n12] = rasterAccessorArray2[n12].getScanlineStride();
                    nArray5[n12] = rasterAccessorArray2[n12].getPixelStride();
                    nArrayArray2[n12] = rasterAccessorArray2[n12].getBandOffsets();
                    sArrayArray2[n12] = rasterAccessorArray2[n12].getShortDataArrays();
                }
                ++n12;
            }
        }
        int[] nArray6 = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray6[n13] = 3;
            if (rasterAccessorArray2[n13] != null) {
                nArray6[n13] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n13] != null) {
                nArray6[n13] = 2;
            }
            ++n13;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        short[][] sArrayArray3 = new short[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        short[][] sArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            sArrayArray4 = new short[n][];
        }
        int n14 = 0;
        while (n14 < n8) {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20 = 0;
            while (n20 < n) {
                if (rasterAccessorArray[n20] != null) {
                    sArrayArray3[n20] = sArrayArray[n20][n14];
                    nArray7[n20] = nArrayArray[n20][n14];
                }
                if (nArray6[n20] == 1) {
                    sArrayArray4[n20] = sArrayArray2[n20][0];
                    nArray9[n20] = nArrayArray2[n20][0];
                }
                ++n20;
            }
            short[] sArray2 = sArray[n14];
            int n21 = nArray3[n14];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n19 = n3;
                while (n19 < n7) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n22 = n18;
                            nArray7[n22] = nArray7[n22] + nArray[n18];
                        }
                        if (rasterAccessorArray2[n18] != null) {
                            nArray10[n18] = nArray9[n18];
                            int n23 = n18;
                            nArray9[n23] = nArray9[n23] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n18 = n21;
                    n21 += n9;
                    n17 = n2;
                    while (n17 < n6) {
                        boolean bl2 = false;
                        int n24 = 0;
                        while (n24 < n) {
                            if (rasterAccessorArray[n24] != null) {
                                n16 = sArrayArray3[n24][nArray8[n24]];
                                int n25 = n24;
                                nArray8[n25] = nArray8[n25] + nArray2[n24];
                                switch (nArray6[n24]) {
                                    case 1: {
                                        bl2 = sArrayArray4[n24][nArray10[n24]] != 0;
                                        int n26 = n24;
                                        nArray10[n26] = nArray10[n26] + nArray5[n24];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n24].getSample(n17, n19, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)n16 >= this.sourceThreshold[n24][n14];
                                    }
                                }
                                if (bl2) {
                                    sArray2[n18] = n16;
                                    n15 = n24 + 1;
                                    while (n15 < n) {
                                        if (rasterAccessorArray[n15] != null) {
                                            int n27 = n15;
                                            nArray8[n27] = nArray8[n27] + nArray2[n15];
                                        }
                                        if (rasterAccessorArray2[n15] != null) {
                                            int n28 = n15;
                                            nArray10[n28] = nArray10[n28] + nArray5[n15];
                                        }
                                        ++n15;
                                    }
                                    break;
                                }
                            }
                            ++n24;
                        }
                        if (!bl2) {
                            sArray2[n18] = (short)this.background[n14];
                        }
                        n18 += n10;
                        ++n17;
                    }
                    ++n19;
                }
            } else {
                n19 = n3;
                while (n19 < n7) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n29 = n18;
                            nArray7[n29] = nArray7[n29] + nArray[n18];
                        }
                        if (nArray6[n18] == 1) {
                            nArray10[n18] = nArray9[n18];
                            int n30 = n18;
                            nArray9[n30] = nArray9[n30] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n18 = n21;
                    n21 += n9;
                    n17 = n2;
                    while (n17 < n6) {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        n16 = 0;
                        while (n16 < n) {
                            if (rasterAccessorArray[n16] != null) {
                                n15 = sArrayArray3[n16][nArray8[n16]];
                                int n31 = n16;
                                nArray8[n31] = nArray8[n31] + nArray2[n16];
                                float f3 = 0.0f;
                                switch (nArray6[n16]) {
                                    case 1: {
                                        f3 = sArrayArray4[n16][nArray10[n16]];
                                        f3 = f3 > 0.0f && this.isAlphaBitmask ? 1.0f : (f3 /= 32767.0f);
                                        int n32 = n16;
                                        nArray10[n32] = nArray10[n32] + nArray5[n16];
                                        break;
                                    }
                                    case 2: {
                                        f3 = rasterArray[n16].getSample(n17, n19, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f3 = (double)n15 >= this.sourceThreshold[n16][n14] ? 1.0f : 0.0f;
                                    }
                                }
                                f += f3 * (float)n15;
                                f2 += f3;
                            }
                            ++n16;
                        }
                        sArray2[n18] = (double)f2 == 0.0 ? (short)this.background[n14] : ImageUtil.clampRoundShort(f / f2);
                        n18 += n10;
                        ++n17;
                    }
                    ++n19;
                }
            }
            ++n14;
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        int[][][] nArrayArray2 = new int[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                nArrayArray2[n2] = rasterAccessorArray[n2].getIntDataArrays();
            }
            ++n2;
        }
        n2 = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        boolean bl = false;
        int n11 = 0;
        while (n11 < n) {
            if (rasterAccessorArray2[n11] != null) {
                bl = true;
                break;
            }
            ++n11;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int[][] nArrayArray3 = null;
        int[][][] nArrayArray4 = null;
        if (bl) {
            nArray5 = new int[n];
            nArray6 = new int[n];
            nArrayArray3 = new int[n][];
            nArrayArray4 = new int[n][][];
            int n12 = 0;
            while (n12 < n) {
                if (rasterAccessorArray2[n12] != null) {
                    nArray5[n12] = rasterAccessorArray2[n12].getScanlineStride();
                    nArray6[n12] = rasterAccessorArray2[n12].getPixelStride();
                    nArrayArray3[n12] = rasterAccessorArray2[n12].getBandOffsets();
                    nArrayArray4[n12] = rasterAccessorArray2[n12].getIntDataArrays();
                }
                ++n12;
            }
        }
        int[] nArray7 = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray7[n13] = 3;
            if (rasterAccessorArray2[n13] != null) {
                nArray7[n13] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n13] != null) {
                nArray7[n13] = 2;
            }
            ++n13;
        }
        int[] nArray8 = new int[n];
        int[] nArray9 = new int[n];
        int[][] nArrayArray5 = new int[n][];
        int[] nArray10 = null;
        int[] nArray11 = null;
        int[][] nArrayArray6 = null;
        if (bl) {
            nArray10 = new int[n];
            nArray11 = new int[n];
            nArrayArray6 = new int[n][];
        }
        int n14 = 0;
        while (n14 < n8) {
            int n15;
            int n16;
            int n17;
            int n18 = 0;
            while (n18 < n) {
                if (rasterAccessorArray[n18] != null) {
                    nArrayArray5[n18] = nArrayArray2[n18][n14];
                    nArray8[n18] = nArrayArray[n18][n14];
                }
                if (nArray7[n18] == 1) {
                    nArrayArray6[n18] = nArrayArray4[n18][0];
                    nArray10[n18] = nArrayArray3[n18][0];
                }
                ++n18;
            }
            int[] nArray12 = nArray4[n14];
            int n19 = nArray3[n14];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n17 = n3;
                while (n17 < n7) {
                    n16 = 0;
                    while (n16 < n) {
                        if (rasterAccessorArray[n16] != null) {
                            nArray9[n16] = nArray8[n16];
                            int n20 = n16;
                            nArray8[n20] = nArray8[n20] + nArray[n16];
                        }
                        if (rasterAccessorArray2[n16] != null) {
                            nArray11[n16] = nArray10[n16];
                            int n21 = n16;
                            nArray10[n21] = nArray10[n21] + nArray5[n16];
                        }
                        ++n16;
                    }
                    n16 = n19;
                    n19 += n9;
                    n15 = n2;
                    while (n15 < n6) {
                        boolean bl2 = false;
                        int n22 = 0;
                        while (n22 < n) {
                            if (rasterAccessorArray[n22] != null) {
                                int n23 = nArrayArray5[n22][nArray9[n22]];
                                int n24 = n22;
                                nArray9[n24] = nArray9[n24] + nArray2[n22];
                                switch (nArray7[n22]) {
                                    case 1: {
                                        bl2 = nArrayArray6[n22][nArray11[n22]] != 0;
                                        int n25 = n22;
                                        nArray11[n25] = nArray11[n25] + nArray6[n22];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n22].getSample(n15, n17, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)n23 >= this.sourceThreshold[n22][n14];
                                    }
                                }
                                if (bl2) {
                                    nArray12[n16] = n23;
                                    int n26 = n22 + 1;
                                    while (n26 < n) {
                                        if (rasterAccessorArray[n26] != null) {
                                            int n27 = n26;
                                            nArray9[n27] = nArray9[n27] + nArray2[n26];
                                        }
                                        if (rasterAccessorArray2[n26] != null) {
                                            int n28 = n26;
                                            nArray11[n28] = nArray11[n28] + nArray6[n26];
                                        }
                                        ++n26;
                                    }
                                    break;
                                }
                            }
                            ++n22;
                        }
                        if (!bl2) {
                            nArray12[n16] = this.background[n14];
                        }
                        n16 += n10;
                        ++n15;
                    }
                    ++n17;
                }
            } else {
                n17 = n3;
                while (n17 < n7) {
                    n16 = 0;
                    while (n16 < n) {
                        if (rasterAccessorArray[n16] != null) {
                            nArray9[n16] = nArray8[n16];
                            int n29 = n16;
                            nArray8[n29] = nArray8[n29] + nArray[n16];
                        }
                        if (nArray7[n16] == 1) {
                            nArray11[n16] = nArray10[n16];
                            int n30 = n16;
                            nArray10[n30] = nArray10[n30] + nArray5[n16];
                        }
                        ++n16;
                    }
                    n16 = n19;
                    n19 += n9;
                    n15 = n2;
                    while (n15 < n6) {
                        double d = 0.0;
                        double d2 = 0.0;
                        int n31 = 0;
                        while (n31 < n) {
                            if (rasterAccessorArray[n31] != null) {
                                int n32 = nArrayArray5[n31][nArray9[n31]];
                                int n33 = n31;
                                nArray9[n33] = nArray9[n33] + nArray2[n31];
                                double d3 = 0.0;
                                switch (nArray7[n31]) {
                                    case 1: {
                                        d3 = nArrayArray6[n31][nArray11[n31]];
                                        d3 = d3 > 0.0 && this.isAlphaBitmask ? 1.0 : (d3 /= 2.147483647E9);
                                        int n34 = n31;
                                        nArray11[n34] = nArray11[n34] + nArray6[n31];
                                        break;
                                    }
                                    case 2: {
                                        d3 = rasterArray[n31].getSample(n15, n17, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        d3 = (double)n32 >= this.sourceThreshold[n31][n14] ? 1.0f : 0.0f;
                                    }
                                }
                                d += d3 * (double)n32;
                                d2 += d3;
                            }
                            ++n31;
                        }
                        nArray12[n16] = d2 == 0.0 ? this.background[n14] : ImageUtil.clampRoundInt(d / d2);
                        n16 += n10;
                        ++n15;
                    }
                    ++n17;
                }
            }
            ++n14;
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        float[][][] fArrayArray = new float[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                fArrayArray[n2] = rasterAccessorArray[n2].getFloatDataArrays();
            }
            ++n2;
        }
        n2 = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        boolean bl = false;
        int n11 = 0;
        while (n11 < n) {
            if (rasterAccessorArray2[n11] != null) {
                bl = true;
                break;
            }
            ++n11;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        float[][][] fArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            fArrayArray2 = new float[n][][];
            int n12 = 0;
            while (n12 < n) {
                if (rasterAccessorArray2[n12] != null) {
                    nArray4[n12] = rasterAccessorArray2[n12].getScanlineStride();
                    nArray5[n12] = rasterAccessorArray2[n12].getPixelStride();
                    nArrayArray2[n12] = rasterAccessorArray2[n12].getBandOffsets();
                    fArrayArray2[n12] = rasterAccessorArray2[n12].getFloatDataArrays();
                }
                ++n12;
            }
        }
        int[] nArray6 = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray6[n13] = 3;
            if (rasterAccessorArray2[n13] != null) {
                nArray6[n13] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n13] != null) {
                nArray6[n13] = 2;
            }
            ++n13;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        float[][] fArrayArray3 = new float[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        float[][] fArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            fArrayArray4 = new float[n][];
        }
        int n14 = 0;
        while (n14 < n8) {
            int n15;
            int n16;
            int n17;
            int n18 = 0;
            while (n18 < n) {
                if (rasterAccessorArray[n18] != null) {
                    fArrayArray3[n18] = fArrayArray[n18][n14];
                    nArray7[n18] = nArrayArray[n18][n14];
                }
                if (nArray6[n18] == 1) {
                    fArrayArray4[n18] = fArrayArray2[n18][0];
                    nArray9[n18] = nArrayArray2[n18][0];
                }
                ++n18;
            }
            float[] fArray2 = fArray[n14];
            int n19 = nArray3[n14];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n17 = n3;
                while (n17 < n7) {
                    n16 = 0;
                    while (n16 < n) {
                        if (rasterAccessorArray[n16] != null) {
                            nArray8[n16] = nArray7[n16];
                            int n20 = n16;
                            nArray7[n20] = nArray7[n20] + nArray[n16];
                        }
                        if (rasterAccessorArray2[n16] != null) {
                            nArray10[n16] = nArray9[n16];
                            int n21 = n16;
                            nArray9[n21] = nArray9[n21] + nArray4[n16];
                        }
                        ++n16;
                    }
                    n16 = n19;
                    n19 += n9;
                    n15 = n2;
                    while (n15 < n6) {
                        boolean bl2 = false;
                        int n22 = 0;
                        while (n22 < n) {
                            if (rasterAccessorArray[n22] != null) {
                                float f = fArrayArray3[n22][nArray8[n22]];
                                int n23 = n22;
                                nArray8[n23] = nArray8[n23] + nArray2[n22];
                                switch (nArray6[n22]) {
                                    case 1: {
                                        bl2 = fArrayArray4[n22][nArray10[n22]] != 0.0f;
                                        int n24 = n22;
                                        nArray10[n24] = nArray10[n24] + nArray5[n22];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n22].getSample(n15, n17, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)f >= this.sourceThreshold[n22][n14];
                                    }
                                }
                                if (bl2) {
                                    fArray2[n16] = f;
                                    int n25 = n22 + 1;
                                    while (n25 < n) {
                                        if (rasterAccessorArray[n25] != null) {
                                            int n26 = n25;
                                            nArray8[n26] = nArray8[n26] + nArray2[n25];
                                        }
                                        if (rasterAccessorArray2[n25] != null) {
                                            int n27 = n25;
                                            nArray10[n27] = nArray10[n27] + nArray5[n25];
                                        }
                                        ++n25;
                                    }
                                    break;
                                }
                            }
                            ++n22;
                        }
                        if (!bl2) {
                            fArray2[n16] = (float)this.backgroundValues[n14];
                        }
                        n16 += n10;
                        ++n15;
                    }
                    ++n17;
                }
            } else {
                n17 = n3;
                while (n17 < n7) {
                    n16 = 0;
                    while (n16 < n) {
                        if (rasterAccessorArray[n16] != null) {
                            nArray8[n16] = nArray7[n16];
                            int n28 = n16;
                            nArray7[n28] = nArray7[n28] + nArray[n16];
                        }
                        if (nArray6[n16] == 1) {
                            nArray10[n16] = nArray9[n16];
                            int n29 = n16;
                            nArray9[n29] = nArray9[n29] + nArray4[n16];
                        }
                        ++n16;
                    }
                    n16 = n19;
                    n19 += n9;
                    n15 = n2;
                    while (n15 < n6) {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        int n30 = 0;
                        while (n30 < n) {
                            if (rasterAccessorArray[n30] != null) {
                                float f3 = fArrayArray3[n30][nArray8[n30]];
                                int n31 = n30;
                                nArray8[n31] = nArray8[n31] + nArray2[n30];
                                float f4 = 0.0f;
                                switch (nArray6[n30]) {
                                    case 1: {
                                        f4 = fArrayArray4[n30][nArray10[n30]];
                                        if (f4 > 0.0f && this.isAlphaBitmask) {
                                            f4 = 1.0f;
                                        }
                                        int n32 = n30;
                                        nArray10[n32] = nArray10[n32] + nArray5[n30];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n30].getSample(n15, n17, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)f3 >= this.sourceThreshold[n30][n14] ? 1.0f : 0.0f;
                                    }
                                }
                                f += f4 * f3;
                                f2 += f4;
                            }
                            ++n30;
                        }
                        fArray2[n16] = (double)f2 == 0.0 ? (float)this.backgroundValues[n14] : f / f2;
                        n16 += n10;
                        ++n15;
                    }
                    ++n17;
                }
            }
            ++n14;
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        double[][][] dArrayArray = new double[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                dArrayArray[n2] = rasterAccessorArray[n2].getDoubleDataArrays();
            }
            ++n2;
        }
        n2 = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        boolean bl = false;
        int n11 = 0;
        while (n11 < n) {
            if (rasterAccessorArray2[n11] != null) {
                bl = true;
                break;
            }
            ++n11;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        double[][][] dArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            dArrayArray2 = new double[n][][];
            int n12 = 0;
            while (n12 < n) {
                if (rasterAccessorArray2[n12] != null) {
                    nArray4[n12] = rasterAccessorArray2[n12].getScanlineStride();
                    nArray5[n12] = rasterAccessorArray2[n12].getPixelStride();
                    nArrayArray2[n12] = rasterAccessorArray2[n12].getBandOffsets();
                    dArrayArray2[n12] = rasterAccessorArray2[n12].getDoubleDataArrays();
                }
                ++n12;
            }
        }
        int[] nArray6 = new int[n];
        int n13 = 0;
        while (n13 < n) {
            nArray6[n13] = 3;
            if (rasterAccessorArray2[n13] != null) {
                nArray6[n13] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n13] != null) {
                nArray6[n13] = 2;
            }
            ++n13;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        double[][] dArrayArray3 = new double[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        double[][] dArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            dArrayArray4 = new double[n][];
        }
        int n14 = 0;
        while (n14 < n8) {
            int n15;
            double d;
            int n16;
            int n17;
            int n18;
            int n19 = 0;
            while (n19 < n) {
                if (rasterAccessorArray[n19] != null) {
                    dArrayArray3[n19] = dArrayArray[n19][n14];
                    nArray7[n19] = nArrayArray[n19][n14];
                }
                if (nArray6[n19] == 1) {
                    dArrayArray4[n19] = dArrayArray2[n19][0];
                    nArray9[n19] = nArrayArray2[n19][0];
                }
                ++n19;
            }
            double[] dArray2 = dArray[n14];
            int n20 = nArray3[n14];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n18 = n3;
                while (n18 < n7) {
                    n17 = 0;
                    while (n17 < n) {
                        if (rasterAccessorArray[n17] != null) {
                            nArray8[n17] = nArray7[n17];
                            int n21 = n17;
                            nArray7[n21] = nArray7[n21] + nArray[n17];
                        }
                        if (rasterAccessorArray2[n17] != null) {
                            nArray10[n17] = nArray9[n17];
                            int n22 = n17;
                            nArray9[n22] = nArray9[n22] + nArray4[n17];
                        }
                        ++n17;
                    }
                    n17 = n20;
                    n20 += n9;
                    n16 = n2;
                    while (n16 < n6) {
                        boolean bl2 = false;
                        int n23 = 0;
                        while (n23 < n) {
                            if (rasterAccessorArray[n23] != null) {
                                d = dArrayArray3[n23][nArray8[n23]];
                                int n24 = n23;
                                nArray8[n24] = nArray8[n24] + nArray2[n23];
                                switch (nArray6[n23]) {
                                    case 1: {
                                        bl2 = dArrayArray4[n23][nArray10[n23]] != 0.0;
                                        int n25 = n23;
                                        nArray10[n25] = nArray10[n25] + nArray5[n23];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n23].getSample(n16, n18, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = d >= this.sourceThreshold[n23][n14];
                                    }
                                }
                                if (bl2) {
                                    dArray2[n17] = d;
                                    n15 = n23 + 1;
                                    while (n15 < n) {
                                        if (rasterAccessorArray[n15] != null) {
                                            int n26 = n15;
                                            nArray8[n26] = nArray8[n26] + nArray2[n15];
                                        }
                                        if (rasterAccessorArray2[n15] != null) {
                                            int n27 = n15;
                                            nArray10[n27] = nArray10[n27] + nArray5[n15];
                                        }
                                        ++n15;
                                    }
                                    break;
                                }
                            }
                            ++n23;
                        }
                        if (!bl2) {
                            dArray2[n17] = this.backgroundValues[n14];
                        }
                        n17 += n10;
                        ++n16;
                    }
                    ++n18;
                }
            } else {
                n18 = n3;
                while (n18 < n7) {
                    n17 = 0;
                    while (n17 < n) {
                        if (rasterAccessorArray[n17] != null) {
                            nArray8[n17] = nArray7[n17];
                            int n28 = n17;
                            nArray7[n28] = nArray7[n28] + nArray[n17];
                        }
                        if (nArray6[n17] == 1) {
                            nArray10[n17] = nArray9[n17];
                            int n29 = n17;
                            nArray9[n29] = nArray9[n29] + nArray4[n17];
                        }
                        ++n17;
                    }
                    n17 = n20;
                    n20 += n9;
                    n16 = n2;
                    while (n16 < n6) {
                        double d2 = 0.0;
                        d = 0.0;
                        n15 = 0;
                        while (n15 < n) {
                            if (rasterAccessorArray[n15] != null) {
                                double d3 = dArrayArray3[n15][nArray8[n15]];
                                int n30 = n15;
                                nArray8[n30] = nArray8[n30] + nArray2[n15];
                                double d4 = 0.0;
                                switch (nArray6[n15]) {
                                    case 1: {
                                        d4 = dArrayArray4[n15][nArray10[n15]];
                                        if (d4 > 0.0 && this.isAlphaBitmask) {
                                            d4 = 1.0;
                                        }
                                        int n31 = n15;
                                        nArray10[n31] = nArray10[n31] + nArray5[n15];
                                        break;
                                    }
                                    case 2: {
                                        d4 = rasterArray[n15].getSample(n16, n18, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        d4 = d3 >= this.sourceThreshold[n15][n14] ? 1.0f : 0.0f;
                                    }
                                }
                                d2 += d4 * d3;
                                d += d4;
                            }
                            ++n15;
                        }
                        dArray2[n17] = d == 0.0 ? this.backgroundValues[n14] : d2 / d;
                        n17 += n10;
                        ++n16;
                    }
                    ++n18;
                }
            }
            ++n14;
        }
    }
}

