/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class MinOpImage
extends PointOpImage {
    private static long negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    private static byte[] byteTable = null;
    private static SoftReference softRef = null;

    private synchronized void allocByteTable() {
        if (softRef == null || softRef.get() == null) {
            byteTable = new byte[65536];
            softRef = new SoftReference<byte[]>(byteTable);
            int n = 0;
            while (n < 256) {
                int n2 = n << 8;
                int n3 = 0;
                while (n3 < n) {
                    MinOpImage.byteTable[n2 + n3] = (byte)n3;
                    ++n3;
                }
                n3 = n;
                while (n3 < 256) {
                    MinOpImage.byteTable[n2 + n3] = (byte)n;
                    ++n3;
                }
                ++n;
            }
        }
    }

    public MinOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        if (this.sampleModel.getTransferType() == 0) {
            this.allocByteTable();
        }
        this.permitInPlaceOperation();
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSource(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
            }
        }
        if (rasterAccessor3.isDataCopy()) {
            rasterAccessor3.clampDataArrays();
            rasterAccessor3.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        byte[][] byArray3 = rasterAccessor3.getByteDataArrays();
        int n10 = 0;
        while (n10 < n7) {
            byte[] byArray4 = byArray[n10];
            byte[] byArray5 = byArray2[n10];
            byte[] byArray6 = byArray3[n10];
            int n11 = nArray[n10];
            int n12 = nArray2[n10];
            int n13 = nArray3[n10];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n11;
                int n16 = n12;
                int n17 = n13;
                n11 += n;
                n12 += n3;
                n13 += n8;
                int n18 = n17 + n5 * n9;
                while (n17 < n18) {
                    int n19 = byArray4[n15] & 0xFF;
                    int n20 = byArray5[n16] & 0xFF;
                    byArray6[n17] = byteTable[(n19 << 8) + n20];
                    n15 += n2;
                    n16 += n4;
                    n17 += n9;
                }
                ++n14;
            }
            ++n10;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n10 = 0;
        while (n10 < n7) {
            short[] sArray4 = sArray[n10];
            short[] sArray5 = sArray2[n10];
            short[] sArray6 = sArray3[n10];
            int n11 = nArray[n10];
            int n12 = nArray2[n10];
            int n13 = nArray3[n10];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n11;
                int n16 = n12;
                int n17 = n13;
                n11 += n;
                n12 += n3;
                n13 += n8;
                int n18 = 0;
                while (n18 < n5) {
                    sArray6[n17] = this.minUShort(sArray4[n15], sArray5[n16]);
                    n15 += n2;
                    n16 += n4;
                    n17 += n9;
                    ++n18;
                }
                ++n14;
            }
            ++n10;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        int n10 = 0;
        while (n10 < n7) {
            short[] sArray4 = sArray[n10];
            short[] sArray5 = sArray2[n10];
            short[] sArray6 = sArray3[n10];
            int n11 = nArray[n10];
            int n12 = nArray2[n10];
            int n13 = nArray3[n10];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n11;
                int n16 = n12;
                int n17 = n13;
                n11 += n;
                n12 += n3;
                n13 += n8;
                int n18 = 0;
                while (n18 < n5) {
                    sArray6[n17] = this.minShort(sArray4[n15], sArray5[n16]);
                    n15 += n2;
                    n16 += n4;
                    n17 += n9;
                    ++n18;
                }
                ++n14;
            }
            ++n10;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray5 = rasterAccessor3.getBandOffsets();
        int[][] nArray6 = rasterAccessor3.getIntDataArrays();
        int n10 = 0;
        while (n10 < n7) {
            int[] nArray7 = nArray2[n10];
            int[] nArray8 = nArray4[n10];
            int[] nArray9 = nArray6[n10];
            int n11 = nArray[n10];
            int n12 = nArray3[n10];
            int n13 = nArray5[n10];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n11;
                int n16 = n12;
                int n17 = n13;
                n11 += n;
                n12 += n3;
                n13 += n8;
                int n18 = 0;
                while (n18 < n5) {
                    nArray9[n17] = this.minInt(nArray7[n15], nArray8[n16]);
                    n15 += n2;
                    n16 += n4;
                    n17 += n9;
                    ++n18;
                }
                ++n14;
            }
            ++n10;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        float[][] fArray3 = rasterAccessor3.getFloatDataArrays();
        int n10 = 0;
        while (n10 < n7) {
            float[] fArray4 = fArray[n10];
            float[] fArray5 = fArray2[n10];
            float[] fArray6 = fArray3[n10];
            int n11 = nArray[n10];
            int n12 = nArray2[n10];
            int n13 = nArray3[n10];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n11;
                int n16 = n12;
                int n17 = n13;
                n11 += n;
                n12 += n3;
                n13 += n8;
                int n18 = 0;
                while (n18 < n5) {
                    fArray6[n17] = MinOpImage.minFloat(fArray4[n15], fArray5[n16]);
                    n15 += n2;
                    n16 += n4;
                    n17 += n9;
                    ++n18;
                }
                ++n14;
            }
            ++n10;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        double[][] dArray3 = rasterAccessor3.getDoubleDataArrays();
        int n10 = 0;
        while (n10 < n7) {
            double[] dArray4 = dArray[n10];
            double[] dArray5 = dArray2[n10];
            double[] dArray6 = dArray3[n10];
            int n11 = nArray[n10];
            int n12 = nArray2[n10];
            int n13 = nArray3[n10];
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n11;
                int n16 = n12;
                int n17 = n13;
                n11 += n;
                n12 += n3;
                n13 += n8;
                int n18 = 0;
                while (n18 < n5) {
                    dArray6[n17] = MinOpImage.minDouble(dArray4[n15], dArray5[n16]);
                    n15 += n2;
                    n16 += n4;
                    n17 += n9;
                    ++n18;
                }
                ++n14;
            }
            ++n10;
        }
    }

    private final short minUShort(short s, short s2) {
        return (s & 0xFFFF) < (s2 & 0xFFFF) ? s : s2;
    }

    private final short minShort(short s, short s2) {
        return s <= s2 ? s : s2;
    }

    private final int minInt(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static float minFloat(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f2;
        }
        return f <= f2 ? f : f2;
    }

    public static double minDouble(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d2;
        }
        return d <= d2 ? d : d2;
    }
}

