/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.MinFilterPlusOpImage;
import com.sun.media.jai.opimage.MinFilterSeparableOpImage;
import com.sun.media.jai.opimage.MinFilterSquareOpImage;
import com.sun.media.jai.opimage.MinFilterXOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MinFilterDescriptor;
import javax.media.jai.operator.MinFilterShape;

public class MinFilterRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        MinFilterShape minFilterShape = (MinFilterShape)parameterBlock.getObjectParameter(0);
        int n = parameterBlock.getIntParameter(1);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_SQUARE)) {
            return new MinFilterSquareOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_PLUS)) {
            return new MinFilterPlusOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_X)) {
            return new MinFilterXOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        if (minFilterShape.equals(MinFilterDescriptor.MIN_MASK_SQUARE_SEPARABLE)) {
            return new MinFilterSeparableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        return null;
    }
}

