/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import com.sun.media.jai.opimage.Cube;
import com.sun.media.jai.opimage.HistogramHash;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.UnpackedImageData;

public class MedianCutOpImage
extends ColorQuantizerOpImage {
    private int histogramSize;
    private int[] counts;
    private int[] colors;
    private Cube[] partition;
    private int bits = 8;
    private int mask;
    HistogramHash histogram;

    public MedianCutOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2, ROI rOI, int n3, int n4) {
        super(renderedImage, map, imageLayout, n, rOI, n3, n4);
        this.colorMap = null;
        this.histogramSize = n2;
    }

    @Override
    protected synchronized void train() {
        int n;
        PlanarImage planarImage = this.getSourceImage(0);
        if (this.roi == null) {
            this.roi = new ROIShape(planarImage.getBounds());
        }
        int n2 = planarImage.getMinTileX();
        int n3 = planarImage.getMaxTileX();
        int n4 = planarImage.getMinTileY();
        int n5 = planarImage.getMaxTileY();
        int n6 = planarImage.getMinX();
        int n7 = planarImage.getMinY();
        this.histogram = new HistogramHash(this.histogramSize);
        block0: do {
            this.histogram.init();
            n = this.bits;
            this.mask = 255 << 8 - this.bits & 0xFF;
            this.mask = this.mask | this.mask << 8 | this.mask << 16;
            int n8 = n4;
            while (n8 <= n5) {
                int n9 = n2;
                while (n9 <= n3) {
                    block7: {
                        Rectangle rectangle;
                        block8: {
                            rectangle = planarImage.getTileRect(n9, n8);
                            if (!this.roi.intersects(rectangle)) break block7;
                            if (!this.checkForSkippedTiles || rectangle.x < n6 || rectangle.y < n7) break block8;
                            int n10 = (this.xPeriod - (rectangle.x - n6) % this.xPeriod) % this.xPeriod;
                            int n11 = (this.yPeriod - (rectangle.y - n7) % this.yPeriod) % this.yPeriod;
                            if (n10 >= rectangle.width || n11 >= rectangle.height) break block7;
                        }
                        this.computeHistogram(planarImage.getData(rectangle));
                        if (this.histogram.isFull()) break;
                    }
                    ++n9;
                }
                if (this.histogram.isFull()) continue block0;
                ++n8;
            }
        } while (n != this.bits);
        this.counts = this.histogram.getCounts();
        this.colors = this.histogram.getColors();
        this.medianCut(this.maxColorNum);
        this.setProperty("LUT", this.colorMap);
        this.setProperty("JAI.LookupTable", this.colorMap);
    }

    private void computeHistogram(Raster raster) {
        LinkedList linkedList;
        if (!this.isInitialized) {
            this.srcPA = new PixelAccessor(this.getSourceImage(0));
            this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
            this.isInitialized = true;
        }
        Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
            int n3 = rectangle2.x;
            int n4 = rectangle2.y;
            rectangle2.x = MedianCutOpImage.startPosition(n3, n, this.xPeriod);
            rectangle2.y = MedianCutOpImage.startPosition(n4, n2, this.yPeriod);
            rectangle2.width = n3 + rectangle2.width - rectangle2.x;
            rectangle2.height = n4 + rectangle2.height - rectangle2.y;
            if (rectangle2.isEmpty()) continue;
            UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, rectangle2, this.srcSampleType, false);
            switch (unpackedImageData.type) {
                case 0: {
                    this.computeHistogramByte(unpackedImageData);
                }
            }
        }
    }

    private void computeHistogramByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = rectangle.height * n;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = n6 + rectangle.width * n2;
            int n8 = n6;
            while (n8 < n7) {
                int n9 = (byArray2[n8 + unpackedImageData.bandOffsets[0]] & 0xFF) << 16 | (byArray3[n8 + unpackedImageData.bandOffsets[1]] & 0xFF) << 8 | byArray4[n8 + unpackedImageData.bandOffsets[2]] & 0xFF;
                if (!this.histogram.insert(n9 & this.mask)) {
                    --this.bits;
                    return;
                }
                n8 += n4;
            }
            n6 += n3;
        }
    }

    public void medianCut(int n) {
        this.partition = new Cube[n];
        int n2 = 0;
        Cube cube = new Cube();
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.histogramSize) {
            if (this.counts[n4] != 0) {
                ++n3;
                cube.count += this.counts[n4];
            }
            ++n4;
        }
        cube.lower = 0;
        cube.upper = n3 - 1;
        cube.level = 0;
        this.shrinkCube(cube);
        this.partition[n2++] = cube;
        while (n2 < n) {
            n4 = 255;
            int n5 = -1;
            int n6 = 0;
            while (n6 < n2) {
                if (this.partition[n6].lower != this.partition[n6].upper && this.partition[n6].level < n4) {
                    n4 = this.partition[n6].level;
                    n5 = n6;
                }
                ++n6;
            }
            if (n5 == -1) break;
            cube = this.partition[n5];
            n4 = cube.level;
            int n7 = 77 * (cube.rmax - cube.rmin);
            int n8 = 150 * (cube.gmax - cube.gmin);
            int n9 = 29 * (cube.bmax - cube.bmin);
            int n10 = 0;
            if (n7 >= n8 && n7 >= n9) {
                n10 = 0xFF0000;
            }
            if (n8 >= n7 && n8 >= n9) {
                n10 = 65280;
            }
            if (n9 >= n7 && n9 >= n8) {
                n10 = 255;
            }
            this.quickSort(this.colors, cube.lower, cube.upper, n10);
            int n11 = 0;
            int n12 = cube.lower;
            while (n12 <= cube.upper - 1) {
                if (n11 >= cube.count / 2) break;
                n11 += this.counts[n12];
                ++n12;
            }
            Cube cube2 = new Cube();
            cube2.lower = cube.lower;
            cube2.upper = n12 - 1;
            cube2.count = n11;
            cube2.level = cube.level + 1;
            this.shrinkCube(cube2);
            this.partition[n5] = cube2;
            Cube cube3 = new Cube();
            cube3.lower = n12;
            cube3.upper = cube.upper;
            cube3.count = cube.count - n11;
            cube3.level = cube.level + 1;
            this.shrinkCube(cube3);
            this.partition[n2++] = cube3;
        }
        this.createLUT(n2);
    }

    private void shrinkCube(Cube cube) {
        int n = 255;
        int n2 = 0;
        int n3 = 255;
        int n4 = 0;
        int n5 = 255;
        int n6 = 0;
        int n7 = cube.lower;
        while (n7 <= cube.upper) {
            int n8 = this.colors[n7];
            int n9 = n8 >> 16;
            int n10 = n8 >> 8 & 0xFF;
            int n11 = n8 & 0xFF;
            if (n9 > n2) {
                n2 = n9;
            } else if (n9 < n) {
                n = n9;
            }
            if (n10 > n4) {
                n4 = n10;
            } else if (n10 < n3) {
                n3 = n10;
            }
            if (n11 > n6) {
                n6 = n11;
            } else if (n11 < n5) {
                n5 = n11;
            }
            ++n7;
        }
        cube.rmin = n;
        cube.rmax = n2;
        cube.gmin = n3;
        cube.gmax = n4;
        cube.bmin = n5;
        cube.bmax = n6;
    }

    private void createLUT(int n) {
        if (this.colorMap == null) {
            this.colorMap = new LookupTableJAI(new byte[3][n]);
        }
        byte[] byArray = this.colorMap.getByteData(0);
        byte[] byArray2 = this.colorMap.getByteData(1);
        byte[] byArray3 = this.colorMap.getByteData(2);
        float f = 255.0f / (float)(this.mask & 0xFF);
        int n2 = 0;
        while (n2 < n) {
            Cube cube = this.partition[n2];
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n3 = cube.lower;
            while (n3 <= cube.upper) {
                int n4 = this.colors[n3];
                int n5 = n4 >> 16;
                f2 += (float)n5 * (float)this.counts[n3];
                int n6 = n4 >> 8 & 0xFF;
                f3 += (float)n6 * (float)this.counts[n3];
                int n7 = n4 & 0xFF;
                f4 += (float)n7 * (float)this.counts[n3];
                ++n3;
            }
            byArray[n2] = (byte)(f2 / (float)cube.count * f);
            byArray2[n2] = (byte)(f3 / (float)cube.count * f);
            byArray3[n2] = (byte)(f4 / (float)cube.count * f);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(int[] var1_1, int var2_2, int var3_3, int var4_4) {
        block5: {
            var5_5 = var2_2;
            var6_6 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var7_7 = var1_1[(var2_2 + var3_3) / 2] & var4_4;
            ** GOTO lbl21
            {
                ++var5_5;
                do {
                    if (var5_5 < var3_3 && (var1_1[var5_5] & var4_4) < var7_7) continue block0;
                    while (var6_6 > var2_2 && (var1_1[var6_6] & var4_4) > var7_7) {
                        --var6_6;
                    }
                    if (var5_5 > var6_6) continue;
                    var8_8 = var1_1[var5_5];
                    var1_1[var5_5] = var1_1[var6_6];
                    var1_1[var6_6] = var8_8;
                    var8_8 = this.counts[var5_5];
                    this.counts[var5_5] = this.counts[var6_6];
                    this.counts[var6_6] = var8_8;
                    ++var5_5;
                    --var6_6;
lbl21:
                    // 3 sources

                } while (var5_5 <= var6_6);
            }
            if (var2_2 < var6_6) {
                this.quickSort(var1_1, var2_2, var6_6, var4_4);
            }
            if (var5_5 < var3_3) {
                this.quickSort(var1_1, var5_5, var3_3, var4_4);
            }
        }
    }
}

