/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.MaxFilterPlusOpImage;
import com.sun.media.jai.opimage.MaxFilterSeparableOpImage;
import com.sun.media.jai.opimage.MaxFilterSquareOpImage;
import com.sun.media.jai.opimage.MaxFilterXOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.operator.MaxFilterDescriptor;
import javax.media.jai.operator.MaxFilterShape;

public class MaxFilterRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        MaxFilterShape maxFilterShape = (MaxFilterShape)parameterBlock.getObjectParameter(0);
        int n = parameterBlock.getIntParameter(1);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (maxFilterShape.equals(MaxFilterDescriptor.MAX_MASK_SQUARE)) {
            return new MaxFilterSquareOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        if (maxFilterShape.equals(MaxFilterDescriptor.MAX_MASK_PLUS)) {
            return new MaxFilterPlusOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        if (maxFilterShape.equals(MaxFilterDescriptor.MAX_MASK_X)) {
            return new MaxFilterXOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        if (maxFilterShape.equals(MaxFilterDescriptor.MAX_MASK_SQUARE_SEPARABLE)) {
            return new MaxFilterSeparableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, n);
        }
        return null;
    }
}

