/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.SourcelessOpImage;

final class ImageFunctionOpImage
extends SourcelessOpImage {
    protected ImageFunction function;
    protected float xScale;
    protected float yScale;
    protected float xTrans;
    protected float yTrans;

    private static SampleModel sampleModelHelper(int n, ImageLayout imageLayout) {
        SampleModel sampleModel;
        if (imageLayout != null && imageLayout.isValid(256)) {
            sampleModel = imageLayout.getSampleModel(null);
            if (sampleModel.getNumBands() != n) {
                throw new RuntimeException(JaiI18N.getString("ImageFunctionRIF0"));
            }
        } else {
            sampleModel = RasterFactory.createBandedSampleModel(4, 1, 1, n);
        }
        return sampleModel;
    }

    public ImageFunctionOpImage(ImageFunction imageFunction, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, Map map, ImageLayout imageLayout) {
        super(imageLayout, map, ImageFunctionOpImage.sampleModelHelper(imageFunction.getNumElements() * (imageFunction.isComplex() ? 2 : 1), imageLayout), n, n2, n3, n4);
        this.function = imageFunction;
        this.xScale = f;
        this.yScale = f2;
        this.xTrans = f3;
        this.yTrans = f4;
    }

    @Override
    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.sampleModel.getTransferType();
        int n2 = this.sampleModel.getNumBands();
        int n3 = this.width * this.height;
        Object object = n == 5 ? (this.function.isComplex() ? (Object)new double[2][n3] : new double[n3]) : (Object)(this.function.isComplex() ? (Object)new float[2][n3] : new float[n3]);
        if (n == 5) {
            Object object2 = this.function.isComplex() ? ((double[][])object)[0] : object;
            double[] dArray = this.function.isComplex() ? ((double[][])object)[1] : null;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                this.function.getElements((double)(this.xScale * ((float)rectangle.x - this.xTrans)), (double)(this.yScale * ((float)rectangle.y - this.yTrans)), (double)this.xScale, (double)this.yScale, rectangle.width, rectangle.height, n4++, (double[])object2, dArray);
                writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5, (double[])object2);
                if (this.function.isComplex()) {
                    writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, ++n5, dArray);
                }
                ++n5;
            }
        } else {
            float[] fArray = this.function.isComplex() ? ((float[][])object)[0] : (float[])object;
            float[] fArray2 = this.function.isComplex() ? ((float[][])object)[1] : null;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                this.function.getElements(this.xScale * ((float)rectangle.x - this.xTrans), this.yScale * ((float)rectangle.y - this.yTrans), this.xScale, this.yScale, rectangle.width, rectangle.height, n6++, fArray, fArray2);
                writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n7, fArray);
                if (this.function.isComplex()) {
                    writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, ++n7, fArray2);
                }
                ++n7;
            }
        }
    }
}

