/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class GradientOpImage
extends AreaOpImage {
    protected KernelJAI kernel_h;
    protected KernelJAI kernel_v;
    private int kw;
    private int kh;

    public GradientOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI, KernelJAI kernelJAI2) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel_h = kernelJAI;
        this.kernel_v = kernelJAI2;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
    }

    @Override
    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            f += (float)(byArray4[n18] & 0xFF) * fArray[n15 + n19];
                            f2 += (float)(byArray4[n18] & 0xFF) * fArray2[n15 + n19];
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    float f3 = f * f;
                    float f4 = f2 * f2;
                    float f5 = (float)Math.sqrt(f3 + f4);
                    int n20 = (int)(f5 + 0.5f);
                    if (n20 < 0) {
                        n20 = 0;
                    } else if (n20 > 255) {
                        n20 = 255;
                    }
                    byArray3[n13] = (byte)n20;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            f += (float)sArray4[n18] * fArray[n15 + n19];
                            f2 += (float)sArray4[n18] * fArray2[n15 + n19];
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    float f3 = f * f;
                    float f4 = f2 * f2;
                    float f5 = (float)Math.sqrt(f3 + f4);
                    int n20 = (int)(f5 + 0.5f);
                    if (n20 < Short.MIN_VALUE) {
                        n20 = Short.MIN_VALUE;
                    } else if (n20 > Short.MAX_VALUE) {
                        n20 = Short.MAX_VALUE;
                    }
                    sArray3[n13] = (short)n20;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            f += (float)(sArray4[n18] & 0xFFFF) * fArray[n15 + n19];
                            f2 += (float)(sArray4[n18] & 0xFFFF) * fArray2[n15 + n19];
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    float f3 = f * f;
                    float f4 = f2 * f2;
                    float f5 = (float)Math.sqrt(f3 + f4);
                    int n20 = (int)(f5 + 0.5f);
                    if (n20 < 0) {
                        n20 = 0;
                    } else if (n20 > 65535) {
                        n20 = 65535;
                    }
                    sArray3[n13] = (short)n20;
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray[n8];
            int[] nArray6 = nArray3[n8];
            int n9 = nArray4[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            f += (float)nArray6[n18] * fArray[n15 + n19];
                            f2 += (float)nArray6[n18] * fArray2[n15 + n19];
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    float f3 = f * f;
                    float f4 = f2 * f2;
                    float f5 = (float)Math.sqrt(f3 + f4);
                    nArray5[n13] = (int)(f5 + 0.5f);
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray5 = fArray3[n8];
            float[] fArray6 = fArray4[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    float f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            f2 += fArray6[n18] * fArray[n15 + n19];
                            f3 += fArray6[n18] * fArray2[n15 + n19];
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    float f4 = f2 * f2;
                    float f5 = f3 * f3;
                    fArray5[n13] = f = (float)Math.sqrt(f4 + f5);
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel_h.getKernelData();
        float[] fArray2 = this.kernel_v.getKernelData();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    double d;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    int n15 = 0;
                    int n16 = n12;
                    int n17 = 0;
                    while (n17 < this.kh) {
                        int n18 = n16;
                        int n19 = 0;
                        while (n19 < this.kw) {
                            d2 += dArray4[n18] * (double)fArray[n15 + n19];
                            d3 += dArray4[n18] * (double)fArray2[n15 + n19];
                            n18 += n6;
                            ++n19;
                        }
                        n15 += this.kw;
                        n16 += n7;
                        ++n17;
                    }
                    double d4 = d2 * d2;
                    double d5 = d3 * d3;
                    dArray3[n13] = d = Math.sqrt(d4 + d5);
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }
}

